/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.cliente.view;

import br.com.system.app.components.containers.FooterContainer;
import br.com.system.app.features.cliente.model.Cliente;
import br.com.system.app.features.estrutura.model.EstruturaUsuario;
import br.com.system.app.features.estrutura.service.EstruturaUsuarioService;
import br.com.system.app.features.layout.UIUtils;
import br.com.system.app.features.pedido.dto.PedidoResumeDTO;
import br.com.system.app.features.pedido.model.Pedido;
import br.com.system.app.features.pedido.service.PedidoService;
import br.com.system.app.features.pedido.view.atividade.AtividadeView;
import br.com.system.app.security.SecurityContext;
import br.com.system.commons.datetime.FormatDate;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.ItemLabelGenerator;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.dialog.Dialog;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.data.renderer.ComponentRenderer;
import com.vaadin.flow.data.renderer.Renderer;
import com.vaadin.flow.data.renderer.TextRenderer;
import com.vaadin.flow.function.SerializableFunction;
import java.io.Serializable;
import java.util.Collection;

public class ClienteAtividadeView
extends Dialog
implements SecurityContext {
    private static final long serialVersionUID = 1L;
    private final PedidoService pedidoService;
    private final Cliente cliente;
    private Grid<PedidoResumeDTO> grid;
    private final EstruturaUsuario eu;
    private final Button btnClose;
    private final AtividadeView atividadeView;
    private final EstruturaUsuarioService eus;

    public ClienteAtividadeView(Cliente cliente, EstruturaUsuario eu, PedidoService pedidoService, AtividadeView atividadeView, EstruturaUsuarioService eus) {
        this.pedidoService = pedidoService;
        this.eus = eus;
        this.cliente = cliente;
        this.atividadeView = atividadeView;
        this.eu = eu;
        this.btnClose = UIUtils.createSmallButton((String)"Fechar");
        if (this.hasPermission("ATIVIDADE_VIEW")) {
            this.init();
        } else {
            UIUtils.showNotification((String)"Voc\u00ea n\u00e3o tem Permiss\u00e3o para visualisar as atividades desse cliente");
        }
    }

    public Button getCloseButton() {
        return this.btnClose;
    }

    private void povoa() {
        this.grid.setItems((Collection)this.pedidoService.getForResume(this.eu, this.cliente.getCpfCnpj()));
    }

    private void init() {
        this.setWidth("900px");
        this.grid = new Grid(PedidoResumeDTO.class);
        this.grid.setColumns(new String[0]);
        this.grid.addColumn((Renderer)new TextRenderer((ItemLabelGenerator & Serializable)p -> p.getTipoAtividade())).setFlexGrow(0).setWidth("130px").setHeader("Tipo");
        this.grid.addColumn((Renderer)new TextRenderer((ItemLabelGenerator & Serializable)p -> p.getNumero())).setFlexGrow(0).setWidth("180px").setHeader("N\u00famero");
        this.grid.addColumn((Renderer)new ComponentRenderer((SerializableFunction & Serializable)p -> UIUtils.createBreakWrapSpan((String)p.getStatus()))).setHeader("Status").setFlexGrow(0).setWidth("200px");
        this.grid.addColumn((Renderer)new TextRenderer((ItemLabelGenerator & Serializable)p -> p.getDataCadastro() == null ? "" : p.getDataCadastro().format(FormatDate.DATE_BR.toDTF()))).setFlexGrow(0).setWidth("150px").setHeader("Cria\u00e7\u00e3o");
        this.grid.addColumn((Renderer)new TextRenderer((ItemLabelGenerator & Serializable)p -> p.getDataHoraAtualizacao() == null ? "" : p.getDataHoraAtualizacao().format(FormatDate.DATETIME_BR.toDTF()))).setFlexGrow(0).setWidth("180px").setHeader("Atualiza\u00e7\u00e3o");
        this.grid.addColumn((Renderer)new TextRenderer((ItemLabelGenerator & Serializable)p -> p.getDataRetornoFuturo() == null ? "" : p.getDataRetornoFuturo().format(FormatDate.DATE_BR.toDTF()))).setFlexGrow(0).setWidth("180px").setHeader("Retorno Futuro");
        this.grid.addColumn((Renderer)new ComponentRenderer((SerializableFunction & Serializable)p -> UIUtils.createBreakWrapSpan((String)p.getLogin()))).setHeader("Usu\u00e1rio").setFlexGrow(0).setWidth("250px");
        this.grid.addColumn((Renderer)new ComponentRenderer((SerializableFunction & Serializable)p -> UIUtils.createBreakWrapSpan((String)p.getTags()))).setHeader("Tags").setFlexGrow(0).setWidth("200px");
        this.grid.addColumn((Renderer)new ComponentRenderer((SerializableFunction & Serializable)eg -> {
            PedidoResumeDTO pr = eg;
            Button btn = UIUtils.createSmallButton((String)"Abrir");
            btn.setEnabled(this.hasPermission("ATIVIDADE_VIEW"));
            btn.setVisible(false);
            btn.addClickListener((ComponentEventListener & Serializable)op -> {
                Pedido pedido = this.pedidoService.getById(pr.getId());
                this.abrePedido(pedido);
            });
            if (this.eus.naHierarquia(this.getEu(), pr.getEstruturaUsuarioId())) {
                btn.setVisible(true);
            }
            return btn;
        })).setFlexGrow(0).setWidth("150px");
        this.povoa();
        this.add(new Component[]{UIUtils.createHeader((String)"Atividades do Cliente")});
        this.add(new Component[]{this.grid});
        this.add(new Component[]{new FooterContainer(new Component[]{this.btnClose})});
    }

    private void abrePedido(Pedido pedido) {
        this.atividadeView.create(pedido, this.getEu(), pedido.getPedidoTipo());
        this.atividadeView.getBtnSalvar().setEnabled(pedido.getEstruturaUsuario().getId().equals(this.getEu().getId()));
    }
}

