/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.cliente.view;

import br.com.system.app.MainLayout;
import br.com.system.app.components.ConfirmationDialog;
import br.com.system.app.components.ListField;
import br.com.system.app.components.ListFieldTypeEnum;
import br.com.system.app.components.containers.HorizontalContainer;
import br.com.system.app.components.containers.VerticalContainer;
import br.com.system.app.features.cliente.model.ClienteTag;
import br.com.system.app.features.cliente.service.ClienteService;
import br.com.system.app.features.cliente.service.ClienteTagService;
import br.com.system.app.features.layout.UIUtils;
import br.com.system.app.features.layout.ViewFrame;
import br.com.system.app.security.SecurityContext;
import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.button.ButtonVariant;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.data.renderer.ComponentRenderer;
import com.vaadin.flow.data.renderer.Renderer;
import com.vaadin.flow.function.SerializableFunction;
import com.vaadin.flow.router.PageTitle;
import com.vaadin.flow.router.Route;
import jakarta.annotation.security.RolesAllowed;
import java.io.Serializable;
import java.util.List;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.vaadin.crudui.crud.CrudListener;
import org.vaadin.crudui.crud.impl.GridCrud;

@Route(value="cliente-tag-cadastro", layout=MainLayout.class)
@PageTitle(value="Cadastro de tags do Cliente")
@RolesAllowed(value={"CLIENTE_TAG_CADASTRO_VIEW"})
public class ClienteTagCadastroView
extends ViewFrame
implements SecurityContext {
    private static final long serialVersionUID = 1L;
    private final ClienteTagService cts;
    private final ClienteService clienteService;
    private GridCrud<ClienteTag> crud;
    private final Span lblTotal = new Span();

    public ClienteTagCadastroView(ClienteTagService cts, ClienteService clienteService) {
        this.cts = cts;
        this.clienteService = clienteService;
    }

    protected void onAttach(AttachEvent attachEvent) {
        super.onAttach(attachEvent);
        if (this.autenticado()) {
            this.setViewContent((Component)this.createContent());
        } else {
            this.showNotification("Sem permiss\u00e3o");
        }
    }

    private VerticalContainer createContent() {
        ListField txtFiltro = new ListField(ListFieldTypeEnum.GENERIC_STRING, "Filtrar Tags");
        Button btnExcluir = UIUtils.createButton((String)"Excluir Todas", (String)"Excluir todas as tags da consulta", (ButtonVariant[])new ButtonVariant[0]);
        btnExcluir.setVisible(this.isMaster());
        btnExcluir.addClickListener((ComponentEventListener & Serializable)e -> {
            Long total = this.cts.countByEstrutura(this.getEstrutura(), txtFiltro.getValue());
            if (total <= 0L) {
                this.showNotification("N\u00e3o h\u00e1 nada para excluir");
                return;
            }
            ConfirmationDialog cd = new ConfirmationDialog("Exclusao TAGS", "Voc\u00ea est\u00e1 prestes a excluir " + total + " tags. Esse processo n\u00e3o tem volta. tem certeza que deseja continuar?");
            cd.getCancel().addClickListener((ComponentEventListener & Serializable)can -> cd.close());
            cd.getConfirm().addClickListener((ComponentEventListener & Serializable)conf -> {
                List tags = this.cts.getByEstrutura(this.getEstrutura(), txtFiltro.getValue(), (Pageable)PageRequest.of((int)0, (int)total.intValue()));
                this.excluir(tags);
                cd.close();
            });
        });
        Button btnrefresh = UIUtils.createButton((String)"Pesquisar", (String)"Pesquisar", (ButtonVariant[])new ButtonVariant[0]);
        btnrefresh.setDisableOnClick(true);
        btnrefresh.addClickListener((ComponentEventListener & Serializable)e -> {
            this.crud.refreshGrid();
            btnrefresh.setEnabled(true);
        });
        this.crud = new GridCrud(ClienteTag.class);
        this.crud.getAddButton().setText("Adicionar");
        this.crud.getGrid().setColumns(new String[0]);
        this.crud.getGrid().addColumn((Renderer)new ComponentRenderer((SerializableFunction & Serializable)p -> UIUtils.createBreakWrapSpan((String)p.getTag()))).setHeader("Tag").setFlexGrow(0).setWidth("250px");
        this.crud.getCrudFormFactory().setUseBeanValidation(true);
        this.crud.getCrudFormFactory().setVisibleProperties(new String[]{"tag"});
        this.crud.getAddButton().setVisible(this.hasPermission("ATIVIDADE_TAG_CADASTRO_SAVE"));
        this.crud.getUpdateButton().setVisible(this.hasPermission("ATIVIDADE_TAG_CADASTRO_SAVE"));
        this.crud.getDeleteButton().setVisible(this.hasPermission("ATIVIDADE_TAG_CADASTRO_DELETE"));
        this.crud.setCrudListener((CrudListener)new /* Unavailable Anonymous Inner Class!! */);
        HorizontalContainer h = new HorizontalContainer(new Component[]{this.lblTotal, txtFiltro, btnrefresh, btnExcluir});
        VerticalContainer v = new VerticalContainer(new Component[]{h, this.crud});
        v.setHeight("100%");
        return v;
    }

    private void excluir(List<ClienteTag> items) {
        this.clienteService.removerTag(items, this.getEu());
        for (ClienteTag item : items) {
            this.cts.delete(item);
        }
        this.showNotification("Tag dos cliente(s) excluida(s) com sucessso, pode conferir o resultado em notificacoes");
    }

    private void excluir(ClienteTag item) {
        try {
            this.clienteService.removerTag(item, this.getEu());
            this.cts.delete(item);
        }
        catch (Exception e) {
            this.showNotification(e.getMessage());
        }
    }
}

