/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.cliente.view.form;

import br.com.system.app.components.ConfirmationDialog;
import br.com.system.app.components.containers.HorizontalContainer;
import br.com.system.app.features.cliente.model.Cliente;
import br.com.system.app.features.cliente.model.ClienteContato;
import br.com.system.app.features.cliente.model.ClienteContatoVerficadoEnum;
import br.com.system.app.features.cliente.model.TipoContatoEnum;
import br.com.system.app.features.cliente.service.ClienteService;
import br.com.system.app.features.estrutura.model.Estrutura;
import br.com.system.app.features.layout.UIUtils;
import br.com.system.app.features.layout.util.BorderStyle;
import br.com.system.app.features.shared.service.TelefoneService;
import br.com.system.app.features.whatsapp.WhatsAppAtendimentoDialog;
import br.com.system.app.features.whatsapp.model.WhatsApp;
import br.com.system.app.features.whatsapp.model.WhatsAppConta;
import br.com.system.app.features.whatsapp.model.WhatsAppEtapaEnum;
import br.com.system.app.features.whatsapp.model.WhatsAppFuncaoEnum;
import br.com.system.app.features.whatsapp.model.WhatsAppHave;
import br.com.system.app.features.whatsapp.service.WhatsAppContaService;
import br.com.system.app.features.whatsapp.service.WhatsAppHaveService;
import br.com.system.app.features.whatsapp.service.WhatsAppService;
import br.com.system.app.security.SecurityContext;
import br.com.system.commons.StringUtil;
import br.com.system.commons.TelefoneUtil;
import br.com.system.commons.ValidationUtil;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.DetachEvent;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.combobox.ComboBox;
import com.vaadin.flow.component.html.Hr;
import com.vaadin.flow.component.html.Image;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.component.textfield.EmailField;
import com.vaadin.flow.component.textfield.TextField;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.stereotype.Component;

@Component
@Scope(value="request", proxyMode=ScopedProxyMode.TARGET_CLASS)
public class ClienteFormWhats
extends VerticalLayout
implements SecurityContext {
    private static final long serialVersionUID = 1L;
    @Autowired
    private WhatsAppService whatsAppService;
    @Autowired
    private WhatsAppContaService whatsappContaService;
    @Autowired
    private WhatsAppAtendimentoDialog whatsAppConversasDialog;
    @Autowired
    private WhatsAppHaveService haveService;
    @Autowired
    private TelefoneService telefoneService;
    @Autowired
    private ClienteService clienteService;
    private Image anchorTel;
    private Cliente cliente;
    private Consumer<Cliente> listener;

    protected void onDetach(DetachEvent detachEvent) {
        super.onDetach(detachEvent);
    }

    public WhatsAppHave getHave(String numero) {
        return this.haveService.getHave(numero);
    }

    public boolean temBusiness(Estrutura e) {
        return !this.whatsappContaService.getContaByEstruturaAtendimento(e).isEmpty();
    }

    public VerticalLayout create(Cliente cli, boolean novo, Consumer<Cliente> listener) {
        this.cliente = cli;
        this.listener = listener;
        this.removeAll();
        this.setMargin(false);
        this.setPadding(false);
        this.setSpacing(false);
        this.removeAll();
        this.setEnabled(this.cliente != null && this.cliente.getId() != null);
        this.add(new com.vaadin.flow.component.Component[]{new Hr()});
        this.add(new com.vaadin.flow.component.Component[]{UIUtils.createHeader((String)"Cadastro WhatsApp")});
        UIUtils.setBorder((BorderStyle)BorderStyle.GROOVE, (com.vaadin.flow.component.Component[])new com.vaadin.flow.component.Component[]{this});
        if (this.cliente == null || this.cliente.getCpfCnpj() == null) {
            return this;
        }
        Button btnInsertWhats = UIUtils.createSmallButton((String)"Inserir", (VaadinIcon)VaadinIcon.PLUS, (String)"Inserir novo cadastro");
        btnInsertWhats.setVisible(this.hasPermission("ATENDIMENTO_CADASTRO_CREATE"));
        btnInsertWhats.addClickListener((ComponentEventListener & Serializable)e -> this.create(this.cliente, true, listener));
        VerticalLayout content = new VerticalLayout();
        this.add(new com.vaadin.flow.component.Component[]{content, btnInsertWhats});
        List wl = this.whatsAppService.getByCpfCnpj(this.cliente.getCpfCnpj(), this.getEstrutura());
        if (novo) {
            List contas = this.whatsappContaService.getContaByEstruturaAtendimento(this.getEstrutura());
            if (contas.size() <= 0) {
                UIUtils.showNotification((String)"N\u00e3o h\u00e1 conta de whatsapp cadastrada");
                return this;
            }
            WhatsAppConta conta = (WhatsAppConta)contas.get(0);
            WhatsApp wn = new WhatsApp();
            wn.setCnpjEscolhido(this.cliente.getCpfCnpj());
            wn.setCpfCnpj(this.cliente.getCpfCnpj());
            wn.setDataHoraCriacao(LocalDateTime.now());
            wn.setEtapa(WhatsAppEtapaEnum.FECHADO);
            wn.setUltimoAtendente(this.getEu());
            wn.setWhatsappConta(conta);
            wl = wl == null ? new ArrayList() : wl;
            wl.add(wn);
        }
        if (wl == null) {
            return this;
        }
        for (WhatsApp w : wl) {
            HorizontalContainer h = new HorizontalContainer(new com.vaadin.flow.component.Component[0]);
            this.anchorTel = new Image("images/phone20.png", "3CX");
            TextField txtTelefone = new TextField("N\u00famero");
            if (w.getNumero() != null) {
                this.anchorTel.setWidth("20px");
                this.anchorTel.setHeight("20px");
                txtTelefone.setValue(w.getNumero());
                if (!this.hasPermission("IGNORAR_NAO_PERTURBE") && this.telefoneService.isNaoPerturbe(txtTelefone.getValue())) {
                    this.anchorTel.setVisible(false);
                }
                this.anchorTel.addClickListener((ComponentEventListener & Serializable)e -> UI.getCurrent().getPage().executeJs("window.open('https://neocrm.my3cx.com.br/webclient/#/people?phone=" + txtTelefone.getValue() + "','3cxWindow','width=500,height=500')", new Serializable[0]));
            } else {
                this.anchorTel.setVisible(false);
            }
            txtTelefone.setReadOnly(!this.hasPermission("ATENDIMENTO_CADASTRO_CREATE"));
            txtTelefone.setWidth("160px");
            TextField txtWNome = new TextField("Nome");
            txtWNome.setValue(w.getNome() == null ? "" : w.getNome());
            txtWNome.setReadOnly(!this.hasPermission("ATENDIMENTO_CADASTRO_CHANGE"));
            EmailField txtWEmail = new EmailField("E-mail");
            txtWEmail.setValue(w.getEmail() == null ? "" : w.getEmail());
            txtWEmail.setReadOnly(!this.hasPermission("ATENDIMENTO_CADASTRO_CHANGE"));
            TextField txtWFuncao = new TextField("Fun\u00e7\u00e3o");
            txtWFuncao.setValue(w.getFuncao() == null ? "" : w.getFuncao().name());
            txtWFuncao.setReadOnly(!this.hasPermission("ATENDIMENTO_CADASTRO_CHANGE"));
            ComboBox cbFuncao = new ComboBox("Fun\u00e7\u00e3o", (Object[])WhatsAppFuncaoEnum.values());
            cbFuncao.setValue((Object)w.getFuncao());
            cbFuncao.setItemLabelGenerator(Enum::name);
            Button btnDesvincular = UIUtils.createSmallButton((String)"Desvincular");
            btnDesvincular.setEnabled(w.getId() != null);
            btnDesvincular.addClickListener((ComponentEventListener & Serializable)e -> {
                ConfirmationDialog cd = new ConfirmationDialog("Desvincular", "Tem certeza que deseja desvincular esse n\u00famero de whatsapp deste cliente?");
                cd.getCancel().addClickListener((ComponentEventListener & Serializable)cancel -> cd.close());
                cd.getConfirm().addClickListener((ComponentEventListener & Serializable)conf -> {
                    cd.close();
                    w.setCpfCnpj(StringUtil.removeItemFromStringList((String)w.getCpfCnpj(), (String)this.cliente.getCpfCnpj()));
                    this.whatsAppService.save(w);
                    UIUtils.showNotification((String)"Salvo com sucesso");
                    h.setEnabled(false);
                });
            });
            Button btnSave = UIUtils.createSmallButton((String)"Salvar");
            btnSave.setVisible(this.hasPermission("ATENDIMENTO_CADASTRO_CHANGE"));
            btnSave.addClickListener((ComponentEventListener & Serializable)e -> {
                List contas;
                String numero = StringUtil.numbersOnly((String)txtTelefone.getValue());
                if (!TelefoneUtil.isValid((String)numero)) {
                    UIUtils.showNotification((String)"Telefone inv\u00e1lido");
                    return;
                }
                WhatsAppHave have = this.haveService.getHave(numero);
                if (have == null) {
                    UIUtils.showNotification((String)"Este n\u00famero n\u00e3o tem whatsapp");
                    return;
                }
                if (!have.getHave().booleanValue()) {
                    UIUtils.showNotification((String)"Este n\u00famero n\u00e3o tem whatsapp");
                    return;
                }
                if (txtWNome.getValue() == null || txtWNome.getValue().isEmpty()) {
                    UIUtils.showNotification((String)"Nome \u00e9 obrigat\u00f3rio");
                    return;
                }
                if (!ValidationUtil.isValidEmail((String)txtWEmail.getValue())) {
                    UIUtils.showNotification((String)"E-mail \u00e9 obrigat\u00f3rio");
                    return;
                }
                if (cbFuncao.getValue() == null) {
                    UIUtils.showNotification((String)"Fun\u00e7\u00e3o \u00e9 obrigat\u00f3rio");
                    return;
                }
                Object wc = this.getUsuario().getWhatsappConta() != null ? this.getUsuario().getWhatsappConta() : ((contas = this.whatsappContaService.getContaByEstruturaAndAtendimentoAndMarketing(this.getEstrutura(), true, false)).size() <= 0 ? null : (WhatsAppConta)contas.get(0));
                WhatsApp wExists = this.whatsAppService.getAtendimentoByNumero(wc, have.getNumeroWhats());
                if (wExists != null) {
                    wExists.setNumero(have.getNumeroWhats());
                    wExists.setNome(txtWNome.getValue());
                    wExists.setEmail(txtWEmail.getValue());
                    wExists.setFuncao((WhatsAppFuncaoEnum)cbFuncao.getValue());
                    if (wExists.getCpfCnpj() == null || wExists.getCpfCnpj().equals("null") || wExists.getCpfCnpj().isEmpty()) {
                        wExists.setCpfCnpj(this.cliente.getCpfCnpj());
                        this.salvar(wExists);
                    } else if (wExists.getCpfCnpj().contains(this.cliente.getCpfCnpj())) {
                        this.salvar(wExists);
                    } else {
                        ConfirmationDialog cd = new ConfirmationDialog("Ja existe", "Este n\u00famero j\u00e1 est\u00e1 vinculado ao(s) Cnpj(s) " + wExists.getCpfCnpj() + ". Deseja incluir mais este cnpj?");
                        cd.getCancel().addClickListener((ComponentEventListener & Serializable)ec -> cd.close());
                        cd.getConfirm().addClickListener((ComponentEventListener & Serializable)ec -> {
                            wExists.setCpfCnpj(wExists.getCpfCnpj() + "," + this.cliente.getCpfCnpj());
                            this.salvar(wExists);
                            cd.close();
                        });
                    }
                } else {
                    if (w.getNumero() == null) {
                        w.setNumero(have.getNumeroWhats());
                    }
                    w.setWhatsappConta(wc);
                    w.setNome(txtWNome.getValue());
                    w.setEmail(txtWEmail.getValue());
                    w.setFuncao((WhatsAppFuncaoEnum)cbFuncao.getValue());
                    this.salvar(w);
                }
            });
            h.add(new com.vaadin.flow.component.Component[]{txtTelefone, this.anchorTel, txtWNome, txtWEmail});
            if (this.hasPermission("ATENDIMENTO_CADASTRO_CHANGE")) {
                h.add(new com.vaadin.flow.component.Component[]{cbFuncao});
            } else {
                h.add(new com.vaadin.flow.component.Component[]{txtWFuncao});
            }
            Button btn = UIUtils.createSmallButton((String)"Conversas");
            btn.setEnabled(this.hasPermission("ATENDIMENTO_CONVERSAS_VIEW") && w.getId() != null);
            btn.addClickListener((ComponentEventListener & Serializable)e -> this.whatsAppConversasDialog.show(w, this.cliente.getCpfCnpj()));
            h.add(new com.vaadin.flow.component.Component[]{btn});
            if (this.hasPermission("ATENDIMENTO_CADASTRO_CHANGE")) {
                h.add(new com.vaadin.flow.component.Component[]{btnSave});
            }
            if (this.hasPermission("ATENDIMENTO_DESVINCULAR_CLIENTE")) {
                h.add(new com.vaadin.flow.component.Component[]{btnDesvincular});
            }
            content.add(new com.vaadin.flow.component.Component[]{h});
            content.add(new com.vaadin.flow.component.Component[]{new Hr()});
        }
        return this;
    }

    private void salvar(WhatsApp w) {
        if (w.getEmail() != null && ValidationUtil.isValidEmail((String)w.getEmail())) {
            ClienteContato cc = new ClienteContato(this.cliente, TipoContatoEnum.EMAIL, w.getEmail().trim().toLowerCase());
            if (!this.cliente.getClienteContato().contains(cc)) {
                cc.setVerificado(ClienteContatoVerficadoEnum.VALIDO);
                this.cliente.getClienteContato().add(cc);
                this.cliente = this.clienteService.salvar(this.cliente, this.getEu());
            } else {
                this.cliente.getClienteContato().forEach(e -> {
                    if (e.getTipo().equals((Object)TipoContatoEnum.EMAIL) && e.getValor().equals(w.getEmail())) {
                        e.setVerificado(ClienteContatoVerficadoEnum.VALIDO);
                        this.cliente = this.clienteService.salvar(this.cliente, this.getEu());
                    }
                });
            }
        }
        this.whatsAppService.save(w);
        if (this.listener != null) {
            this.listener.accept(this.cliente);
        }
        UIUtils.showNotification((String)"Salvo com sucesso");
        this.create(this.cliente, false, this.listener);
    }
}

