/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.cobranca;

import br.com.system.app.components.ConfirmationDialog;
import br.com.system.app.components.DownloadDialog;
import br.com.system.app.components.containers.FooterContainer;
import br.com.system.app.components.containers.HorizontalContainer;
import br.com.system.app.components.containers.VerticalContainer;
import br.com.system.app.features.cobranca.model.CobrancaAssinatura;
import br.com.system.app.features.cobranca.model.CobrancaAssinaturaAnexo;
import br.com.system.app.features.cobranca.service.CobrancaAssinaturaAnexoService;
import br.com.system.app.features.estrutura.model.EstruturaUsuario;
import br.com.system.app.features.layout.UIUtils;
import br.com.system.app.features.shared.exception.BusinessException;
import br.com.system.app.features.storage.StorageUtil;
import br.com.system.app.features.util.TempFileMultiBuffer;
import br.com.system.app.security.SecurityContext;
import br.com.system.commons.HashUtil;
import br.com.system.commons.StringUtil;
import br.com.system.commons.datetime.FormatDate;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.ItemLabelGenerator;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.button.ButtonVariant;
import com.vaadin.flow.component.dialog.Dialog;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.upload.Receiver;
import com.vaadin.flow.component.upload.Upload;
import com.vaadin.flow.data.renderer.ComponentRenderer;
import com.vaadin.flow.data.renderer.Renderer;
import com.vaadin.flow.data.renderer.TextRenderer;
import com.vaadin.flow.function.SerializableFunction;
import elemental.json.Json;
import elemental.json.JsonValue;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.util.Collection;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class CobrancaAssinaturaAnexoView
extends Dialog
implements SecurityContext {
    private static final long serialVersionUID = 1L;
    private final CobrancaAssinaturaAnexoService service;
    private final EstruturaUsuario eu;
    private final CobrancaAssinatura cobrancaAssinatura;
    private List<CobrancaAssinaturaAnexo> lista;
    private Grid<CobrancaAssinaturaAnexo> grid;
    private DownloadDialog exportDialog;

    public CobrancaAssinaturaAnexoView(CobrancaAssinaturaAnexoService service, EstruturaUsuario eu, CobrancaAssinatura cobrancaAssinatura) {
        this.service = service;
        this.cobrancaAssinatura = cobrancaAssinatura;
        this.eu = eu;
        if (this.hasPermission("ASSINATURA_ANEXO_VIEW")) {
            this.init();
        } else {
            UIUtils.showNotification((String)"Voc\u00ea n\u00e3o tem Permiss\u00e3o para visualisar anexos");
        }
    }

    private String getZip() {
        try {
            File zipFile = new File("/tmp/" + HashUtil.getUUI() + ".zip");
            ZipOutputStream zos = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(zipFile)));
            int ind = 0;
            for (CobrancaAssinaturaAnexo pa : this.lista) {
                InputStream is = StorageUtil.getObject((String)pa.getHashArquivo());
                ZipEntry ze = new ZipEntry(++ind + "-" + StringUtil.normalize((String)pa.getNomeArquivo()));
                zos.putNextEntry(ze);
                byte[] bytes = new byte[1024];
                int count = is.read(bytes);
                while (count > -1) {
                    zos.write(bytes, 0, count);
                    count = is.read(bytes);
                }
                is.close();
                zos.closeEntry();
            }
            zos.close();
            byte[] fileContent = Files.readAllBytes(zipFile.toPath());
            zipFile.delete();
            return StorageUtil.uploadObjectByteArray((String)(HashUtil.getUUI() + ".zip"), (byte[])fileContent);
        }
        catch (Exception e) {
            throw new BusinessException(e.getMessage());
        }
    }

    private void init() {
        this.exportDialog = new DownloadDialog();
        this.setWidth("910px");
        TempFileMultiBuffer buffer = new TempFileMultiBuffer();
        Upload upload = new Upload((Receiver)buffer);
        upload.setMaxFiles(30);
        Button btnDown = UIUtils.createButton((String)"Baixar Todos", (String)"Baixar todos os arquivos em ZIP", (ButtonVariant[])new ButtonVariant[0]);
        btnDown.addClickListener((ComponentEventListener & Serializable)e -> this.exportDialog.open(this.getZip(), "Cobranca-assinatura-anexo.zip", true));
        Button btnGravar = UIUtils.createSmallButton((String)"Gravar", (VaadinIcon)VaadinIcon.INBOX, (String)"Salvar registro");
        btnGravar.addClickListener((ComponentEventListener & Serializable)e -> {
            if (!this.hasPermission("ASSINATURA_ANEXO_SAVE")) {
                UIUtils.showNotification((String)"Sem permiss\u00e3o para incluir novos arquivos.");
                return;
            }
            if (buffer.getFiles().size() <= 0) {
                UIUtils.showNotification((String)"N\u00e3o h\u00e1 arquivos para gravar.");
                return;
            }
            this.service.save(this.cobrancaAssinatura, this.eu, buffer);
            upload.getElement().setPropertyJson("files", (JsonValue)Json.createArray());
            buffer.clear();
            this.povoa();
        });
        Button btnFechar = UIUtils.createSmallButton((String)"Fechar", (VaadinIcon)VaadinIcon.CLOSE, (String)"");
        btnFechar.addClickListener((ComponentEventListener & Serializable)e -> this.close());
        this.add(new Component[]{new VerticalContainer(new Component[]{upload, this.createGrid(), new FooterContainer(new Component[]{btnFechar, btnDown, btnGravar})})});
        this.open();
    }

    private void povoa() {
        this.lista = this.service.getByCobrancaAssinatura(this.cobrancaAssinatura);
        this.grid.setItems((Collection)this.lista);
    }

    private HorizontalContainer createGrid() {
        this.grid = new Grid(CobrancaAssinaturaAnexo.class);
        this.grid.setColumns(new String[0]);
        this.grid.setWidth("860px");
        if (this.hasPermission("ASSINATURA_ANEXO_DELETE")) {
            this.grid.addColumn((Renderer)new ComponentRenderer((SerializableFunction & Serializable)eg -> {
                Button btn = UIUtils.createSmallButton((VaadinIcon)VaadinIcon.TRASH, (String)"Excluir anexo");
                btn.addClickListener((ComponentEventListener & Serializable)del -> {
                    ConfirmationDialog cd = new ConfirmationDialog("Exclus\u00e3o", "Confirma exclus\u00e3o do anexo?");
                    cd.getCancel().addClickListener((ComponentEventListener & Serializable)cancel -> cd.close());
                    cd.getConfirm().addClickListener((ComponentEventListener & Serializable)conf -> {
                        this.service.delete(eg);
                        cd.close();
                        this.povoa();
                    });
                });
                return btn;
            })).setFlexGrow(0).setWidth("50px");
        }
        this.grid.addColumn((Renderer)new ComponentRenderer((SerializableFunction & Serializable)e -> UIUtils.createBreakWrapSpan((String)e.getNomeArquivo()))).setHeader("Nome Arquivo").setFlexGrow(0).setWidth("200px");
        this.grid.addColumn((Renderer)new TextRenderer((ItemLabelGenerator & Serializable)p -> p.getDataHora().format(FormatDate.DATETIME_BR.toDTF()))).setFlexGrow(0).setWidth("180px").setHeader("Data/Hora");
        this.grid.addColumn((Renderer)new ComponentRenderer((SerializableFunction & Serializable)e -> UIUtils.createBreakWrapSpan((String)e.getEstruturaUsuario().getUsuario().getNome()))).setHeader("Usu\u00e1rio").setFlexGrow(0).setWidth("160px");
        this.grid.addColumn((Renderer)new ComponentRenderer((SerializableFunction & Serializable)eg -> {
            Button b = UIUtils.createSmallButton((String)"Download");
            b.setVisible(eg.getHashArquivo() != null && !eg.getHashArquivo().isEmpty());
            b.addClickListener((ComponentEventListener & Serializable)e -> this.exportDialog.open(eg.getHashArquivo(), eg.getNomeArquivo()));
            return b;
        })).setFlexGrow(0).setWidth("120px").setHeader("Baixar");
        this.povoa();
        return new HorizontalContainer(new Component[]{this.grid});
    }
}

