/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.cobranca.service;

import br.com.system.app.features.cobranca.model.CobrancaAssinatura;
import br.com.system.app.features.cobranca.model.CobrancaAssinaturaAnexo;
import br.com.system.app.features.cobranca.repository.CobrancaAssinaturaAnexoRepository;
import br.com.system.app.features.estrutura.model.EstruturaUsuario;
import br.com.system.app.features.shared.exception.BusinessException;
import br.com.system.app.features.storage.StorageUtil;
import br.com.system.app.features.util.TempFileMultiBuffer;
import br.com.system.commons.FileUtil;
import br.com.system.commons.HashUtil;
import java.io.InputStream;
import java.time.LocalDateTime;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CobrancaAssinaturaAnexoService {
    @Autowired
    private CobrancaAssinaturaAnexoRepository repository;

    public List<CobrancaAssinaturaAnexo> getByCobrancaAssinatura(CobrancaAssinatura ca) {
        return this.repository.findByCobrancaAssinatura(ca);
    }

    public CobrancaAssinaturaAnexo save(CobrancaAssinaturaAnexo caa) {
        return (CobrancaAssinaturaAnexo)this.repository.save((Object)caa);
    }

    public void save(CobrancaAssinatura ca, EstruturaUsuario eu, InputStream file, String nomeArquivo) {
        String extensao = FileUtil.getExtension((String)nomeArquivo);
        String hash = HashUtil.getUUI() + extensao;
        try {
            StorageUtil.uploadObjectInputStream((String)hash, (InputStream)file);
        }
        catch (Exception e) {
            throw new BusinessException("Erro ao gravar arquivo: " + e.getMessage());
        }
        CobrancaAssinaturaAnexo caa = new CobrancaAssinaturaAnexo();
        caa.setHashArquivo(hash);
        caa.setEstruturaUsuario(eu);
        caa.setDataHora(LocalDateTime.now());
        caa.setNomeArquivo(nomeArquivo);
        caa.setCobrancaAssinatura(ca);
        this.save(caa);
    }

    public void save(CobrancaAssinatura ca, EstruturaUsuario euContext, TempFileMultiBuffer buffer) {
        for (String file : buffer.getFiles()) {
            this.save(ca, euContext, buffer.getInputStream(file), buffer.getFileData(file).getFileName());
        }
    }

    public void delete(CobrancaAssinaturaAnexo caa) {
        this.repository.delete((Object)caa);
    }
}

