/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.cobranca.service;

import br.com.system.app.features.cobranca.model.CobrancaAssinatura;
import br.com.system.app.features.cobranca.model.CobrancaValorDTO;
import br.com.system.app.features.cobranca.repository.CobrancaAssinaturaRepository;
import br.com.system.app.features.cobranca.service.CobrancaAssinaturaLogService;
import br.com.system.app.features.cobranca.service.EnotasService;
import br.com.system.app.features.configurations.model.ConfigurationEnum;
import br.com.system.app.features.configurations.service.ConfigurationsService;
import br.com.system.app.features.estrutura.model.EstruturaComplemento;
import br.com.system.app.features.estrutura.model.EstruturaUsuario;
import br.com.system.app.features.estrutura.service.EstruturaComplementoService;
import br.com.system.app.features.estrutura.service.EstruturaUsuarioService;
import br.com.system.app.features.shared.exception.BusinessException;
import br.com.system.commons.HashUtil;
import br.com.system.commons.StringUtil;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.List;
import java.util.Optional;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class CobrancaAssinaturaService
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Autowired
    private CobrancaAssinaturaRepository assinaturaRepository;
    @Autowired
    private EnotasService enotasService;
    @Autowired
    private ConfigurationsService configurationsService;
    @Autowired
    private EstruturaUsuarioService eus;
    @Autowired
    private EstruturaComplementoService estruturaComplementoService;
    @Autowired
    private CobrancaAssinaturaLogService logService;

    public boolean temPermissao(String login) {
        String[] split;
        for (String string : split = this.configurationsService.get(ConfigurationEnum.LOGINS_ACESSO_ASSINATURAS).getValor().split(",")) {
            if (!string.equals(login)) continue;
            return true;
        }
        return false;
    }

    public CobrancaAssinatura getById(Long id) {
        Optional opt = this.assinaturaRepository.findById((Object)id);
        if (opt.isPresent()) {
            return (CobrancaAssinatura)opt.get();
        }
        throw new BusinessException("Id n\u00e3o encontrado");
    }

    public CobrancaValorDTO getMensalAvencer() {
        return this.assinaturaRepository.findMensalAvencer();
    }

    public CobrancaValorDTO getMensalPago() {
        return this.assinaturaRepository.findMensalPago();
    }

    public CobrancaValorDTO getFaturasVencidas() {
        return this.assinaturaRepository.findFaturasVencidos();
    }

    public CobrancaValorDTO getAssinaturasWithOutNeo(Boolean ativo) {
        List assinaturas = this.assinaturaRepository.findAssinaturasAtivas();
        CobrancaValorDTO retorno = new CobrancaValorDTO();
        retorno.setId(HashUtil.getUUI());
        retorno.setQuantidade(Integer.valueOf(assinaturas.size()));
        Double vl = 0.0;
        for (CobrancaValorDTO av : assinaturas) {
            vl = vl + av.getValor();
        }
        retorno.setValor(vl);
        return retorno;
    }

    public CobrancaValorDTO getAssinaturasVencidas() {
        List assinaturasVencidas = this.assinaturaRepository.findAssinaturasVencidas();
        CobrancaValorDTO retorno = new CobrancaValorDTO();
        retorno.setId(HashUtil.getUUI());
        retorno.setQuantidade(Integer.valueOf(assinaturasVencidas.size()));
        Double vl = 0.0;
        for (CobrancaValorDTO av : assinaturasVencidas) {
            vl = vl + av.getValor();
        }
        retorno.setValor(vl);
        return retorno;
    }

    public CobrancaValorDTO getAGerar() {
        return this.assinaturaRepository.findAGerar();
    }

    public List<CobrancaAssinatura> getAssinaturas() {
        return this.assinaturaRepository.findAll();
    }

    public List<CobrancaAssinatura> getAssinaturasInadimplentes() {
        return this.assinaturaRepository.findByInadimplenteAndAtivo(Boolean.TRUE, Boolean.TRUE);
    }

    public List<CobrancaAssinatura> getAssinaturas(Boolean ativo) {
        return this.assinaturaRepository.findByAtivo(ativo);
    }

    public List<CobrancaAssinatura> getByCpfCnpj(String cpfCnpj) {
        return this.assinaturaRepository.findByCpfCnpj(cpfCnpj);
    }

    public void refreshAllOnEnotas() {
        List lista = this.getAssinaturas(Boolean.TRUE);
        for (CobrancaAssinatura ass : lista) {
            String numero = StringUtil.removeNonNumber((String)ass.getNumero());
            if (numero == null || numero.isEmpty()) {
                numero = "00";
            }
            this.enotasService.cadatrarCliente(ass.getCpfCnpj(), ass.getNome(), ass.getListaEmail(), StringUtil.numbersOnly((String)ass.getCelular()), ass.getLogradouro(), numero, ass.getCompl(), ass.getBairro(), ass.getCidade(), ass.getEstado(), ass.getCep());
        }
    }

    public List<CobrancaAssinatura> getAssinaturas(Boolean ativo, String nome, String cpfCnpj, boolean inadimplentes, boolean divergentes, LocalDate pagamentoIni, LocalDate pagamentoFim, Pageable pageable) {
        return this.assinaturaRepository.filter(ativo, nome, cpfCnpj, inadimplentes, divergentes, pagamentoIni, pagamentoFim, pageable);
    }

    public long countAssinaturas(Boolean ativo, String nome, String cpfCnpj, boolean inadimplentes, boolean divergentes, LocalDate pagamentoIni, LocalDate pagamentoFim) {
        return this.assinaturaRepository.count(ativo, nome, cpfCnpj, inadimplentes, divergentes, pagamentoIni, pagamentoFim);
    }

    public List<CobrancaAssinatura> getByProximoVencimento(LocalDate proximoVencimento) {
        return this.assinaturaRepository.findByAtivoAndProximoVencimentoLessThan(Boolean.TRUE, proximoVencimento);
    }

    public void changeStatus(EstruturaUsuario eu, CobrancaAssinatura assinatura) {
        assinatura.setAtivo(Boolean.valueOf(assinatura.getAtivo() == false));
        if (assinatura.getAtivo().booleanValue()) {
            this.logService.create(eu, assinatura, "Ativado com sucesso");
        } else {
            this.logService.create(eu, assinatura, "Desativado com sucesso");
        }
        this.save(assinatura);
    }

    public void changeBloqueio(EstruturaUsuario eu, CobrancaAssinatura assinatura) {
        assinatura.setBloqueado(!assinatura.isBloqueado());
        if (assinatura.isBloqueado()) {
            this.logService.create(eu, assinatura, "Bloqueio efetuado");
        } else {
            this.logService.create(eu, assinatura, "Desbloqueio efetuado");
        }
        this.save(assinatura);
    }

    public CobrancaAssinatura save(CobrancaAssinatura ass) {
        try {
            String eNotasId = this.enotasService.cadatrarCliente(ass.getCpfCnpj(), ass.getNome(), ass.getListaEmail(), ass.getCelular(), ass.getLogradouro(), ass.getNumero(), ass.getCompl(), ass.getBairro(), ass.getCidade(), ass.getEstado(), ass.getCep());
            ass.setEnotasClienteId(eNotasId);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return (CobrancaAssinatura)this.assinaturaRepository.save((Object)ass);
    }

    public void delete(CobrancaAssinatura assinatura) {
        this.assinaturaRepository.delete((Object)assinatura);
    }

    public void checarInadimplencia(String cpfCnpj) {
        this.assinaturaRepository.checarInadimplencia(cpfCnpj);
    }

    @Async(value="asyncDefault")
    public void checarDivergencia(String cpfCnpj) {
        List lista = cpfCnpj != null && !cpfCnpj.isEmpty() ? this.getByCpfCnpj(cpfCnpj) : this.getAssinaturas(Boolean.valueOf(true));
        for (CobrancaAssinatura ca : lista) {
            try {
                int nroUsuarios = 0;
                for (EstruturaComplemento ec : this.estruturaComplementoService.getByCobrancaAssinatura(ca)) {
                    nroUsuarios += this.eus.getAtivosByEstrutura(ec.getEstrutura()).size();
                }
                if (nroUsuarios > ca.getNroUsuarios() && ca.getNroUsuarios() > 0) {
                    ca.setDivergente(true);
                } else {
                    ca.setDivergente(false);
                }
                this.save(ca);
            }
            catch (Exception e) {
                LoggerFactory.getLogger(CobrancaAssinaturaService.class).error(e.getMessage());
            }
        }
    }
}

