/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.dashboard;

import br.com.system.app.MainLayout;
import br.com.system.app.components.ProgressBar;
import br.com.system.app.components.containers.HorizontalContainer;
import br.com.system.app.components.containers.VerticalContainer;
import br.com.system.app.features.dashboard.DashBoardBoxForm;
import br.com.system.app.features.dashboard.DashBoardBoxTipoEnum;
import br.com.system.app.features.dashboard.DashBoardBoxView;
import br.com.system.app.features.dashboard.dto.DashBoardDTO;
import br.com.system.app.features.dashboard.service.DashBoardExportacaoService;
import br.com.system.app.features.equipe.model.Equipe;
import br.com.system.app.features.estrutura.service.EstruturaComplementoService;
import br.com.system.app.features.layout.UIUtils;
import br.com.system.app.features.layout.ViewFrame;
import br.com.system.app.features.producaopainel.model.ProducaoPainelBox;
import br.com.system.app.features.producaopainel.service.ProducaoPainelBoxService;
import br.com.system.app.features.producaopainel.service.ProducaoPainelResumoService;
import br.com.system.app.security.SecurityContext;
import br.com.system.commons.datetime.DateTimeUtil;
import br.com.system.commons.datetime.FormatDate;
import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.DetachEvent;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.combobox.ComboBox;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.router.PageTitle;
import com.vaadin.flow.router.Route;
import com.vaadin.flow.server.Command;
import jakarta.annotation.security.RolesAllowed;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

@Route(value="dashboard", layout=MainLayout.class)
@PageTitle(value="Dashboard")
@RolesAllowed(value={"DASHBOARD_VIEW"})
public class DashBoardView
extends ViewFrame
implements SecurityContext {
    private static final long serialVersionUID = 1L;
    private final ProducaoPainelResumoService pprs;
    private final ProducaoPainelBoxService ppbs;
    private final EstruturaComplementoService estruturaComplementoService;
    private final DashBoardExportacaoService dashBoardExportacaoService;
    private final DashBoardBoxForm form;
    private final HorizontalContainer board = new HorizontalContainer(new Component[0]);
    private final ProgressBar progressBar = new ProgressBar(Boolean.TRUE);
    private final Map<Integer, DashBoardDTO> mapBox = new ConcurrentHashMap();
    private UI ui;
    private ComboBox<Equipe> cbEquipe;
    private ComboBox<String> cbMesAno;
    private int calls;
    private int returns;

    public DashBoardView(ProducaoPainelResumoService pprs, ProducaoPainelBoxService ppbs, DashBoardExportacaoService dashBoardExportacaoService, DashBoardBoxForm form, EstruturaComplementoService estruturaComplementoService) {
        this.pprs = pprs;
        this.estruturaComplementoService = estruturaComplementoService;
        this.ppbs = ppbs;
        this.dashBoardExportacaoService = dashBoardExportacaoService;
        this.form = form;
    }

    protected void onAttach(AttachEvent attachEvent) {
        if (this.autenticado()) {
            this.ui = attachEvent.getUI();
            this.setViewContent((Component)new VerticalContainer(new Component[]{this.filter(), this.board()}));
        }
    }

    protected void onDetach(DetachEvent detachEvent) {
        super.onDetach(detachEvent);
        this.ui = null;
        this.mapBox.clear();
        this.board.removeAll();
    }

    private Component board() {
        this.calls = 0;
        this.returns = 0;
        this.mapBox.clear();
        this.setSizeFull();
        this.board.removeAll();
        this.board.setSizeFull();
        this.board.addClassNames(new String[]{"gap-m", "m-m"});
        List boxes = this.ppbs.getByEstrutura(this.getEstrutura());
        this.progressBar.setText("Carregando Dashboard, aguarde...").open();
        for (ProducaoPainelBox box : boxes) {
            ++this.calls;
            DashBoardBoxView boxView = new DashBoardBoxView();
            if (box.getTipo().equals((Object)DashBoardBoxTipoEnum.DETALHAMENTO)) {
                this.pprs.getDetalhamento(this.getEu(), box, boxView, (String)this.cbMesAno.getValue(), arg_0 -> this.listener(arg_0));
                continue;
            }
            this.pprs.getResumo(this.getEu(), box, boxView, (String)this.cbMesAno.getValue(), arg_0 -> this.listener(arg_0));
        }
        return this.board;
    }

    public void listener(DashBoardDTO dto) {
        UI currentUi = this.ui;
        if (currentUi == null || currentUi.getSession() == null) {
            return;
        }
        Runnable uiWork = () -> {
            ++this.returns;
            if ((dto.getResumo() == null || dto.getResumo().isEmpty()) && !DashBoardBoxTipoEnum.CABECALHO.equals((Object)dto.getBox().getTipo())) {
                if (this.returns >= this.calls) {
                    this.progressBar.close();
                }
                return;
            }
            this.mapBox.put(dto.getBox().getPosicao(), dto);
            this.addBox();
            if (this.returns >= this.calls) {
                this.progressBar.close();
            }
        };
        if (currentUi.getSession().hasLock()) {
            uiWork.run();
        } else {
            currentUi.access((Command & Serializable)() -> uiWork.run());
        }
    }

    private HorizontalContainer filter() {
        this.cbEquipe = new ComboBox("Equipe");
        this.cbEquipe.setVisible(false);
        this.cbMesAno = new ComboBox("M\u00eas Ano");
        this.cbMesAno.setItems((Collection)this.getMeses());
        this.cbMesAno.setValue((Object)DateTimeUtil.getMesAno((LocalDate)LocalDate.now()));
        Button btnPesquisar = UIUtils.createSmallButton((VaadinIcon)VaadinIcon.SEARCH, (String)"Pesquisar");
        btnPesquisar.addClickListener((ComponentEventListener & Serializable)e -> this.board());
        Button btnAdd = UIUtils.createSmallButton((VaadinIcon)VaadinIcon.PLUS, (String)"Adicionar Novo Card");
        btnAdd.setVisible(this.hasPermission("PAINEL_PRODUCAO_BOX_SAVE"));
        btnAdd.addClickListener((ComponentEventListener & Serializable)e -> this.form.create(this.getEstrutura(), null));
        Span spanDataHora = new Span();
        LocalDateTime dataAtualizacao = this.estruturaComplementoService.getComplementos(this.getEstrutura()).getDataHoraAtualizacaoDashboard();
        if (dataAtualizacao != null) {
            spanDataHora.setText("Ultima atualizacao " + dataAtualizacao.format(FormatDate.DATETIME_BR.toDTF()));
        }
        HorizontalContainer hc = new HorizontalContainer(new Component[0]);
        hc.add(new Component[]{this.cbEquipe, this.cbMesAno, btnPesquisar, btnAdd, spanDataHora});
        return hc;
    }

    private List<String> getMeses() {
        ArrayList<String> meses = new ArrayList<String>();
        for (int i = 0; i < 12; ++i) {
            LocalDate m = LocalDate.now().minusMonths(i);
            meses.add(DateTimeUtil.getMesAno((LocalDate)m));
        }
        return meses;
    }

    private void addBox() {
        this.board.removeAll();
        this.mapBox.entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(entry -> {
            DashBoardDTO dto = (DashBoardDTO)entry.getValue();
            DashBoardBoxView boxView = dto.getBoxView();
            if (boxView == null) {
                return;
            }
            if (dto.getBox().getTipo().equals((Object)DashBoardBoxTipoEnum.DETALHAMENTO)) {
                this.board.add(new Component[]{boxView.createGrid(this.getEu(), this.form, this.dashBoardExportacaoService, dto.getBox(), dto.getDetalhamento(), ((String)this.cbMesAno.getValue()).replace("-", ""))});
            } else {
                this.board.add(new Component[]{boxView.createBox(this.getEu(), this.form, this.dashBoardExportacaoService, dto.getBox(), dto.getResumo(), ((String)this.cbMesAno.getValue()).replace("-", ""))});
            }
        });
    }
}

