/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.dashboard.service;

import br.com.system.app.features.estrutura.model.EstruturaUsuario;
import br.com.system.app.features.producaopainel.model.ProducaoPainelBox;
import br.com.system.app.features.producaopainel.model.ProducaoPainelResumo;
import br.com.system.app.features.producaopainel.repository.ProducaoPainelResumoRepository;
import br.com.system.app.features.shared.exception.BusinessException;
import br.com.system.app.features.storage.StorageUtil;
import br.com.system.app.features.usuario.service.UsuarioHierarquiaService;
import br.com.system.commons.HashUtil;
import br.com.system.commons.InputStreamUtil;
import br.com.system.commons.datetime.FormatDate;
import java.io.InputStream;
import java.util.List;
import java.util.Set;
import org.apache.http.entity.ContentType;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DashBoardExportacaoService {
    @Autowired
    private ProducaoPainelResumoRepository producaoPainelResumoRepository;
    @Autowired
    private UsuarioHierarquiaService hierarquiaService;

    public String exportar(EstruturaUsuario eu, ProducaoPainelBox box, String mesAno) {
        Set hierarquia = this.hierarquiaService.getHierarquia(eu);
        InputStream is = null;
        XSSFWorkbook xls = null;
        try {
            List lista = this.producaoPainelResumoRepository.getExportacao(eu, box, hierarquia, mesAno);
            String nomeArquivo = "Exportacao-resumo-v1.xlsx";
            is = StorageUtil.getObjectModelo((String)nomeArquivo);
            xls = new XSSFWorkbook(is);
            Sheet aba = xls.getSheet("Exportacao");
            CellStyle styleCellDouble = xls.createCellStyle();
            styleCellDouble.setDataFormat((short)2);
            int i = 1;
            for (ProducaoPainelResumo ppr : lista) {
                aba.createRow(i);
                int col = 0;
                aba.getRow(i).createCell(col).setCellValue(this.getField(ppr.getNumero()));
                aba.getRow(i).createCell(++col).setCellValue(this.getField(ppr.getCpfCnpj()));
                aba.getRow(i).createCell(++col).setCellValue(this.getField(ppr.getNomeCliente()));
                aba.getRow(i).createCell(++col).setCellValue(this.getField(ppr.getLoginUsuario()));
                aba.getRow(i).createCell(++col).setCellValue(this.getField(ppr.getMesAno()));
                aba.getRow(i).createCell(++col).setCellValue(this.getField(ppr.getGrupo()));
                aba.getRow(i).createCell(++col).setCellValue(this.getField(ppr.getFila()));
                aba.getRow(i).createCell(++col).setCellValue((double)ppr.getQuantidade().intValue());
                aba.getRow(i).createCell(++col).setCellValue(ppr.getValor().doubleValue());
                aba.getRow(i).getCell(col).setCellStyle(styleCellDouble);
                aba.getRow(i).createCell(++col).setCellValue(this.getField(ppr.getEquipe()));
                aba.getRow(i).createCell(++col).setCellValue(this.getField(ppr.getCidade()));
                aba.getRow(i).createCell(++col).setCellValue(this.getField(ppr.getEstado()));
                aba.getRow(i).createCell(++col).setCellValue(this.getField(ppr.getDataAtualizacao().format(FormatDate.DATETIME_BR.toDTF())));
                ++i;
            }
            String hash = HashUtil.getUUI() + ".xlsx";
            InputStream isOutput = InputStreamUtil.workbookToInputStream((Workbook)xls);
            String string = StorageUtil.uploadObjectInputStream((String)hash, (String)ContentType.MULTIPART_FORM_DATA.toString(), (InputStream)isOutput);
            return string;
        }
        catch (Exception e) {
            throw new BusinessException("Erro ao buscar dados de producao: " + e.getMessage());
        }
        finally {
            try {
                xls.close();
                is.close();
                xls = null;
                is.close();
            }
            catch (Exception exception) {}
        }
    }

    private String getField(String field) {
        if (field == null) {
            return "";
        }
        return field.trim();
    }
}

