/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.dicasistema;

import br.com.system.app.MainLayout;
import br.com.system.app.components.ConfirmationDialog;
import br.com.system.app.components.containers.HorizontalContainer;
import br.com.system.app.features.dicasistema.DicaSistemaForm;
import br.com.system.app.features.dicasistema.model.DicaSistema;
import br.com.system.app.features.dicasistema.service.DicaSistemaService;
import br.com.system.app.features.layout.UIUtils;
import br.com.system.app.features.layout.ViewFrame;
import br.com.system.app.security.SecurityContext;
import br.com.system.commons.datetime.FormatDate;
import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.ItemLabelGenerator;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.textfield.TextField;
import com.vaadin.flow.data.renderer.Renderer;
import com.vaadin.flow.data.renderer.TextRenderer;
import com.vaadin.flow.router.PageTitle;
import com.vaadin.flow.router.Route;
import jakarta.annotation.security.RolesAllowed;
import java.io.Serializable;
import org.springframework.beans.factory.annotation.Autowired;
import org.vaadin.crudui.crud.CrudListener;
import org.vaadin.crudui.crud.impl.GridCrud;

@Route(value="dica-sistema", layout=MainLayout.class)
@PageTitle(value="Cadastro Dica Sistema")
@RolesAllowed(value={"MASTER"})
public class DicaSistemaView
extends ViewFrame
implements SecurityContext {
    private static final long serialVersionUID = 1L;
    private final DicaSistemaService dicaSistemaService;
    private final DicaSistemaForm dicaSistemaForm;
    private GridCrud<DicaSistema> crud;

    @Autowired
    public DicaSistemaView(DicaSistemaService dicaSistemaService, DicaSistemaForm dicaSistemaForm) {
        this.dicaSistemaService = dicaSistemaService;
        this.dicaSistemaForm = dicaSistemaForm;
    }

    protected void onAttach(AttachEvent attachEvent) {
        super.onAttach(attachEvent);
        if (this.autenticado() && this.isMaster()) {
            this.setViewContent(this.createContent());
        } else {
            this.showNotification("Sem permiss\u00e3o");
        }
    }

    private Component createContent() {
        this.dicaSistemaForm.addOpenedChangeListener((ComponentEventListener & Serializable)e -> {
            if (!e.isOpened()) {
                this.crud.refreshGrid();
            }
        });
        this.crud = new GridCrud(DicaSistema.class);
        TextField filter = new TextField();
        filter.setPlaceholder("Filtrar por titulo");
        filter.setClearButtonVisible(true);
        this.crud.getCrudLayout().addFilterComponent((Component)filter);
        this.crud.getAddButton().setText("Adicionar");
        this.crud.getGrid().setColumns(new String[]{"titulo", "urlYoutube", "nomeImagem"});
        this.crud.getGrid().addColumn((Renderer)new TextRenderer((ItemLabelGenerator & Serializable)p -> p.getDataPostagem().format(FormatDate.DATE_BR.toDTF()))).setHeader("Padrao");
        this.crud.getGrid().addColumn((Renderer)new TextRenderer((ItemLabelGenerator & Serializable)p -> p.getPadrao() != false ? "SIM" : "N\u00c3O")).setHeader("Padrao");
        this.crud.getAddButton().setVisible(false);
        this.crud.getUpdateButton().setVisible(false);
        this.crud.getDeleteButton().setVisible(false);
        this.crud.getCrudFormFactory().setVisibleProperties(new String[]{""});
        this.crud.getCrudLayout().addToolbarComponent((Component)this.getOptions());
        this.crud.setCrudListener((CrudListener)new /* Unavailable Anonymous Inner Class!! */);
        filter.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> this.crud.refreshGrid());
        return this.crud;
    }

    private HorizontalContainer getOptions() {
        Button btnAdd = UIUtils.createSmallButton((String)"Adicionar", (VaadinIcon)VaadinIcon.PLUS, (String)"Adicionar Nova Dica");
        btnAdd.setEnabled(this.isMaster());
        btnAdd.addClickListener((ComponentEventListener & Serializable)e -> this.dicaSistemaForm.create(new DicaSistema()));
        Button btnEdit = UIUtils.createSmallButton((String)"Editar", (VaadinIcon)VaadinIcon.PENCIL, (String)"Editar Dica");
        btnEdit.setEnabled(this.isMaster());
        btnEdit.addClickListener((ComponentEventListener & Serializable)e -> {
            if (this.crud.getGrid().getSelectedItems().size() != 1) {
                this.showNotification("Selecione uma dica para editar.");
                return;
            }
            this.dicaSistemaForm.create((DicaSistema)this.crud.getGrid().getSelectedItems().iterator().next());
        });
        Button btnTrash = UIUtils.createSmallButton((String)"Excluir", (VaadinIcon)VaadinIcon.TRASH, (String)"Excluir");
        btnTrash.setEnabled(this.isMaster());
        btnTrash.addClickListener((ComponentEventListener & Serializable)e -> {
            ConfirmationDialog cd = new ConfirmationDialog("Excluir dica", "Confirma exclus\u00e3o da DICA?");
            cd.getCancel().addClickListener((ComponentEventListener & Serializable)cancel -> cd.close());
            cd.getConfirm().addClickListener((ComponentEventListener & Serializable)conf -> {
                if (this.crud.getGrid().getSelectedItems().size() != 1) {
                    this.showNotification("Selecione uma dica para excluir");
                    return;
                }
                this.dicaSistemaService.delete((DicaSistema)this.crud.getGrid().getSelectedItems().iterator().next());
                cd.close();
            });
        });
        HorizontalContainer container = new HorizontalContainer(new Component[]{btnAdd, btnEdit, btnTrash});
        return container;
    }
}

