/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.importacoes.service;

import br.com.system.app.features.estrutura.model.EstruturaUsuario;
import br.com.system.app.features.importacoes.model.Importacoes;
import br.com.system.app.features.importacoes.model.ImportacoesTipoEnum;
import br.com.system.app.features.importacoes.repository.ImportacoesRepository;
import br.com.system.app.features.importacoes.service.VivoPedidoImportacao;
import br.com.system.app.features.importacoes.service.VivoPedidoImportacaoStatus;
import br.com.system.app.features.notificacoes.service.NotificacoesService;
import br.com.system.app.features.shared.exception.BusinessException;
import br.com.system.commons.InputStreamUtil;
import br.com.system.commons.ZipFile;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class ImportacoesService
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Autowired
    private VivoPedidoImportacao movel;
    @Autowired
    private VivoPedidoImportacaoStatus importacaoStatus;
    @Autowired
    private ImportacoesRepository importacoesRepository;
    @Autowired
    private NotificacoesService notificacoesService;

    @Async(value="asyncDefault")
    public void importarArquivos(EstruturaUsuario eu, InputStream isFile, String mimeType, ImportacoesTipoEnum tipo, boolean forcar) {
        try {
            InputStream is = mimeType.contains("zip") ? ZipFile.unzip((InputStream)isFile) : isFile;
            String charset = tipo.equals((Object)ImportacoesTipoEnum.VIVO_MOVEL_STATUS) || tipo.equals((Object)ImportacoesTipoEnum.VIVO_COTACAO_STATUS) ? "UTF-16" : "iso-8859-1";
            String log = "";
            String conteudo = InputStreamUtil.toString((InputStream)is, (Charset)Charset.forName(charset));
            String[] linhas = conteudo.split("\n");
            List colunas = this.getByTipo(tipo);
            if (tipo.equals((Object)ImportacoesTipoEnum.VIVO_MOVEL) || tipo.equals((Object)ImportacoesTipoEnum.VIVO_FIXA) || tipo.equals((Object)ImportacoesTipoEnum.VIVO_MVP)) {
                log = this.movel.importarPedidos(eu, linhas, colunas, forcar, tipo);
            } else if (tipo.equals((Object)ImportacoesTipoEnum.VIVO_MOVEL_STATUS) || tipo.equals((Object)ImportacoesTipoEnum.VIVO_COTACAO_STATUS)) {
                log = this.importacaoStatus.atualizarStatus(eu, linhas, colunas);
            } else if (tipo.equals((Object)ImportacoesTipoEnum.VIVO_AVANCADA)) {
                throw new BusinessException("N\u00e3o implementado");
            }
            is.close();
            isFile.close();
            this.notificacoesService.notify(eu, "Atualiza\u00e7\u00e3o Pedidos Vivo", "Atualizacao " + tipo.name() + " finalizada:\n" + log);
        }
        catch (Exception e) {
            throw new BusinessException(e.getMessage());
        }
    }

    public List<Importacoes> getByTipo(ImportacoesTipoEnum tipo) {
        return this.importacoesRepository.findByTipo(tipo);
    }

    public List<Importacoes> getByTipo(ImportacoesTipoEnum tipo, Pageable pageable) {
        return this.importacoesRepository.findByTipo(tipo, pageable);
    }

    public long countByTipo(ImportacoesTipoEnum tipo) {
        return this.importacoesRepository.countByTipo(tipo);
    }

    public Importacoes save(Importacoes importacoes) {
        return (Importacoes)this.importacoesRepository.save((Object)importacoes);
    }
}

