/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.importacoes.service;

import br.com.system.app.features.estrutura.model.EstruturaUsuario;
import br.com.system.app.features.estrutura.service.EstruturaUsuarioService;
import br.com.system.app.features.importacoes.dto.VivoPedidoDTO;
import br.com.system.app.features.importacoes.dto.VivoPedidoItemDTO;
import br.com.system.app.features.importacoes.model.Importacoes;
import br.com.system.app.features.importacoes.model.ImportacoesCampoEnum;
import br.com.system.app.features.importacoes.model.ImportacoesTipoEnum;
import br.com.system.app.features.importacoes.service.ImportacaoPersistService;
import br.com.system.app.features.importacoes.service.ImportacaoUtil;
import br.com.system.app.features.shared.exception.BusinessException;
import br.com.system.commons.StringUtil;
import br.com.system.commons.datetime.DateTimeUtil;
import br.com.system.commons.datetime.FormatDate;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class VivoPedidoImportacao
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Autowired
    private ImportacaoPersistService importacaoPersistService;
    @Autowired
    private EstruturaUsuarioService eus;
    private final ImportacaoUtil util = new ImportacaoUtil();

    private boolean validar(String[] linhas, List<Importacoes> colunas) {
        try {
            String[] cols = linhas[0].split(";");
            for (Importacoes col : colunas) {
                if (cols[col.getPosicao()].equals(col.getNome())) continue;
                return false;
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public String importarPedidos(EstruturaUsuario eu, String[] linhas, List<Importacoes> colunas, boolean forcar, ImportacoesTipoEnum tipo) {
        if (!this.validar(linhas, colunas)) {
            return "Arquivo inv\u00e1lido";
        }
        EstruturaUsuario master = this.eus.getMasterEstrutura(eu.getEstrutura());
        try {
            HashSet lista = new HashSet();
            for (String linha : linhas) {
                try {
                    String[] cols = StringUtil.getCols((String)linha, (String)";");
                    String numero = this.getValue(cols, ImportacoesCampoEnum.NRO_PEDIDO, colunas);
                    if (numero.equals(this.util.get(ImportacoesCampoEnum.NRO_PEDIDO, colunas).getNome())) continue;
                    VivoPedidoDTO dto = this.getPedido(cols, numero, lista, colunas, tipo);
                    if (tipo.equals((Object)ImportacoesTipoEnum.VIVO_MVP)) continue;
                    dto.getItens().add(this.getItem(dto, cols, colunas, tipo));
                }
                catch (Exception ex) {
                    if (ex.getMessage().equals("Ignorar")) continue;
                    LoggerFactory.getLogger(VivoPedidoImportacao.class).error(ex.getMessage());
                }
            }
            return this.importacaoPersistService.gravar(lista, eu, master, forcar, tipo);
        }
        catch (Exception e) {
            throw new BusinessException(e.getMessage());
        }
    }

    private VivoPedidoDTO getPedido(String[] cols, String numero, Set<VivoPedidoDTO> lista, List<Importacoes> colunas, ImportacoesTipoEnum tipo) throws Exception {
        for (VivoPedidoDTO d : lista) {
            if (d.getNumero() == null || !d.getNumero().equals(numero) || numero.isEmpty()) continue;
            return d;
        }
        VivoPedidoDTO dto = new VivoPedidoDTO();
        try {
            dto.setOrigem(this.getValue(cols, ImportacoesCampoEnum.ORIGEM, colunas));
            dto.setAdabas(this.getValue(cols, ImportacoesCampoEnum.ADABAS, colunas));
            dto.setCotacao(this.getValue(cols, ImportacoesCampoEnum.NRO_COTACAO, colunas));
            dto.setNumeroPedidoVivocorp(this.getValue(cols, ImportacoesCampoEnum.NRO_PEDIDO, colunas));
            dto.setNumeroSimulacao(this.getValue(cols, ImportacoesCampoEnum.NUMERO_SIMULACAO, colunas));
            dto.setCpfCnpj(this.getValue(cols, ImportacoesCampoEnum.CPF_CNPJ, colunas));
            if (tipo.equals((Object)ImportacoesTipoEnum.VIVO_MVP)) {
                dto.setDataInput(DateTimeUtil.toDate((String)this.getValue(cols, ImportacoesCampoEnum.DATA_INPUT, colunas), (FormatDate)FormatDate.DATE_BR));
                dto.setDataAtualizacao(DateTimeUtil.toDate((String)this.getValue(cols, ImportacoesCampoEnum.DATA_ATUALIZACAO, colunas), (FormatDate)FormatDate.DATE_BR));
            } else {
                dto.setDataInput(DateTimeUtil.toDate((String)this.getValue(cols, ImportacoesCampoEnum.DATA_INPUT, colunas), (FormatDate)FormatDate.US_DATE));
                dto.setDataAtualizacao(DateTimeUtil.toDate((String)this.getValue(cols, ImportacoesCampoEnum.DATA_ATUALIZACAO, colunas), (FormatDate)FormatDate.US_DATE));
            }
            if (dto.getDataAtualizacao() == null) {
                dto.setDataAtualizacao(dto.getDataInput());
            }
            if (dto.getDataAtualizacao() == null && !tipo.equals((Object)ImportacoesTipoEnum.VIVO_MVP)) {
                dto.setDataAtualizacao(DateTimeUtil.toDate((String)this.getValue(cols, ImportacoesCampoEnum.DATA_DESCONEXAO, colunas), (FormatDate)FormatDate.US_DATE));
            }
            dto.setNomeCliente(this.getValue(cols, ImportacoesCampoEnum.NOME_CLIENTE, colunas));
            dto.setNumero(numero);
            dto.setNotaFiscal("OV: " + this.getValue(cols, ImportacoesCampoEnum.NRO_ORDEM, colunas) + "/NF:" + this.getValue(cols, ImportacoesCampoEnum.NOTA_FISCAL, colunas));
            dto.setStatus(this.getStatus(cols, colunas, tipo, dto.getOrigem()));
            dto.setVendedor(this.getValue(cols, ImportacoesCampoEnum.NOME_CONSULTOR, colunas));
            dto.setCnpjFresh(this.getValue(cols, ImportacoesCampoEnum.CNPJ_FRESH, colunas).equals("S"));
            dto.setItens(new HashSet());
            lista.add(dto);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return dto;
    }

    private VivoPedidoItemDTO getItem(VivoPedidoDTO dto, String[] cols, List<Importacoes> colunas, ImportacoesTipoEnum tipo) {
        VivoPedidoItemDTO item = new VivoPedidoItemDTO();
        item.setNumeroLinha(this.getValue(cols, ImportacoesCampoEnum.NUMERO_LINHA, colunas));
        item.setPlano(this.getValue(cols, ImportacoesCampoEnum.PLANO, colunas));
        item.setDataAtualizacao(dto.getDataAtualizacao());
        String d = this.getValue(cols, ImportacoesCampoEnum.VALOR_NEGOCIADO, colunas).replace(",", ".");
        item.setValor(d.isEmpty() ? Double.valueOf("0") : Double.valueOf(d));
        if (tipo.equals((Object)ImportacoesTipoEnum.VIVO_FIXA)) {
            item.setQuantidade("1");
            item.setStatusLinha("CONCLUIDO");
            if (this.getValue(cols, ImportacoesCampoEnum.TIPO_SOLICITACAO, colunas).equals("RENOVACAO")) {
                item.setTipo("RENOVACAO");
            } else {
                item.setTipo("Alta");
            }
            if (this.getValue(cols, ImportacoesCampoEnum.TIPO_SOLICITACAO, colunas).equals("MIGRA\u00c7\u00c3O")) {
                item.setMigracao(true);
            }
            LocalDate dp = DateTimeUtil.toDate((String)this.getValue(cols, ImportacoesCampoEnum.PORTABILIDADE, colunas), (FormatDate)FormatDate.US_DATE);
            item.setDataPortabilidade(dp);
        } else {
            item.setDataPortabilidade(DateTimeUtil.toDate((String)this.getValue(cols, ImportacoesCampoEnum.PORTABILIDADE, colunas), (FormatDate)FormatDate.US_DATETIME));
            item.setDdd(this.getValue(cols, ImportacoesCampoEnum.DDD, colunas));
            item.setMigracao(this.getValue(cols, ImportacoesCampoEnum.MIGRACAO, colunas).equals("S"));
            item.setAparelho(this.getValue(cols, ImportacoesCampoEnum.APARELHO, colunas));
            item.setQuantidade(this.getValue(cols, ImportacoesCampoEnum.QUANTIDADE, colunas));
            item.setStatusLinha(this.getValue(cols, ImportacoesCampoEnum.STATUS_LINHA, colunas));
            item.setTipo(this.getValue(cols, ImportacoesCampoEnum.TIPO_SOLICITACAO, colunas));
            String vl = this.getValue(cols, ImportacoesCampoEnum.VALOR_APARELHO, colunas).replace(",", ".");
            if (vl != null && !vl.isEmpty()) {
                item.setValorAparelho(Double.valueOf(vl));
            } else {
                item.setValorAparelho(Double.valueOf("0"));
            }
            item.setGestaoEquipe(this.getValue(cols, ImportacoesCampoEnum.DS_GESTAO_EQUIPE, colunas));
            item.setPresencaDigital(this.getValue(cols, ImportacoesCampoEnum.DS_PRES_DIGITAL, colunas));
            item.setOffice365(this.getValue(cols, ImportacoesCampoEnum.DS_OFFICE365, colunas));
            item.setVpol(this.getValue(cols, ImportacoesCampoEnum.DS_VPOL, colunas));
            item.setVgi(this.getValue(cols, ImportacoesCampoEnum.DS_VGI, colunas));
            item.setApontador(this.getValue(cols, ImportacoesCampoEnum.DS_APONTADOR, colunas));
            item.setOneDrive(this.getValue(cols, ImportacoesCampoEnum.DS_ONEDRIVE, colunas));
            item.setSegProtecao(this.getValue(cols, ImportacoesCampoEnum.DS_SEG_PROT, colunas));
            item.setSegMult(this.getValue(cols, ImportacoesCampoEnum.DS_SEG_MULT, colunas));
            item.setOperadoraDoadora(this.getValue(cols, ImportacoesCampoEnum.OPERADORA_DOADORA, colunas));
            item.setPacote(this.getValue(cols, ImportacoesCampoEnum.SERVICO_INTERNET, colunas));
        }
        return item;
    }

    private String getValue(String[] cols, ImportacoesCampoEnum campo, List<Importacoes> colunas) {
        try {
            Importacoes importacoes = this.util.get(campo, colunas);
            if (importacoes == null) {
                return "";
            }
            return cols[importacoes.getPosicao()].trim();
        }
        catch (Exception e) {
            return "";
        }
    }

    private String getStatus(String[] cols, List<Importacoes> colunas, ImportacoesTipoEnum tipo, String origem) throws Exception {
        if (tipo.equals((Object)ImportacoesTipoEnum.VIVO_MOVEL)) {
            return this.getValue(cols, ImportacoesCampoEnum.STATUS_PEDIDO, colunas);
        }
        if (tipo.equals((Object)ImportacoesTipoEnum.VIVO_MVP)) {
            if (origem.equals("VIVO CORP")) {
                return this.getValue(cols, ImportacoesCampoEnum.STATUS_PEDIDO, colunas);
            }
            return this.getValue(cols, ImportacoesCampoEnum.STATUS_SIMULACAO, colunas);
        }
        String solicitacao = this.getValue(cols, ImportacoesCampoEnum.TIPO_SOLICITACAO, colunas);
        String status = this.getValue(cols, ImportacoesCampoEnum.STATUS_PEDIDO, colunas);
        if (solicitacao.equals("ATIVACAO")) {
            return "CONCLU\u00cdDO";
        }
        if (solicitacao.equals("BACKLOG") && status.contains("AGENDADA")) {
            return "ENVIADO - AGENDADO";
        }
        if (solicitacao.equals("BACKLOG") && status.equals("PENDENTE")) {
            return "ENVIADO - PENDENTE";
        }
        if (solicitacao.equals("MIGRA\u00c7\u00c3O")) {
            return "MIGRA\u00c7\u00c3O";
        }
        if (status.equals("CANCELADA") || solicitacao.equals("CANCELAMENTO") || solicitacao.equals("DESCONEXAO")) {
            return "CANCELADO";
        }
        throw new Exception("Ignorar");
    }
}

