/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.login;

import br.com.system.app.MainLayout;
import br.com.system.app.components.containers.HorizontalContainer;
import br.com.system.app.components.containers.VerticalContainer;
import br.com.system.app.features.layout.UIUtils;
import br.com.system.app.features.layout.ViewFrame;
import br.com.system.app.features.layout.util.Shadow;
import br.com.system.app.features.login.DoisFatoresView;
import br.com.system.app.features.login.service.DoisFatoresService;
import br.com.system.app.features.usuario.model.Usuario;
import br.com.system.app.features.usuario.service.UsuarioService;
import br.com.system.app.features.usuario.views.UsuarioConfirmacaoView;
import br.com.system.app.security.SecurityContext;
import br.com.system.commons.HashUtil;
import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.html.Anchor;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.router.PageTitle;
import com.vaadin.flow.router.Route;
import jakarta.annotation.security.PermitAll;
import java.io.Serializable;
import org.springframework.beans.factory.annotation.Autowired;

@PermitAll
@Route(value="dois-fatores", layout=MainLayout.class)
@PageTitle(value="Cadastro dois fatores")
public class DoisFatoresCadView
extends ViewFrame
implements SecurityContext {
    private static final long serialVersionUID = 1L;
    private final UsuarioService us;
    private final DoisFatoresService dfs;
    private final UsuarioConfirmacaoView confirmacaoView;
    private VerticalContainer vcDados;
    private VerticalContainer vcInstalacao;
    private Button btnAlteraDados;
    private Button btnAtivar;
    private Anchor anchorManual;
    private Div divDados;

    @Autowired
    public DoisFatoresCadView(UsuarioService us, DoisFatoresService dfs, UsuarioConfirmacaoView confirmacaoView) {
        this.confirmacaoView = confirmacaoView;
        this.us = us;
        this.dfs = dfs;
    }

    protected void onAttach(AttachEvent attachEvent) {
        super.onAttach(attachEvent);
        if (this.autenticado()) {
            this.setViewContent(this.createContent());
        } else {
            this.showNotification("Sem permiss\u00e3o");
        }
    }

    private Anchor getAnchor(String link, String name) {
        Anchor anchor = new Anchor(link, new Component[0]);
        anchor.setTarget("_blank");
        anchor.setText(name);
        anchor.setTitle("Acesse este link para baixar e instalar O Google Authenticator");
        return anchor;
    }

    private Component createContent() {
        this.vcDados = new VerticalContainer(new Component[0]).setSpacingOn().setPaddingOn().setShadow(Shadow.S);
        this.vcInstalacao = new VerticalContainer(new Component[0]).setSpacingOn().setPaddingOn().setShadow(Shadow.S);
        this.vcInstalacao.setWidth("500px");
        this.vcInstalacao.setMinHeight("150px");
        this.vcDados.setWidth("500px");
        this.vcDados.setMinHeight("150px");
        this.divDados = new Div();
        this.divDados.setWidthFull();
        this.btnAtivar = UIUtils.createSmallButton((String)"ATIVAR AUTENTICA\u00c7\u00c3O DE 2 FATORES", (VaadinIcon)VaadinIcon.SAFE_LOCK);
        this.btnAtivar.setWidth("300px");
        this.btnAtivar.addClickListener((ComponentEventListener & Serializable)e -> this.ativar());
        this.anchorManual = new Anchor(this.isMobileDevice() ? "https://manual.neosales.com.br/2fa-mobile/" : "https://manual.neosales.com.br/2-fatores-2fa-pc/", "Acessar o Manual para Obter ajuda");
        this.anchorManual.setTarget("_blank");
        this.btnAlteraDados = UIUtils.createSmallButton((String)"Alterar dados");
        this.btnAlteraDados.addClickListener((ComponentEventListener & Serializable)b -> {
            this.confirmacaoView.create(this.getEu(), "light");
            this.confirmacaoView.addOpenedChangeListener((ComponentEventListener & Serializable)cl -> {
                if (!cl.isOpened()) {
                    this.setDados();
                }
            });
        });
        this.vcDados.add(new Component[]{this.divDados, this.btnAlteraDados});
        VerticalContainer v = new VerticalContainer(new Component[0]).setSpacingOn();
        v.add(new Component[]{this.btnAtivar, this.anchorManual, new HorizontalContainer(new Component[]{this.vcDados, this.vcInstalacao})});
        this.setDados();
        this.setInstalacao();
        return v;
    }

    private void setInstalacao() {
        String text = "Instale o Google Authenticator e clique em ATIVAR AUTENTICA\u00c7\u00c3O DE 2 FATORES <BR>";
        String linkAndroid = "https://play.google.com/store/apps/details?id=com.google.android.apps.authenticator2&hl=pt_BR&gl=US";
        String linkIos = "https://apps.apple.com/br/app/google-authenticator/id388497605";
        Div divx = new Div();
        divx.getElement().setProperty("innerHTML", "<span>Baixe e instale o aplicativo <B>GOOGLE AUTHENTICATOR</B> em seu <BR>smartphone(Android ou IOS). Procure por GOOGLE AUTHENTICATOR na Playstore ou AppleStore ou acesse o link abaixo.<BR></span>");
        Div div = new Div();
        div.setWidthFull();
        div.getElement().setProperty("innerHTML", "<span>" + text + "</span>");
        this.vcInstalacao.add(new Component[]{div, divx, this.getAnchor(linkAndroid, "Play Store(Android)"), this.getAnchor(linkIos, "Apple Store(IOS)")});
    }

    private void setDados() {
        Usuario usuario = (Usuario)this.us.getById(this.getEu().getUsuario().getId()).get();
        String text = "<B>Aten\u00e7\u00e3o! Confira seus dados para recupera\u00e7\u00e3o da conta:</b><BR>E-mail: <B>" + (usuario.getEmail() == null ? "N\u00e3o definido" : usuario.getEmail()) + "</B><BR>E-mail Alternativo: <B>" + (usuario.getEmailAlternativo() == null ? "N\u00e3o definido" : usuario.getEmailAlternativo()) + "</B><BR>Celular: <B>" + (usuario.getCelular() == null ? "N\u00e3o definido" : usuario.getCelular()) + "</B><BR>Celular Alternativo: <B>" + (usuario.getCelularAlternativo() == null ? "N\u00e3o definido" : usuario.getCelularAlternativo()) + "</B>";
        this.divDados.getElement().setProperty("innerHTML", "<span>" + text + "</span>");
    }

    private void ativar() {
        Usuario usuario = (Usuario)this.us.getById(this.getEu().getUsuario().getId()).get();
        if (!usuario.isMaster()) {
            usuario.setSecretCode(HashUtil.getUUI());
        } else if (usuario.getSecretCode() == null) {
            this.showNotification("Secret code n\u00e3o definido");
            return;
        }
        DoisFatoresView dfv = new DoisFatoresView(this.dfs);
        dfv.create(usuario.getSecretCode(), usuario, true, true);
        dfv.addOpenedChangeListener((ComponentEventListener & Serializable)open -> {
            if (!open.isOpened() && ((DoisFatoresView)open.getSource()).isAutenticado()) {
                this.us.salvar(usuario, this.getEu());
                this.showNotification("Ativado com sucesso");
            }
        });
    }
}

