/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.mailing.repository;

import br.com.system.app.features.estrutura.model.EstruturaUsuario;
import br.com.system.app.features.mailing.model.MailingMeiFilterEnum;
import br.com.system.app.features.mailing.projection.MailingLimited;
import br.com.system.app.features.mailing.repository.MailingRepositoryQuery;
import br.com.system.app.features.mailing.repository.filter.MailingFilter;
import br.com.system.app.features.mailing.repository.filter.MailingFilterRodouEnum;
import br.com.system.app.features.mailing.util.SqlBuilder;
import br.com.system.app.features.shared.handle.HandlerCepNumero;
import br.com.system.commons.StringUtil;
import br.com.system.commons.ValidationUtil;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import jakarta.persistence.Query;
import java.io.Serializable;
import java.lang.invoke.CallSite;
import java.time.LocalDate;
import java.util.HashSet;
import java.util.List;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.transaction.annotation.Transactional;

public class MailingRepositoryImpl
implements MailingRepositoryQuery,
Serializable {
    private static final long serialVersionUID = 1L;
    @PersistenceContext
    private EntityManager manager;

    @Transactional(readOnly=true)
    public Long count(MailingFilter filter, EstruturaUsuario estruturaUsuario) {
        Query query = this.getQuery(filter, estruturaUsuario, null, true);
        return (Long)query.getSingleResult();
    }

    @Transactional(readOnly=true)
    public List<MailingLimited> filter(MailingFilter filter, EstruturaUsuario estruturaUsuario, Pageable pageable) {
        Query query = this.getQuery(filter, estruturaUsuario, pageable, false);
        return query.getResultList();
    }

    private Query getQuery(MailingFilter filter, EstruturaUsuario estruturaUsuario, Pageable pageable, boolean count) {
        Query query;
        SqlBuilder builder = new SqlBuilder();
        HashSet<CallSite> hmCepNumero = new HashSet<CallSite>();
        StringBuilder sql = new StringBuilder();
        if (count) {
            sql.append("SELECT COUNT(*) as total ");
        } else {
            sql.append("SELECT  ");
            sql.append("    mailing.id as id,");
            sql.append("    mailing.cpf_cnpj AS cnpj,");
            sql.append("    mailing.nome,");
            sql.append("    mailing.ddd,");
            sql.append("    mailing.cep,");
            sql.append("    mailing.numero,");
            sql.append("    mailing.situacao,");
            sql.append("    mailing.cidade,");
            sql.append("    mailing.bairro,");
            sql.append("    mailing.estado,");
            sql.append("    mailing.porte,");
            sql.append("    mailing.capital_social ,");
            sql.append("    mailing.data_abertura ,");
            sql.append("    if(mailing.opcao_mei='S','SIM','N\u00c3O') mei");
        }
        sql.append(" FROM mailing ");
        sql.append(" WHERE 1 = 1");
        if (filter.isSomenteComCobertura()) {
            sql.append(" AND mailing.cpf_cnpj in (select vivo_prospect_bi_estrutura.cpf_cnpj from vivo_prospect_bi_estrutura where estrutura_id=:estruturaId and vivo_prospect_bi_estrutura.flag_disp=3)");
        }
        if (filter.isFilterStatus()) {
            sql.append(" AND mailing.situacao = 'ATIVA'");
        }
        if (filter.getDocsFilters() != null && !filter.getDocsFilters().isEmpty()) {
            sql.append(" AND mailing.cpf_cnpj in :cnpj");
        }
        if (filter.getEstado() != null && !filter.getEstado().isEmpty()) {
            sql.append(" AND mailing.estado = :estado");
        }
        if (!ValidationUtil.isBlank((Object)filter.getCidadeFilters())) {
            sql.append(" AND mailing.cidade in :cidade");
        }
        if (filter.getFilterMei() != null) {
            if (filter.getFilterMei().equals((Object)MailingMeiFilterEnum.IGNORAR_MEI)) {
                sql.append(" AND mailing.opcao_mei !='S'");
            } else if (filter.getFilterMei().equals((Object)MailingMeiFilterEnum.SOMENTE_MEI)) {
                sql.append(" AND mailing.opcao_mei ='S'");
            }
        }
        if (filter.isOnlyParent()) {
            sql.append(" AND mailing.matriz_filial = 'MATRIZ'");
        }
        if (!ValidationUtil.isBlank((Object)filter.getNome())) {
            sql.append(" AND (mailing.nome LIKE :nome ) ");
        }
        if (!ValidationUtil.isBlank((Object)filter.getPorteFilters())) {
            sql.append(" AND mailing.porte in :porte");
        }
        if (!ValidationUtil.isBlank((Object)filter.getCepFilters())) {
            sql.append(" AND mailing.cep in :cep");
        }
        if (!ValidationUtil.isBlank((Object)filter.getBairroFilters())) {
            sql.append(" AND mailing.bairro in :bairro");
        }
        if (!ValidationUtil.isBlank((Object)filter.getDddFilters())) {
            sql.append(" AND mailing.ddd in :ddd");
        }
        if (filter.getCapitalInicial() != null && filter.getCapitalInicial() > 0.0) {
            sql.append(" AND mailing.capital_social >=:capitalInicial");
        }
        if (filter.getCapitalFinal() != null && filter.getCapitalFinal() > 0.0) {
            sql.append(" AND mailing.capital_social <=:capitalFinal");
        }
        if (filter.getMesesAberturaMax() != null && filter.getMesesAberturaMax() > 0) {
            sql.append(" AND mailing.data_abertura >='").append(LocalDate.now().minusMonths(filter.getMesesAberturaMax().longValue())).append("'");
        }
        if (filter.getMesesAberturaMin() != null && filter.getMesesAberturaMin() > 0) {
            sql.append(" AND mailing.data_abertura <='").append(LocalDate.now().minusMonths(filter.getMesesAberturaMin().longValue())).append("'");
        }
        if (filter.getNumero() != null && !filter.getNumero().isBlank()) {
            sql.append(" AND mailing.numero='").append(filter.getNumero()).append("'");
        }
        if (filter.getOportunidade() != null && filter.getOportunidade().equals((Object)MailingFilterRodouEnum.RODOU)) {
            sql.append(" AND mailing.cpf_cnpj IN (select cpf_cnpj from oportunidade_file ofx,oportunidade_file_item oi,estrutura_usuario eu where oi.oportunidade_file_id=ofx.id and ofx.estrutura_usuario_id=eu.id and eu.estrutura_id=:estruturaId)");
        } else if (filter.getOportunidade() != null && filter.getOportunidade().equals((Object)MailingFilterRodouEnum.NAO_RODOU)) {
            sql.append(" AND mailing.cpf_cnpj NOT IN (select cpf_cnpj from oportunidade_file ofx,oportunidade_file_item oi,estrutura_usuario eu where oi.oportunidade_file_id=ofx.id and ofx.estrutura_usuario_id=eu.id and eu.estrutura_id=:estruturaId)");
        }
        if (filter.getEnriquecimento() != null && filter.getEnriquecimento().equals((Object)MailingFilterRodouEnum.RODOU)) {
            sql.append(" AND mailing.cpf_cnpj IN (select cpf_cnpj from enriquecimento f,enriquecimento_itens i,estrutura_usuario eu where i.enriquecimento_id=f.id and f.estrutura_usuario_id=eu.id and eu.estrutura_id=:estruturaId)");
        } else if (filter.getEnriquecimento() != null && filter.getEnriquecimento().equals((Object)MailingFilterRodouEnum.NAO_RODOU)) {
            sql.append(" AND mailing.cpf_cnpj NOT IN (select cpf_cnpj from enriquecimento f,enriquecimento_itens i,estrutura_usuario eu where i.enriquecimento_id=f.id and f.estrutura_usuario_id=eu.id and eu.estrutura_id=:estruturaId)");
        }
        if (filter.getProspectBi() != null && filter.getProspectBi().equals((Object)MailingFilterRodouEnum.RODOU)) {
            sql.append(" AND mailing.cpf_cnpj IN (select cpf_cnpj from vivo_prospect_bi_file vpb,vivo_prospect_bi_itens oi,estrutura_usuario eu where oi.vivo_prospect_bi_file_id=vpb.id and vpb.estrutura_usuario_id=eu.id and eu.estrutura_id=:estruturaId)");
        } else if (filter.getProspectBi() != null && filter.getProspectBi().equals((Object)MailingFilterRodouEnum.NAO_RODOU)) {
            sql.append(" AND mailing.cpf_cnpj NOT IN (select cpf_cnpj from vivo_prospect_bi_file vpb,vivo_prospect_bi_itens oi,estrutura_usuario eu where oi.vivo_prospect_bi_file_id=vpb.id and vpb.estrutura_usuario_id=eu.id and eu.estrutura_id=:estruturaId)");
        }
        if (!ValidationUtil.isBlank((Object)filter.getCnaeFilters())) {
            sql.append(" AND exists (select 1 from mailing_atividade where mailing_id=mailing.id and mailing_atividade.codigo in :cnae)");
        }
        if (filter.getFilterCep() != null && !filter.getFilterCep().isEmpty()) {
            for (HandlerCepNumero mfc : filter.getFilterCep()) {
                hmCepNumero.add((CallSite)((Object)(mfc.getCep() + "-" + mfc.getNumero())));
            }
            sql.append(" AND exists (select 1 from mailing_cep where mailing_id=mailing.id and cep_numero in :postalCodAndNumber)");
        }
        builder.GET_FILTER_VIEW(sql, filter.getSelectedView());
        Object sqlExecute = sql.toString();
        if (count) {
            query = this.manager.createNativeQuery((String)sqlExecute);
        } else {
            sqlExecute = (String)sqlExecute + " limit :limit offset :offset";
            query = this.manager.createNativeQuery((String)sqlExecute, MailingLimited.class);
        }
        if (((String)sqlExecute).contains(":cnpj")) {
            query.setParameter("cnpj", (Object)filter.getDocsFilters());
        }
        if (((String)sqlExecute).contains(":estado")) {
            query.setParameter("estado", (Object)filter.getEstado());
        }
        if (((String)sqlExecute).contains(":nome")) {
            query.setParameter("nome", (Object)(filter.getNome() + "%"));
        }
        if (((String)sqlExecute).contains(":cep")) {
            query.setParameter("cep", (Object)filter.getCepFilters());
        }
        if (((String)sqlExecute).contains(":bairro")) {
            query.setParameter("bairro", (Object)filter.getBairroFilters());
        }
        if (((String)sqlExecute).contains(":porte")) {
            query.setParameter("porte", (Object)filter.getPorteFilters());
        }
        if (((String)sqlExecute).contains(":cnae")) {
            query.setParameter("cnae", (Object)filter.getCnaeFilters());
        }
        if (((String)sqlExecute).contains(":ddd")) {
            query.setParameter("ddd", (Object)filter.getDddFilters());
        }
        if (((String)sqlExecute).contains(":cidade")) {
            query.setParameter("cidade", (Object)filter.getCidadeFilters());
        }
        if (((String)sqlExecute).contains(":capitalInicial")) {
            query.setParameter("capitalInicial", (Object)filter.getCapitalInicial());
        }
        if (((String)sqlExecute).contains("capitalFinal")) {
            query.setParameter("capitalFinal", (Object)filter.getCapitalFinal());
        }
        if (((String)sqlExecute).contains(":postalCodAndNumber")) {
            query.setParameter("postalCodAndNumber", hmCepNumero);
        }
        if (((String)sqlExecute).contains(":estruturaId")) {
            query.setParameter("estruturaId", (Object)estruturaUsuario.getEstrutura().getId());
        }
        if (((String)sqlExecute).contains(":estruturaUsuario")) {
            query.setParameter("estruturaUsuario", (Object)estruturaUsuario.getId());
        }
        if (((String)sqlExecute).contains(":limit")) {
            query.setParameter("limit", (Object)pageable.getPageSize());
            query.setParameter("offset", (Object)pageable.getOffset());
        }
        return query;
    }

    @Modifying
    @Transactional
    public void inserMailingView(List<MailingLimited> lista, EstruturaUsuario eu) {
        StringBuilder sql = new StringBuilder();
        sql.append("insert ignore into mailing_view (mailing_id,estrutura_usuario_id,data_view) values");
        for (int i = 0; i < (lista.size() > 5000 ? 5000 : lista.size()); ++i) {
            MailingLimited mailingLimited = lista.get(i);
            sql.append("('").append(mailingLimited.getId()).append("','").append(eu.getId()).append("',current_date()),");
        }
        this.manager.createNativeQuery(StringUtil.removeLastChar((String)sql.toString())).executeUpdate();
    }
}

