/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.notificacoes.components;

import br.com.system.app.features.layout.UIUtils;
import br.com.system.app.features.notificacoes.components.NotificacoesFilter;
import br.com.system.app.features.notificacoes.service.NotificacoesService;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.ItemLabelGenerator;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.combobox.ComboBox;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.textfield.TextField;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;

public class NotificacoesFilter
extends Div {
    private static final long serialVersionUID = 1L;
    private final TextField textField;
    private final ComboBox<NotificacoesService.StatusEnum> status;
    private final Button button;
    private final List<FilterEventListener> eventListeners = new ArrayList();

    public NotificacoesFilter() {
        this.getStyle().set("padding", "10px");
        this.getStyle().set("max-width", "670px");
        this.textField = new TextField();
        this.textField.setPlaceholder("Filtrar por assunto ou mensagem");
        this.textField.setClearButtonVisible(true);
        this.textField.getStyle().set("flex", "1");
        this.textField.setLabel("Pesquisar");
        this.status = new ComboBox();
        this.status.setItems(EnumSet.allOf(NotificacoesService.StatusEnum.class));
        this.status.setLabel("Status");
        this.status.setValue((Object)NotificacoesService.StatusEnum.TODOS);
        this.status.setItemLabelGenerator((ItemLabelGenerator & Serializable)s -> {
            if (s.equals((Object)NotificacoesService.StatusEnum.LIDO)) {
                return "LIDOS";
            }
            if (s.equals((Object)NotificacoesService.StatusEnum.NAO_LIDO)) {
                return "NAO LIDOS";
            }
            return "TODOS";
        });
        this.status.getStyle().set("padding-left", "5px");
        this.status.getStyle().set("padding-right", "5px");
        this.button = UIUtils.createSmallButton((String)"Pesquisar", (VaadinIcon)VaadinIcon.SEARCH);
        this.button.setDisableOnClick(true);
        this.button.addClickListener((ComponentEventListener & Serializable)event -> {
            this.notifyListeners(this.textField.getValue(), (NotificacoesService.StatusEnum)this.status.getValue());
            this.button.setEnabled(true);
        });
        this.getStyle().set("display", "flex");
        this.getStyle().set("align-items", "flex-end");
        this.getStyle().set("flex-wrap", "wrap");
        this.add(new Component[]{this.textField, this.status, this.button});
    }

    private void notifyListeners(String filterText, NotificacoesService.StatusEnum filterStatus) {
        this.eventListeners.forEach(event -> event.onFilter(filterText, filterStatus));
    }

    public void addFilterEventListener(FilterEventListener listener) {
        this.eventListeners.add(listener);
    }

    public NotificacoesService.StatusEnum getStatus() {
        return (NotificacoesService.StatusEnum)this.status.getValue();
    }

    public String getFilter() {
        return this.textField.getValue();
    }
}

