/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.notificacoes.service;

import br.com.system.app.features.broadcast.model.BroadcastNotificationDTO;
import br.com.system.app.features.broadcast.service.BroadcastNotification;
import br.com.system.app.features.estrutura.model.Estrutura;
import br.com.system.app.features.estrutura.model.EstruturaUsuario;
import br.com.system.app.features.notificacoes.model.Notificacoes;
import br.com.system.app.features.notificacoes.repository.NotificacoesRepository;
import br.com.system.app.features.notificacoes.service.NotificacoesLogService;
import br.com.system.app.features.notificacoes.service.NotificacoesService;
import br.com.system.app.features.shared.exception.BusinessException;
import br.com.system.commons.StringUtil;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
public class NotificacoesService
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Autowired
    private NotificacoesRepository notificacoesRepository;
    @Autowired
    private NotificacoesLogService notificacoesLogService;

    public Page<Notificacoes> getNotificacoes(EstruturaUsuario eu, StatusEnum statusEnum, String filter, Pageable pageable) {
        if (null != statusEnum) {
            switch (statusEnum.ordinal()) {
                case 0: {
                    if (filter.isEmpty()) {
                        return this.notificacoesRepository.findByEstruturaUsuarioAndLidoOrderByDataHoraDesc(eu, true, pageable);
                    }
                    return this.notificacoesRepository.findByAssuntoOrMensagemAndEstruturaUsuarioAndLidoOrderByDataHoraDesc(filter, filter, eu, true, pageable);
                }
                case 1: {
                    if (filter.isEmpty()) {
                        return this.notificacoesRepository.findByEstruturaUsuarioAndLidoOrderByDataHoraDesc(eu, false, pageable);
                    }
                    return this.notificacoesRepository.findByAssuntoOrMensagemAndEstruturaUsuarioAndLidoOrderByDataHoraDesc(filter, filter, eu, false, pageable);
                }
                case 2: {
                    if (filter.isEmpty()) {
                        return this.notificacoesRepository.findByEstruturaUsuarioOrderByDataHoraDesc(eu, pageable);
                    }
                    return this.notificacoesRepository.findByAssuntoOrMensagemAndEstruturaUsuarioOrderByDataHoraDesc(filter, filter, eu, pageable);
                }
            }
        }
        throw new BusinessException("Erro ao buscar notificacoes");
    }

    public long countNotificacoes(EstruturaUsuario eu, StatusEnum statusEnum, String filter) {
        switch (statusEnum.ordinal()) {
            case 0: {
                if (filter.isEmpty()) {
                    return this.notificacoesRepository.countByEstruturaUsuarioAndLidoOrderByDataHoraDesc(eu, true);
                }
                return this.notificacoesRepository.countByAssuntoOrMensagemAndEstruturaUsuarioAndLidoOrderByDataHoraDesc(filter, filter, eu, true);
            }
            case 1: {
                if (filter.isEmpty()) {
                    return this.notificacoesRepository.countByEstruturaUsuarioAndLidoOrderByDataHoraDesc(eu, false);
                }
                return this.notificacoesRepository.countByAssuntoOrMensagemAndEstruturaUsuarioAndLidoOrderByDataHoraDesc(filter, filter, eu, false);
            }
        }
        if (filter.isEmpty()) {
            return this.notificacoesRepository.countByEstruturaUsuarioOrderByDataHoraDesc(eu);
        }
        return this.notificacoesRepository.countByAssuntoOrMensagemAndEstruturaUsuarioOrderByDataHoraDesc(filter, filter, eu);
    }

    public Notificacoes notify(EstruturaUsuario eu, String assunto, String mensagem) {
        return this.notify(eu, assunto, mensagem, Boolean.valueOf(false), Boolean.valueOf(false), null);
    }

    public Notificacoes notify(EstruturaUsuario eu, String assunto, String mensagem, Boolean dontClose) {
        return this.notify(eu, assunto, mensagem, Boolean.valueOf(false), Boolean.valueOf(false), null);
    }

    public Notificacoes notify(EstruturaUsuario eu, String assunto, String mensagem, Boolean dontClose, Boolean slowClose, String tela) {
        BroadcastNotificationDTO dto = new BroadcastNotificationDTO();
        dto.setEstruturaUsuario(eu);
        dto.setAssunto(assunto);
        dto.setNotificacao(mensagem);
        BroadcastNotification.broadcast((BroadcastNotificationDTO)dto);
        Notificacoes notificacao = new Notificacoes();
        notificacao.setBucket("");
        notificacao.setHashFile("");
        notificacao.setAssunto(assunto);
        notificacao.setDataHora(LocalDateTime.now());
        notificacao.setEstruturaUsuario(eu);
        notificacao.setLido(false);
        notificacao.setMensagem(mensagem);
        return this.save(notificacao);
    }

    public List<Notificacoes> setLido(String listaNotificacoes, Estrutura estrutura, boolean lido) {
        String[] arr;
        ArrayList<Notificacoes> retorno = new ArrayList<Notificacoes>();
        for (String id : arr = listaNotificacoes.split(",")) {
            Notificacoes notificacao = this.notificacoesRepository.findById((Object)StringUtil.toLong((String)id)).orElse(null);
            if (notificacao == null || !notificacao.getEstruturaUsuario().getEstrutura().getId().equals(estrutura.getId())) {
                throw new BusinessException("Notificacao invalida");
            }
            notificacao.setLido(lido);
            retorno.add((Notificacoes)this.notificacoesRepository.save((Object)notificacao));
        }
        return retorno;
    }

    private Notificacoes save(Notificacoes notificacao) {
        if (notificacao.getEstruturaUsuario() == null) {
            throw new BusinessException("Estrutura usuario \u00e9 obrigatoria");
        }
        if (notificacao.getDataHora() == null) {
            notificacao.setDataHora(LocalDateTime.now());
        }
        if (notificacao.getAssunto().isEmpty() || notificacao.getMensagem().isEmpty()) {
            throw new BusinessException("Asunto e mensagem s\u00e3o obrigat\u00f3rios");
        }
        if (!notificacao.getHashFile().isEmpty() && notificacao.getBucket().isEmpty()) {
            throw new BusinessException("HashFile exige bucket");
        }
        return (Notificacoes)this.notificacoesRepository.save((Object)notificacao);
    }

    public Notificacoes toggle(Long notificacaoId, EstruturaUsuario eu) {
        Notificacoes notificacao = this.notificacoesRepository.findById((Object)notificacaoId).orElse(null);
        if (notificacao == null || !notificacao.getEstruturaUsuario().equals((Object)eu)) {
            throw new BusinessException("Notificacao invalida");
        }
        notificacao.setLido(!notificacao.isLido());
        return (Notificacoes)this.notificacoesRepository.save((Object)notificacao);
    }

    public long getTotalNaoLidas(EstruturaUsuario eu) {
        Page notificacoes = this.getNotificacoes(eu, StatusEnum.NAO_LIDO, "", (Pageable)PageRequest.of((int)0, (int)9999));
        return notificacoes.getTotalElements();
    }

    public void deleteByEstrutura(Estrutura estrutura) {
        this.notificacoesRepository.deleteByEstruturaUsuarioEstrutura(estrutura);
        this.notificacoesLogService.deleteByEstrutura(estrutura);
    }
}

