/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.oportunidade.repository;

import br.com.system.app.features.estrutura.model.Estrutura;
import br.com.system.app.features.oportunidade.model.OportunidadeFile;
import br.com.system.app.features.shared.model.StatusProcessoEnum;
import java.io.Serializable;
import java.util.List;
import java.util.Set;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

public interface OportunidadeFileRepository
extends JpaRepository<OportunidadeFile, Long>,
Serializable {
    public List<OportunidadeFile> findByEstruturaUsuarioEstruturaEstruturaTipoIdAndStatusProcessoOrderByIdAsc(Long var1, StatusProcessoEnum var2, Pageable var3);

    public Set<OportunidadeFile> findByEstruturaUsuarioEstrutura(Estrutura var1);

    public OportunidadeFile findFirstByDataStoneId(Integer var1);

    @Query(value="SELECT o FROM OportunidadeFile o WHERE o.estruturaUsuario.id in :hierarquia order by o.id desc")
    public List<OportunidadeFile> findByHierarquia(@Param(value="hierarquia") Long[] var1, Pageable var2);

    @Query(value="SELECT o FROM OportunidadeFile o WHERE o.estruturaUsuario.id in :hierarquia and o.nomeArquivo like %:nomeArquivo% order by o.id desc")
    public List<OportunidadeFile> findByHierarquiaAndNomeArquivo(@Param(value="hierarquia") Long[] var1, @Param(value="nomeArquivo") String var2, Pageable var3);

    @Query(value="SELECT count(*) FROM OportunidadeFile o WHERE o.estruturaUsuario.id in :hierarquia order by o.id desc")
    public int countByHierarquia(@Param(value="hierarquia") Long[] var1);

    @Query(value="SELECT count(*) FROM OportunidadeFile o WHERE o.estruturaUsuario.id in :hierarquia and o.nomeArquivo like %:nomeArquivo% order by o.id desc")
    public long countByHierarquiaAndNomeArquivo(@Param(value="hierarquia") Long[] var1, @Param(value="nomeArquivo") String var2);

    @Query(nativeQuery=true, value="SELECT count(*) total FROM oportunidade_file,oportunidade_file_item,estrutura_usuario where oportunidade_file.id=oportunidade_file_item.oportunidade_file_id and oportunidade_file.estrutura_usuario_id=estrutura_usuario.id and estrutura_usuario.estrutura_id=:estruturaId and oportunidade_file.status_processo !='FINALIZADO_COM_ERRO' and date_format(oportunidade_file.data_hora_importacao,'%Y-%m-%d')=current_date()")
    public Integer getTotalProcesso(@Param(value="estruturaId") Long var1);

    public List<OportunidadeFile> findByStatusProcesso(StatusProcessoEnum var1);
}

