/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.oportunidade.service;

import br.com.system.app.features.datastone.service.DataStoneService;
import br.com.system.app.features.estrutura.model.Estrutura;
import br.com.system.app.features.estrutura.model.EstruturaUsuario;
import br.com.system.app.features.oportunidade.model.OportunidadeFile;
import br.com.system.app.features.oportunidade.model.OportunidadeFileItem;
import br.com.system.app.features.oportunidade.repository.OportunidadeFileItemRepository;
import br.com.system.app.features.oportunidade.repository.OportunidadeFileRepository;
import br.com.system.app.features.oportunidade.service.OportunidadeLimiteService;
import br.com.system.app.features.shared.exception.BusinessException;
import br.com.system.app.features.shared.handle.HandlerExcel;
import br.com.system.app.features.shared.model.StatusProcessoEnum;
import br.com.system.app.features.shared.model.TipoProcessoEnum;
import br.com.system.app.features.storage.StorageUtil;
import br.com.system.app.features.usuario.service.UsuarioHierarquiaService;
import br.com.system.commons.StringUtil;
import br.com.system.commons.ValidationUtil;
import java.io.InputStream;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class OportunidadeService
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Autowired
    private UsuarioHierarquiaService hierarquiaService;
    @Autowired
    private OportunidadeFileItemRepository oportunidadeItemFileRepository;
    @Autowired
    private OportunidadeFileRepository oportunidadeFileRepository;
    @Autowired
    private OportunidadeLimiteService oportunidadeLimiteService;
    @Autowired
    private DataStoneService dataStoneService;
    private final HandlerExcel handlerExcel = new HandlerExcel();

    public void deletarOportunidadeFile(Long id, Estrutura estrutura) throws Exception {
        OportunidadeFile oportunidadeFile = (OportunidadeFile)this.oportunidadeFileRepository.findById((Object)id).orElseThrow(() -> new BusinessException("Oportunidade nao localizada"));
        if (!oportunidadeFile.getEstruturaUsuario().getEstrutura().getId().equals(estrutura.getId())) {
            throw new BusinessException("Nao pertence a esta estrutura.");
        }
        StorageUtil.deleteObject((String)oportunidadeFile.getUrlArquivo());
        this.oportunidadeFileRepository.delete((Object)oportunidadeFile);
    }

    public List<OportunidadeFile> getByStatus(StatusProcessoEnum status) {
        return this.oportunidadeFileRepository.findByStatusProcesso(status);
    }

    public OportunidadeFile getByDataStone(Integer dataStoneId) {
        return this.oportunidadeFileRepository.findFirstByDataStoneId(dataStoneId);
    }

    public List<OportunidadeFile> getOportunidadeFile(EstruturaUsuario eu, Pageable pageable) {
        return this.getOportunidadeFile(eu, "", pageable);
    }

    public List<OportunidadeFile> getOportunidadeFile(EstruturaUsuario eu, String filtro, Pageable pageable) {
        Long[] hierarquia = this.hierarquiaService.getHierarquiaLongArray(eu);
        if (filtro.isEmpty()) {
            return this.oportunidadeFileRepository.findByHierarquia(hierarquia, pageable);
        }
        return this.oportunidadeFileRepository.findByHierarquiaAndNomeArquivo(hierarquia, filtro, pageable);
    }

    public Set<OportunidadeFile> getByEstrutura(Estrutura estrutura) {
        return this.oportunidadeFileRepository.findByEstruturaUsuarioEstrutura(estrutura);
    }

    public long countOportunidadeFile(EstruturaUsuario eu) {
        return this.countOportunidadeFile(eu, "");
    }

    public long countOportunidadeFile(EstruturaUsuario eu, String filtro) {
        Long[] hierarquia = this.hierarquiaService.getHierarquiaLongArray(eu);
        if (filtro.isEmpty()) {
            return this.oportunidadeFileRepository.countByHierarquia(hierarquia);
        }
        return this.oportunidadeFileRepository.countByHierarquiaAndNomeArquivo(hierarquia, filtro);
    }

    public Set<OportunidadeFileItem> getItens(OportunidadeFile of) {
        return this.oportunidadeItemFileRepository.findByOportunidadeFile(of);
    }

    @Async(value="asyncDefault")
    public void exportacaoByFile(EstruturaUsuario eu, InputStream is, String nomeArquivo, TipoProcessoEnum tipo, Boolean consultaWhats) {
        Set listaCnpj = this.handlerExcel.getValueFirstColumn(is);
        this.exportacao(listaCnpj, eu, nomeArquivo, tipo, consultaWhats);
    }

    @Async(value="asyncDefault")
    public void exportacao(Set<String> listaCnpj, EstruturaUsuario eu, String nomeArquivo, TipoProcessoEnum tipo, Boolean consultaWhats) {
        try {
            this.limitCheck(listaCnpj, eu.getEstrutura());
        }
        catch (Exception e) {
            return;
        }
        nomeArquivo = StringUtil.normalize((String)nomeArquivo);
        OportunidadeFile of = new OportunidadeFile();
        HashSet<OportunidadeFileItem> listaItem = new HashSet<OportunidadeFileItem>();
        for (String cnpj : listaCnpj) {
            cnpj = StringUtil.normalizeCpfCnpj((String)cnpj);
            if (TipoProcessoEnum.CNPJ.equals((Object)tipo) && !ValidationUtil.isValidCNPJ((String)cnpj) || TipoProcessoEnum.CPF.equals((Object)tipo) && !ValidationUtil.isValidCPF((String)cnpj)) continue;
            OportunidadeFileItem ofi = new OportunidadeFileItem();
            ofi.setCpfCnpj(cnpj);
            ofi.setOportunidadeFile(of);
            listaItem.add(ofi);
        }
        of.setDataHoraImportacao(LocalDateTime.now());
        of.setEstruturaUsuario(eu);
        of.setNomeArquivo(nomeArquivo);
        of.setStatusProcesso(StatusProcessoEnum.PROCESSANDO);
        of.setTotalRegistros(Integer.valueOf(listaCnpj.size()));
        of.setOportunidadeFileItem(listaItem);
        of.setConsultaWhats(consultaWhats);
        of.setUrlArquivo("");
        this.oportunidadeFileRepository.saveAndFlush((Object)of);
        this.goOf(of, listaItem);
    }

    private void goOf(OportunidadeFile of, Set<OportunidadeFileItem> itens) {
        try {
            HashSet<String> cnpjs = new HashSet<String>();
            for (OportunidadeFileItem i : itens) {
                cnpjs.add(i.getCpfCnpj());
            }
            String url = this.dataStoneService.processarLote(of.getEstruturaUsuario(), cnpjs, of.getNomeArquivo(), Boolean.valueOf(false));
            of.setUrlArquivo(url);
            of.setStatusProcesso(StatusProcessoEnum.FINALIZADO);
            this.save(of);
        }
        catch (Exception ex) {
            of.setStatusProcesso(StatusProcessoEnum.FINALIZADO_COM_ERRO);
            of.setObservacao(ex.getMessage());
            this.save(of);
        }
    }

    public void limitCheck(Set<String> listaCnpj, Estrutura estrutura) {
        if (estrutura.getId().equals(289L)) {
            return;
        }
        Integer disp = this.getLimiteDisponivel(estrutura);
        if (listaCnpj.size() > disp) {
            throw new BusinessException("Limite de importa\u00e7\u00e3o ultrapassado, restam: " + disp);
        }
    }

    public Integer getLimiteDisponivel(Estrutura estrutura) {
        Integer totalImportadoDia = this.oportunidadeFileRepository.getTotalProcesso(estrutura.getId());
        Integer limiteDiario = this.oportunidadeLimiteService.getLimiteDiarioOportunidade(estrutura);
        return limiteDiario - totalImportadoDia;
    }

    public OportunidadeFile save(OportunidadeFile of) {
        return (OportunidadeFile)this.oportunidadeFileRepository.save((Object)of);
    }

    @Async(value="asyncDefault")
    public void reprocessar(OportunidadeFile e) {
        try {
            e.setObservacao("");
            e.setStatusProcesso(StatusProcessoEnum.PROCESSANDO);
            this.save(e);
            HashSet<String> cnpjs = new HashSet<String>();
            Set itens = this.getItens(e);
            for (OportunidadeFileItem iten : itens) {
                cnpjs.add(iten.getCpfCnpj());
            }
            String url = this.dataStoneService.processarLote(e.getEstruturaUsuario(), cnpjs, e.getNomeArquivo(), Boolean.valueOf(false));
            e.setUrlArquivo(url);
            e.setStatusProcesso(StatusProcessoEnum.FINALIZADO);
            e.setObservacao("");
        }
        catch (Exception ex) {
            e.setStatusProcesso(StatusProcessoEnum.FINALIZADO_COM_ERRO);
            e.setObservacao(ex.getMessage());
        }
        this.save(e);
    }
}

