/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.pedido.model;

import br.com.system.app.features.cliente.model.Cliente;
import br.com.system.app.features.estrutura.model.EstruturaSenhas;
import br.com.system.app.features.estrutura.model.EstruturaUsuario;
import br.com.system.app.features.modeloproposta.model.ModeloProposta;
import br.com.system.app.features.pedido.dto.PedidoTipoEnum;
import br.com.system.app.features.pedido.model.PedidoCategoria;
import br.com.system.app.features.pedido.model.PedidoEtapa;
import br.com.system.app.features.pedido.model.PedidoItem;
import br.com.system.app.features.pedido.model.PedidoMovimentacao;
import br.com.system.app.features.pedido.model.PedidoOrigem;
import br.com.system.app.features.pedido.model.PedidoSubCategoria;
import br.com.system.app.features.pedido.model.PedidoTipoNegociacaoEnum;
import br.com.system.app.features.pedido.service.LeadTypeEnum;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OneToOne;
import jakarta.persistence.Table;
import jakarta.validation.constraints.NotNull;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@Entity
@Table(name="pedido")
public class Pedido
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @OneToOne
    private EstruturaUsuario estruturaUsuario;
    @OneToOne
    private EstruturaUsuario estruturaUsuarioAdm;
    @NotNull
    @OneToOne
    private Cliente cliente;
    @Enumerated(value=EnumType.STRING)
    private PedidoTipoNegociacaoEnum tipoNegociacao;
    @NotNull
    @OneToOne
    @JsonIgnoreProperties(value={"pedidoOrigem"})
    private PedidoEtapa pedidoEtapa;
    @NotNull
    private String numero;
    @NotNull
    private LocalDate dataCadastro;
    @NotNull
    private LocalDateTime dataHoraAtualizacao;
    private LocalDateTime dataHoraOperadora;
    private BigDecimal total;
    private BigDecimal compromissoMensal;
    private BigDecimal valorFaturaOrigem;
    @OneToOne
    @NotNull
    @JsonIgnoreProperties(value={"estruturaTipo"})
    private PedidoOrigem pedidoOrigem;
    @OneToMany(mappedBy="pedido", cascade={CascadeType.ALL}, fetch=FetchType.LAZY, orphanRemoval=true, targetEntity=PedidoItem.class)
    private Set<PedidoItem> itens = new HashSet();
    @OneToMany(mappedBy="pedido", cascade={CascadeType.REMOVE}, fetch=FetchType.LAZY, orphanRemoval=true, targetEntity=PedidoMovimentacao.class)
    private Set<PedidoMovimentacao> movimentacao = new HashSet();
    private String nomeConsultorOperadora;
    private String numeroPedidoOrigem;
    private String numeroPedidoVinculado;
    private String numeroSimulacao;
    private String complementos;
    private String notasFiscais;
    private Integer revisao;
    private String loginOperadora;
    private String atividades;
    private Integer percentualTroca;
    private String tags;
    private String clusterOrigem;
    private String cotacao;
    private String codigoPortabilidade;
    private String observacaoProposta;
    @Enumerated(value=EnumType.STRING)
    private LeadTypeEnum leadSistema;
    @OneToOne
    private EstruturaSenhas estruturaSenhas;
    private LocalDate dataRetornoFuturo;
    @NotNull
    @Enumerated(value=EnumType.STRING)
    private PedidoTipoEnum pedidoTipo;
    private String hashProposta;
    @OneToOne
    private ModeloProposta modeloProposta;
    private Integer percentualDesconto;
    private LocalDateTime dataHoraUltimaMov;
    private String observacao;
    private Boolean aparelhoCartaoCredito;
    @OneToOne
    private PedidoCategoria pedidoCategoria;
    @OneToOne
    private PedidoSubCategoria pedidoSubCategoria;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public EstruturaUsuario getEstruturaUsuario() {
        return this.estruturaUsuario;
    }

    public void setEstruturaUsuario(EstruturaUsuario estruturaUsuario) {
        this.estruturaUsuario = estruturaUsuario;
    }

    public EstruturaUsuario getEstruturaUsuarioAdm() {
        return this.estruturaUsuarioAdm;
    }

    public void setEstruturaUsuarioAdm(EstruturaUsuario estruturaUsuarioAdm) {
        this.estruturaUsuarioAdm = estruturaUsuarioAdm;
    }

    public Cliente getCliente() {
        return this.cliente;
    }

    public void setCliente(Cliente cliente) {
        this.cliente = cliente;
    }

    public PedidoTipoNegociacaoEnum getTipoNegociacao() {
        return this.tipoNegociacao;
    }

    public void setTipoNegociacao(PedidoTipoNegociacaoEnum tipoNegociacao) {
        this.tipoNegociacao = tipoNegociacao;
    }

    public PedidoEtapa getPedidoEtapa() {
        return this.pedidoEtapa;
    }

    public void setPedidoEtapa(PedidoEtapa pedidoEtapa) {
        this.pedidoEtapa = pedidoEtapa;
    }

    public String getNumero() {
        return this.numero;
    }

    public void setNumero(String numero) {
        this.numero = numero;
    }

    public LocalDate getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(LocalDate dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    public LocalDateTime getDataHoraAtualizacao() {
        return this.dataHoraAtualizacao;
    }

    public void setDataHoraAtualizacao(LocalDateTime dataHoraAtualizacao) {
        this.dataHoraAtualizacao = dataHoraAtualizacao;
    }

    public BigDecimal getTotal() {
        return this.total;
    }

    public void setTotal(BigDecimal total) {
        this.total = total;
    }

    public PedidoOrigem getPedidoOrigem() {
        return this.pedidoOrigem;
    }

    public void setPedidoOrigem(PedidoOrigem pedidoOrigem) {
        this.pedidoOrigem = pedidoOrigem;
    }

    public Set<PedidoItem> getItens() {
        return this.itens;
    }

    public void setItens(Set<PedidoItem> itens) {
        this.itens = itens;
    }

    public String getNomeConsultorOperadora() {
        return this.nomeConsultorOperadora;
    }

    public void setNomeConsultorOperadora(String nomeConsultorOperadora) {
        this.nomeConsultorOperadora = nomeConsultorOperadora;
    }

    public String getNumeroPedidoOrigem() {
        return this.numeroPedidoOrigem;
    }

    public void setNumeroPedidoOrigem(String numeroPedidoOrigem) {
        this.numeroPedidoOrigem = numeroPedidoOrigem;
    }

    public String getNumeroPedidoVinculado() {
        return this.numeroPedidoVinculado;
    }

    public void setNumeroPedidoVinculado(String numeroPedidoVinculado) {
        this.numeroPedidoVinculado = numeroPedidoVinculado;
    }

    public String getComplementos() {
        return this.complementos;
    }

    public void setComplementos(String complementos) {
        this.complementos = complementos;
    }

    public String getNotasFiscais() {
        return this.notasFiscais;
    }

    public void setNotasFiscais(String notasFiscais) {
        this.notasFiscais = notasFiscais;
    }

    public Integer getRevisao() {
        return this.revisao;
    }

    public void setRevisao(Integer revisao) {
        this.revisao = revisao;
    }

    public String getLoginOperadora() {
        return this.loginOperadora;
    }

    public void setLoginOperadora(String loginOperadora) {
        this.loginOperadora = loginOperadora;
    }

    public String getAtividades() {
        return this.atividades;
    }

    public void setAtividades(String atividades) {
        this.atividades = atividades;
    }

    public Integer getPercentualTroca() {
        return this.percentualTroca;
    }

    public void setPercentualTroca(Integer percentualTroca) {
        this.percentualTroca = percentualTroca;
    }

    public String getTags() {
        return this.tags;
    }

    public void setTags(String tags) {
        this.tags = tags;
    }

    public EstruturaSenhas getEstruturaSenhas() {
        return this.estruturaSenhas;
    }

    public void setEstruturaSenhas(EstruturaSenhas estruturaSenhas) {
        this.estruturaSenhas = estruturaSenhas;
    }

    public LeadTypeEnum getLeadSistema() {
        return this.leadSistema;
    }

    public void setLeadSistema(LeadTypeEnum leadSistema) {
        this.leadSistema = leadSistema;
    }

    public LocalDate getDataRetornoFuturo() {
        return this.dataRetornoFuturo;
    }

    public void setDataRetornoFuturo(LocalDate dataRetornoFuturo) {
        this.dataRetornoFuturo = dataRetornoFuturo;
    }

    public Set<PedidoMovimentacao> getMovimentacao() {
        return this.movimentacao;
    }

    public void setMovimentacao(Set<PedidoMovimentacao> movimentacao) {
        this.movimentacao = movimentacao;
    }

    public PedidoTipoEnum getPedidoTipo() {
        return this.pedidoTipo;
    }

    public void setPedidoTipo(PedidoTipoEnum pedidoTipo) {
        this.pedidoTipo = pedidoTipo;
    }

    public String getHashProposta() {
        return this.hashProposta;
    }

    public void setHashProposta(String hashProposta) {
        this.hashProposta = hashProposta;
    }

    public ModeloProposta getModeloProposta() {
        return this.modeloProposta;
    }

    public void setModeloProposta(ModeloProposta modeloProposta) {
        this.modeloProposta = modeloProposta;
    }

    public BigDecimal getValorFaturaOrigem() {
        return this.valorFaturaOrigem;
    }

    public void setValorFaturaOrigem(BigDecimal valorFaturaOrigem) {
        this.valorFaturaOrigem = valorFaturaOrigem;
    }

    public BigDecimal getCompromissoMensal() {
        return this.compromissoMensal;
    }

    public void setCompromissoMensal(BigDecimal compromissoMensal) {
        this.compromissoMensal = compromissoMensal;
    }

    public String getClusterOrigem() {
        return this.clusterOrigem;
    }

    public void setClusterOrigem(String clusterOrigem) {
        this.clusterOrigem = clusterOrigem;
    }

    public Integer getPercentualDesconto() {
        return this.percentualDesconto;
    }

    public void setPercentualDesconto(Integer percentualDesconto) {
        this.percentualDesconto = percentualDesconto;
    }

    public int hashCode() {
        int hash = 7;
        hash = 79 * hash + Objects.hashCode(this.id);
        hash = 79 * hash + Objects.hashCode(this.numero);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Pedido other = (Pedido)obj;
        if (!Objects.equals(this.numero, other.numero)) {
            return false;
        }
        return Objects.equals(this.id, other.id);
    }

    public LocalDateTime getDataHoraOperadora() {
        return this.dataHoraOperadora;
    }

    public void setDataHoraOperadora(LocalDateTime dataHoraOperadora) {
        this.dataHoraOperadora = dataHoraOperadora;
    }

    public LocalDateTime getDataHoraUltimaMov() {
        return this.dataHoraUltimaMov;
    }

    public void setDataHoraUltimaMov(LocalDateTime dataHoraUltimaMov) {
        this.dataHoraUltimaMov = dataHoraUltimaMov;
    }

    public String getObservacao() {
        return this.observacao;
    }

    public void setObservacao(String observacao) {
        this.observacao = observacao;
    }

    public String getCotacao() {
        return this.cotacao;
    }

    public void setCotacao(String cotacao) {
        this.cotacao = cotacao;
    }

    public String getCodigoPortabilidade() {
        return this.codigoPortabilidade;
    }

    public void setCodigoPortabilidade(String codigoPortabilidade) {
        this.codigoPortabilidade = codigoPortabilidade;
    }

    public Boolean getAparelhoCartaoCredito() {
        return this.aparelhoCartaoCredito;
    }

    public void setAparelhoCartaoCredito(Boolean aparelhoCartaoCredito) {
        this.aparelhoCartaoCredito = aparelhoCartaoCredito;
    }

    public String getObservacaoProposta() {
        return this.observacaoProposta;
    }

    public void setObservacaoProposta(String observacaoProposta) {
        this.observacaoProposta = observacaoProposta;
    }

    public String getNumeroSimulacao() {
        return this.numeroSimulacao;
    }

    public void setNumeroSimulacao(String numeroSimulacao) {
        this.numeroSimulacao = numeroSimulacao;
    }

    public PedidoCategoria getPedidoCategoria() {
        return this.pedidoCategoria;
    }

    public void setPedidoCategoria(PedidoCategoria pedidoCategoria) {
        this.pedidoCategoria = pedidoCategoria;
    }

    public PedidoSubCategoria getPedidoSubCategoria() {
        return this.pedidoSubCategoria;
    }

    public void setPedidoSubCategoria(PedidoSubCategoria pedidoSubCategoria) {
        this.pedidoSubCategoria = pedidoSubCategoria;
    }
}

