/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.pedido.repository;

import br.com.system.app.features.pedido.dto.PedidoItemPropostaDTO;
import br.com.system.app.features.pedido.dto.PedidoItemResumoLinhaDTO;
import br.com.system.app.features.pedido.repository.PedidoItemRepositoryQuery;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import jakarta.persistence.Query;
import java.io.Serializable;
import java.util.List;
import org.springframework.transaction.annotation.Transactional;

public class PedidoItemRepositoryImpl
implements PedidoItemRepositoryQuery,
Serializable {
    private static final long serialVersionUID = 1L;
    @PersistenceContext
    private EntityManager manager;

    @Transactional(readOnly=true)
    public List<Long> findForEstrutura() {
        String sql = "select id from pedido_item where estrutura_id is null limit 100000";
        Query query = this.manager.createNativeQuery(sql, Long.class);
        return query.getResultList();
    }

    @Transactional(readOnly=true)
    public List<PedidoItemPropostaDTO> findPropostaItens(Long pedidoId, Boolean comp) {
        String sql = "SELECT pi.id,produto.nome nome_produto,sum(pi.quantidade) quantidade,pi.numero, sum(pi.quantidade*(pi.valor_unitario-pi.desconto_por_item)) valor, produto.quantos_megas, produto.compromisso_mensal  FROM pedido_item pi,produto   WHERE pi.pedido_id=:pedidoId AND pi.produto_id=produto.id AND produto.compromisso_mensal=:comp GROUP BY produto.id";
        Query query = this.manager.createNativeQuery(sql, PedidoItemPropostaDTO.class);
        query.setParameter("pedidoId", (Object)pedidoId);
        query.setParameter("comp", (Object)comp);
        return query.getResultList();
    }

    @Transactional(readOnly=true)
    public List<PedidoItemResumoLinhaDTO> findResumoLinhas(Long pedidoId) {
        String sql = "SELECT pi.id,pi.numero,produto.nome nome_produto  FROM pedido_item pi,produto   WHERE pi.pedido_id=:pedidoId AND pi.produto_id=produto.id AND pi.numero is not null  AND pi.numero !=''";
        Query query = this.manager.createNativeQuery(sql, PedidoItemResumoLinhaDTO.class);
        query.setParameter("pedidoId", (Object)pedidoId);
        return query.getResultList();
    }
}

