/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.pedido.service;

import br.com.system.app.features.cliente.model.ClienteContato;
import br.com.system.app.features.cliente.model.TipoContatoEnum;
import br.com.system.app.features.cliente.service.ClienteService;
import br.com.system.app.features.estrutura.model.EstruturaComplemento;
import br.com.system.app.features.estrutura.model.EstruturaUsuario;
import br.com.system.app.features.estrutura.service.EstruturaComplementoService;
import br.com.system.app.features.estrutura.service.EstruturaUsuarioService;
import br.com.system.app.features.pedido.dto.PedidoTipoEnum;
import br.com.system.app.features.pedido.model.Pedido;
import br.com.system.app.features.pedido.service.PedidoService;
import br.com.system.app.features.usuario.model.Usuario;
import br.com.system.app.features.usuario.service.UsuarioService;
import br.com.system.commons.InputStreamUtil;
import br.com.system.commons.ValidationUtil;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AtividadeIntegration
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Autowired
    private EstruturaComplementoService estruturaService;
    @Autowired
    private ClienteService clienteService;
    @Autowired
    private PedidoService pedidoService;
    @Autowired
    private UsuarioService usuarioService;
    @Autowired
    private EstruturaUsuarioService estruturaUsuarioService;

    public void doIntegration(ServletRequest request, ServletResponse response) {
        PrintWriter out;
        try {
            out = response.getWriter();
            response.setContentType("application/json");
            response.setCharacterEncoding("UTF-8");
            response.setContentType("json");
        }
        catch (IOException e) {
            return;
        }
        try {
            Optional optEu;
            Usuario usuario;
            String body = InputStreamUtil.toString((InputStream)request.getInputStream());
            if (body.isEmpty()) {
                response.setContentType("text/html; charset=UTF-8");
                out.print(this.example());
                return;
            }
            JSONObject jsonBody = new JSONObject(body);
            if (!this.getErros(jsonBody).isBlank()) {
                this.printErro(this.getErros(jsonBody), out);
                return;
            }
            EstruturaComplemento estruturaCompl = this.estruturaService.getByTokenIntegration(jsonBody.getString("token"));
            if (estruturaCompl == null) {
                this.printErro("Token Inv\u00e1lido", out);
                return;
            }
            String cnpj = jsonBody.getString("cpfCnpj");
            if (!ValidationUtil.isValidCnpjAndCpf((String)cnpj)) {
                cnpj = estruturaCompl.getEstrutura().getCpfCnpj();
            }
            EstruturaUsuario eu = null;
            if (jsonBody.has("loginUsuario") && !jsonBody.get("loginUsuario").toString().isBlank() && (usuario = this.usuarioService.getByLogin(jsonBody.getString("loginUsuario").trim())) != null && (optEu = this.estruturaUsuarioService.getByUsuarioAndEstrutura(usuario, estruturaCompl.getEstrutura())).isPresent()) {
                eu = (EstruturaUsuario)optEu.get();
            }
            if (eu == null) {
                eu = this.estruturaUsuarioService.getMasterEstrutura(estruturaCompl.getEstrutura());
            }
            Pedido pedido = new Pedido();
            pedido.setCliente(this.clienteService.getAndCreateCliente(eu, cnpj, jsonBody.getString("nomeCliente"), this.getContatos(jsonBody)));
            pedido.setComplementos("Criada via Integra\u00e7\u00e3o-Atividade<BR>" + jsonBody.getString("dados"));
            pedido.setEstruturaUsuario(eu);
            pedido.setTags(this.getTags(jsonBody));
            pedido.setPedidoTipo(PedidoTipoEnum.valueOf((String)jsonBody.getString("tipo")));
            this.pedidoService.salvar(pedido);
            this.printSucesso(out);
        }
        catch (Exception e) {
            this.printErro(e.getMessage(), out);
        }
        out.close();
    }

    private String getTags(JSONObject json) {
        HashSet<String> tags = new HashSet<String>();
        JSONArray arr = json.getJSONArray("tags");
        for (int i = 0; i < arr.length(); ++i) {
            tags.add(arr.get(i).toString());
        }
        return StringUtils.join(tags, (String)",");
    }

    private Set<ClienteContato> getContatos(JSONObject json) {
        HashSet<ClienteContato> cc = new HashSet<ClienteContato>();
        JSONArray tels = json.getJSONArray("telefone");
        for (int i = 0; i < tels.length(); ++i) {
            cc.add(new ClienteContato(TipoContatoEnum.TELEFONE, tels.get(i).toString()));
        }
        JSONArray emails = json.getJSONArray("email");
        for (int i = 0; i < tels.length(); ++i) {
            cc.add(new ClienteContato(TipoContatoEnum.EMAIL, emails.get(i).toString()));
        }
        return cc;
    }

    private String getErros(JSONObject json) {
        Object erros = "";
        try {
            if (!json.has("token") || json.getString("token").isBlank()) {
                erros = (String)erros + "Token \u00e9 obrigatorio<BR>";
            }
            if (!json.has("cpfCnpj") || !ValidationUtil.isValidCnpjAndCpf((String)json.getString("cpfCnpj"))) {
                erros = (String)erros + "CPF-CNPJ inv\u00e1lido<BR>";
            }
            if (!json.has("nomeCliente") || json.getString("nomeCliente").isBlank()) {
                erros = (String)erros + "Nome cliente obrigatorio<BR>";
            }
            if (!json.has("dados") || json.getString("dados").isBlank()) {
                erros = (String)erros + "Dados da atividade obrigatorio";
            }
            if (!json.has("tipo") || !json.getString("tipo").equals("COMERCIAL") && !json.getString("tipo").equals("POS_VENDA") && !json.getString("tipo").equals("WHATSAPP")) {
                erros = (String)erros + "Tipo deve ser COMERCIAL, POS_VENDA ou WHATSAPP";
            }
        }
        catch (Exception e) {
            erros = (String)erros + e.getMessage();
        }
        return erros;
    }

    private void printSucesso(PrintWriter out) {
        JSONObject jsonRetorno = new JSONObject();
        jsonRetorno.put("success", true);
        jsonRetorno.put("erro", (Object)"");
        out.print(jsonRetorno.toString());
    }

    private void printErro(String msg, PrintWriter out) {
        JSONObject jsonRetorno = new JSONObject();
        jsonRetorno.put("success", false);
        jsonRetorno.put("erro", (Object)msg);
        out.print(jsonRetorno.toString());
    }

    private String example() {
        return "<html><head><title>Integracao Atividade</title></head><body><div><p ><img src=\"images/logos/neo-200.png\"></p>\n<h4 ><strong><u>Integra\u00e7\u00e3o de atividade</u></strong></h4>\n<ul>\n <li>method - POST</li>\n <li>token - Obrigat\u00f3rio</li>\n <li>cpfCnpj - Obrigat\u00f3rio</li>\n <li>nomeCliente - Obrigat\u00f3rio</li>\n <li>loginUsuario - N\u00e3o Obrigat\u00f3rio, direciona a atividade ao usuario informado</li>\n <li>dados - Obrigat\u00f3rio</li>\n <li>tipo - COMERCIAL ou POS_VENDA ou WHATSAPP</li>\n</ul>\n<p>Json Body :</p>\n<pre>{\n       \"token\":\"SOLICITE_SEU_TOKEN_AO_SUPORTE\",\n       \"cpfCnpj\":\"17738735000110\",\n       \"nomeCliente\":\"NEO SISTEMAS\",\n       \"loginUsuario\":\"login@dominio\",\n       \"email\": [\n             \"contato@gmail.com.br\",\n             \"suporte@gmail.com.br\"\n               ],\n       \"telefone\":[\n               \"1133333333\",\n               \"1133334444\"\n               ],\n       \"tags\":[\n               \"#marketing\",\n               \"#sales\"\n               ],\n       \"dados\":\"Campo para descrever todos os dados pertinentes \u00e0 atividade.\",\n       \"tipo\":\"COMERCIAL ou POS_VENDA ou WHATSAPP\"\n}\n</pre>\n<p style=\"text-align: center\"><br></p></div></body></html>";
    }
}

