/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.pedido.service;

import br.com.system.app.features.cliente.model.ClienteContato;
import br.com.system.app.features.cliente.model.ClienteContatoVerficadoEnum;
import br.com.system.app.features.email.service.SendMailService;
import br.com.system.app.features.estrutura.model.Estrutura;
import br.com.system.app.features.estrutura.model.EstruturaUsuario;
import br.com.system.app.features.notificacoes.service.NotificacoesService;
import br.com.system.app.features.pedido.dto.PedidoNotificacaoDTO;
import br.com.system.app.features.pedido.model.Pedido;
import br.com.system.app.features.pedido.model.PedidoNotificacao;
import br.com.system.app.features.pedido.model.PedidoNotificacaoEnum;
import br.com.system.app.features.pedido.model.PedidoNotificacaoQuem;
import br.com.system.app.features.pedido.repository.PedidoNotificacaoRepository;
import br.com.system.app.features.whatsapp.model.WhatsAppHave;
import br.com.system.app.features.whatsapp.service.WhatsAppHaveService;
import br.com.system.commons.datetime.FormatDate;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PedidoNotificacaoService
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Autowired
    private PedidoNotificacaoRepository pedidoNotificacaoRepository;
    @Autowired
    private SendMailService sendMail;
    @Autowired
    private NotificacoesService notificacoesService;
    @Autowired
    private WhatsAppHaveService whatsAppHaveService;

    public void saveAll(List<PedidoNotificacao> notificacoes) {
        this.pedidoNotificacaoRepository.saveAll(notificacoes);
    }

    public PedidoNotificacao save(PedidoNotificacao notificacao) {
        return (PedidoNotificacao)this.pedidoNotificacaoRepository.save((Object)notificacao);
    }

    public PedidoNotificacao getById(Long id) {
        return (PedidoNotificacao)this.pedidoNotificacaoRepository.findById((Object)id).get();
    }

    public List<PedidoNotificacao> getByPedido(Pedido pedido) {
        return this.pedidoNotificacaoRepository.findByPedido(pedido);
    }

    public void delete(PedidoNotificacao pn) {
        this.pedidoNotificacaoRepository.delete((Object)pn);
    }

    public void notificacaoAtividade() {
        List pns = this.pedidoNotificacaoRepository.findNotificar(LocalDate.now(), LocalTime.now());
        for (PedidoNotificacaoDTO dto : pns) {
            PedidoNotificacao pn = this.getById(dto.getNotificacaoId());
            try {
                WhatsAppHave have;
                EstruturaUsuario notificado = pn.getQuem().equals((Object)PedidoNotificacaoQuem.PROPRIETARIO_PEDIDO) ? pn.getPedido().getEstruturaUsuario() : pn.getEstruturaUsuario();
                if (!notificado.isAtivo()) continue;
                String assunto = "Notifica\u00e7\u00e3o atividade #" + pn.getPedido().getNumero();
                if (pn.getTipo().equals((Object)PedidoNotificacaoEnum.EMAIL)) {
                    this.sendMail.sendNoReply(notificado, notificado.getUsuario().getEmail(), assunto, this.getMsg(pn));
                } else if (pn.getTipo().equals((Object)PedidoNotificacaoEnum.NOTIFICACAO)) {
                    String msg = " Cliente " + pn.getPedido().getCliente().getNome() + " \u00e0s " + String.valueOf(pn.getHora()) + (String)(pn.getObservacao() == null ? "" : " " + pn.getObservacao());
                    this.notificacoesService.notify(notificado, "Alerta Atividade #" + pn.getPedido().getNumero(), msg, Boolean.valueOf(true));
                } else if (pn.getTipo().equals((Object)PedidoNotificacaoEnum.WHATSAPP) && ((have = this.whatsAppHaveService.getHave(notificado.getUsuario().getCelular())) == null || !have.getHave().booleanValue())) {
                    throw new Exception("Telefone n\u00e3o tem whatsapp");
                }
                pn.setNotificada(Boolean.TRUE);
                this.pedidoNotificacaoRepository.save((Object)pn);
            }
            catch (Exception e) {
                pn.setNotificada(Boolean.TRUE);
                pn.setObservacao(e.getMessage());
                this.pedidoNotificacaoRepository.save((Object)pn);
            }
        }
    }

    public List<PedidoNotificacaoDTO> getNotificacaoByEstruturaUsuarioId(Long euId, boolean admin) {
        return this.pedidoNotificacaoRepository.findByEstruturaUsuarioId(euId, admin);
    }

    public List<PedidoNotificacaoDTO> getNotificacaoForExportation(Set<Long> hierarquia, LocalDate inicio, LocalDate fim) {
        return this.pedidoNotificacaoRepository.findForExportation(hierarquia, inicio, fim);
    }

    public String getMsgGA(PedidoNotificacao pn) {
        StringBuilder msg = new StringBuilder();
        msg.append("Atividade ").append(pn.getPedido().getNumero()).append(" do cliente ").append(pn.getPedido().getCliente().getCpfCnpj()).append(" ").append(pn.getPedido().getCliente().getNome());
        if (pn.getObservacao() != null && pn.getObservacao().isEmpty()) {
            msg.append("<BR>Observa\u00e7\u00e3o ").append(pn.getObservacao());
        }
        msg.append("<BR>Endere\u00e7o: ").append(pn.getPedido().getCliente().getLogradouro()).append(", ").append(pn.getPedido().getCliente().getNumero()).append(" <BR>Bairro: ").append(pn.getPedido().getCliente().getBairro()).append(" <BR>Cidade:").append(pn.getPedido().getCliente().getCidade()).append(" ").append(pn.getPedido().getCliente().getEstado()).append("<BR>Contatos:");
        int i = 0;
        for (ClienteContato cc : pn.getPedido().getCliente().getClienteContato()) {
            msg.append("<BR>").append(cc.getTipo()).append(" ").append(cc.getValor());
            if (++i <= 5) continue;
            break;
        }
        msg.append("<BR>Dados Atividade: <BR>").append(pn.getPedido().getComplementos().replace("\n", ""));
        return msg.toString();
    }

    public String getMsgWhats(PedidoNotificacao pn) {
        return this.getMsg(pn).replace("<strong>", "*").replace("</strong>", "*").replace("<BR>", "\n");
    }

    public String getMsg(PedidoNotificacao pn) {
        StringBuilder msg = new StringBuilder();
        msg.append("Ol\u00e1 ").append(pn.getPedido().getEstruturaUsuario().getUsuario().getNome()).append(" estamos passando por aqui para notifica-lo sobre a atividade <strong>#").append(pn.getPedido().getNumero()).append("</strong> do cliente <strong>").append(pn.getPedido().getCliente().getCpfCnpj()).append(" ").append(pn.getPedido().getCliente().getNome()).append("</strong>.").append("<BR><strong>Data</strong>: ").append(pn.getData().format(FormatDate.DATE_BR.toDTF())).append("<BR><strong>Hora</strong>: ").append(pn.getHora()).append("<BR><strong>Observa\u00e7\u00e3o</strong>: ").append(pn.getObservacao() == null ? "" : pn.getObservacao()).append("<BR><strong>Endere\u00e7o:</strong> ").append(pn.getPedido().getCliente().getLogradouro()).append(", ").append(pn.getPedido().getCliente().getNumero()).append(" <BR><strong>Bairro:</strong> ").append(pn.getPedido().getCliente().getBairro()).append(" <BR><strong>Cidade:</strong> ").append(pn.getPedido().getCliente().getCidade()).append(" ").append(pn.getPedido().getCliente().getEstado()).append("<BR><strong>Contatos: </strong>");
        for (ClienteContato cc : pn.getPedido().getCliente().getClienteContato()) {
            if (!cc.getVerificado().equals((Object)ClienteContatoVerficadoEnum.VALIDO)) continue;
            msg.append("<BR>").append(cc.getTipo()).append(" ").append(cc.getValor());
        }
        msg.append("<BR><strong>Dados Atividade:</strong> <BR>").append(pn.getPedido().getComplementos() == null ? "" : pn.getPedido().getComplementos().replace("\n", "<BR>")).append("<BR><BR>D\u00favidas entre em contato conosco<BR>Equipe NEO");
        return msg.toString();
    }

    public boolean getAtividadeMarcada(Long id, LocalDate data) {
        return !this.pedidoNotificacaoRepository.findAtividadeMarcada(id, data).isEmpty();
    }

    public Set<Long> getMarcadoByData(Estrutura e, LocalDate data) {
        return this.pedidoNotificacaoRepository.findMarcadoByData(e.getId(), data);
    }
}

