/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.pedido.service;

import br.com.system.app.features.estrutura.model.EstruturaSenhas;
import br.com.system.app.features.estrutura.model.EstruturaUsuario;
import br.com.system.app.features.estrutura.service.EstruturaTipoService;
import br.com.system.app.features.pedido.model.Pedido;
import br.com.system.app.features.pedido.model.PedidoTipoNegociacaoEnum;
import br.com.system.app.features.pedido.service.PedidoEtapaService;
import br.com.system.app.features.pedido.service.PedidoService;
import br.com.system.commons.StringUtil;
import java.io.Serializable;
import java.time.LocalDateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PedidoVinculoService
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Autowired
    private PedidoEtapaService pedidoEtapaService;
    @Autowired
    private PedidoService pedidoService;
    @Autowired
    private EstruturaTipoService estruturaTipoService;

    public Pedido vincularSingle(Pedido pedido, EstruturaSenhas es, EstruturaUsuario eu, String numeroPedidoOperadora, String notaFiscal, PedidoTipoNegociacaoEnum tipo, String cluster, Integer percentualDesconto, String cotacao, String codigoPortabilidade, Boolean aparelhoCartaoCredito) {
        return this.vincularSingle(pedido, es, eu, numeroPedidoOperadora, notaFiscal, tipo, cluster, percentualDesconto, cotacao, codigoPortabilidade, aparelhoCartaoCredito, null);
    }

    public Pedido vincularSingle(Pedido pedido, EstruturaSenhas es, EstruturaUsuario eu, String numeroPedidoOperadora, String notaFiscal, PedidoTipoNegociacaoEnum tipo, String cluster, Integer percentualDesconto, String cotacao, String codigoPortabilidade, Boolean aparelhoCartaoCredito, String numeroSimulacao) {
        Pedido pedOp = this.pedidoService.getByNumeroAndEstrutura(numeroPedidoOperadora, eu.getEstrutura());
        if (pedOp != null && this.estruturaTipoService.isVivo(eu.getEstrutura())) {
            pedido.setPedidoEtapa(this.pedidoEtapaService.getAndCreate(pedido.getEstruturaUsuario().getEstrutura(), pedOp.getPedidoEtapa().getNome(), pedido.getPedidoOrigem(), pedido.getPedidoTipo()));
            pedOp.setEstruturaUsuario(pedido.getEstruturaUsuario());
            pedOp.setEstruturaUsuarioAdm(pedido.getEstruturaUsuarioAdm());
            pedOp.setNumeroPedidoOrigem(pedido.getNumero());
            pedOp.setTipoNegociacao(tipo);
            this.pedidoService.salvar(pedOp);
        }
        pedido.setNumeroPedidoVinculado(numeroPedidoOperadora);
        pedido.setNumeroSimulacao(numeroSimulacao == null || numeroSimulacao.isEmpty() ? null : StringUtil.normalize((String)numeroSimulacao));
        pedido.setEstruturaSenhas(es);
        pedido.setLoginOperadora(es.getNome());
        pedido.setTipoNegociacao(tipo);
        pedido.setDataHoraAtualizacao(LocalDateTime.now());
        Object msg = "";
        if (numeroPedidoOperadora != null && !numeroPedidoOperadora.isEmpty()) {
            msg = (String)msg + "Vinculado ao " + es.getSistemasExternos().getSistemaExternoName() + " " + numeroPedidoOperadora + " Login: " + es.getNome() + "\n";
        }
        if (numeroSimulacao != null && !numeroSimulacao.isEmpty()) {
            msg = (String)msg + "Vinculado a simula\u00e7\u00e3o: " + numeroSimulacao + " Login: " + es.getNome() + "\n";
        }
        if (cotacao != null && !cotacao.isEmpty()) {
            msg = (String)msg + "Vinculado a cota\u00e7\u00e3o: " + cotacao + " Login: " + es.getNome() + "\n";
        }
        if (tipo != null) {
            msg = (String)msg + " Tipo: " + tipo.name();
        }
        if (notaFiscal != null && !notaFiscal.isBlank()) {
            pedido.setNotasFiscais(notaFiscal);
            msg = this.estruturaTipoService.isTim(eu.getEstrutura()) ? (String)msg + "\nP2B: " + notaFiscal : (String)msg + "\nNota Fiscal: " + notaFiscal;
        }
        if (cluster != null && !cluster.isBlank()) {
            pedido.setClusterOrigem(cluster);
            msg = (String)msg + "\nCluster: " + cluster;
        }
        if (percentualDesconto != null && percentualDesconto > 0) {
            pedido.setPercentualDesconto(percentualDesconto);
            msg = (String)msg + "\n% Desconto: " + percentualDesconto;
        }
        if (cotacao != null) {
            pedido.setCotacao(cotacao);
        }
        if (codigoPortabilidade != null) {
            pedido.setCodigoPortabilidade(codigoPortabilidade);
            msg = (String)msg + "\nCodigo Portabilidade: " + codigoPortabilidade;
        }
        if (aparelhoCartaoCredito != null) {
            pedido.setAparelhoCartaoCredito(aparelhoCartaoCredito);
            msg = (String)msg + "\nAparelho Cart\u00e3o Cr\u00e9dito: " + (aparelhoCartaoCredito != false ? "SIM" : "N\u00c3O");
        }
        return this.pedidoService.salvar(pedido, (String)msg, eu, true);
    }

    public void desvincularSingle(Pedido pedido, EstruturaUsuario eu) {
        pedido.setNumeroPedidoVinculado(null);
        pedido.setEstruturaSenhas(null);
        pedido.setNotasFiscais(null);
        pedido.setNumeroPedidoVinculado(null);
        pedido.setEstruturaSenhas(null);
        pedido.setClusterOrigem(null);
        pedido.setTipoNegociacao(null);
        pedido.setPercentualDesconto(null);
        pedido.setLoginOperadora(null);
        pedido.setEstruturaSenhas(null);
        pedido.setCodigoPortabilidade(null);
        pedido.setCotacao(null);
        pedido.setAparelhoCartaoCredito(null);
        pedido.setNumeroSimulacao(null);
        this.pedidoService.salvar(pedido, "Desvinculado com sucesso ", eu, true);
    }

    public Pedido desvincular(Pedido pedido, EstruturaUsuario euContext) {
        Pedido pedidoOperadora = this.pedidoService.getByNumeroAndEstrutura(pedido.getNumeroPedidoVinculado(), pedido.getEstruturaUsuario().getEstrutura());
        if (pedidoOperadora != null) {
            pedidoOperadora.setNumeroPedidoOrigem(null);
            this.pedidoService.salvar(pedidoOperadora);
        }
        pedido.setNumeroPedidoVinculado(null);
        pedido.setEstruturaSenhas(null);
        pedido.setNotasFiscais(null);
        pedido.setClusterOrigem(null);
        pedido.setCodigoPortabilidade(null);
        pedido.setCotacao(null);
        pedido.setNumeroSimulacao(null);
        return this.pedidoService.salvar(pedido, "Desvinculado com sucesso", euContext, true);
    }
}

