/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.pedido.view;

import br.com.system.app.MainLayout;
import br.com.system.app.components.ConfirmationDialog;
import br.com.system.app.components.ListField;
import br.com.system.app.components.ListFieldTypeEnum;
import br.com.system.app.components.containers.HorizontalContainer;
import br.com.system.app.components.containers.VerticalContainer;
import br.com.system.app.features.layout.UIUtils;
import br.com.system.app.features.layout.ViewFrame;
import br.com.system.app.features.layout.size.FontSize;
import br.com.system.app.features.pedido.dto.PedidoTipoEnum;
import br.com.system.app.features.pedido.model.PedidoTags;
import br.com.system.app.features.pedido.model.PedidoTagsCategoria;
import br.com.system.app.features.pedido.service.PedidoService;
import br.com.system.app.features.pedido.service.PedidoTagsService;
import br.com.system.app.features.usuario.service.UsuarioHierarquiaService;
import br.com.system.app.security.SecurityContext;
import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.button.ButtonVariant;
import com.vaadin.flow.component.combobox.ComboBox;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.radiobutton.RadioButtonGroup;
import com.vaadin.flow.data.provider.ListDataProvider;
import com.vaadin.flow.data.renderer.ComponentRenderer;
import com.vaadin.flow.data.renderer.Renderer;
import com.vaadin.flow.function.SerializableFunction;
import com.vaadin.flow.router.PageTitle;
import com.vaadin.flow.router.Route;
import jakarta.annotation.security.RolesAllowed;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.vaadin.crudui.crud.CrudListener;
import org.vaadin.crudui.crud.impl.GridCrud;
import org.vaadin.crudui.form.FieldProvider;

@Route(value="atividade-tag-cadastro", layout=MainLayout.class)
@PageTitle(value="Cadastro de tags da atividade")
@RolesAllowed(value={"ATIVIDADE_TAG_CADASTRO_VIEW"})
public class AtividadeTagCadastroView
extends ViewFrame
implements SecurityContext {
    private static final long serialVersionUID = 1L;
    private final PedidoTagsService pts;
    private final PedidoService pedidoService;
    private final UsuarioHierarquiaService hierarquiaService;
    private GridCrud<PedidoTags> crud;
    private RadioButtonGroup<PedidoTipoEnum> rbTipo;
    private final Span lblTotal = new Span();
    private ComboBox<PedidoTagsCategoria> cbFilterCategoria;

    public AtividadeTagCadastroView(PedidoTagsService pts, PedidoService pedidoService, UsuarioHierarquiaService hierarquiaService) {
        this.pts = pts;
        this.pedidoService = pedidoService;
        this.hierarquiaService = hierarquiaService;
    }

    protected void onAttach(AttachEvent attachEvent) {
        super.onAttach(attachEvent);
        if (this.autenticado()) {
            this.setViewContent(this.createContent());
        } else {
            this.showNotification("Sem permiss\u00e3o");
        }
    }

    private Component createContent() {
        ListField txtFiltro = new ListField(ListFieldTypeEnum.GENERIC_STRING, "Filtrar Tags");
        this.cbFilterCategoria = new ComboBox("categoria");
        this.cbFilterCategoria.setItems(new ListDataProvider((Collection)this.pts.getCategoria(this.getEstrutura())));
        this.cbFilterCategoria.setItemLabelGenerator(PedidoTagsCategoria::getNome);
        Button btnExcluir = UIUtils.createButton((String)"Excluir Todas", (String)"Excluir todas as tags da consulta", (ButtonVariant[])new ButtonVariant[0]);
        btnExcluir.setVisible(this.isMaster());
        btnExcluir.addClickListener((ComponentEventListener & Serializable)e -> {
            Long total = this.pts.countByEstruturaAndTipo(this.getEstrutura(), (PedidoTipoEnum)this.rbTipo.getValue(), txtFiltro.getValue(), (PedidoTagsCategoria)this.cbFilterCategoria.getValue());
            if (total <= 0L) {
                this.showNotification("N\u00e3o h\u00e1 nada para excluir");
                return;
            }
            ConfirmationDialog cd = new ConfirmationDialog("Exclusao TAGS", "Voc\u00ea est\u00e1 prestes a excluir " + total + " tags. Esse processo n\u00e3o tem volta. tem certeza que deseja continuar?");
            cd.getCancel().addClickListener((ComponentEventListener & Serializable)can -> cd.close());
            cd.getConfirm().addClickListener((ComponentEventListener & Serializable)conf -> {
                List tags = this.pts.getByEstruturaAndTipo(this.getEstrutura(), (PedidoTipoEnum)this.rbTipo.getValue(), txtFiltro.getValue(), (PedidoTagsCategoria)this.cbFilterCategoria.getValue(), (Pageable)PageRequest.of((int)0, (int)total.intValue()));
                this.excluir(tags);
                cd.close();
            });
        });
        Button btnrefresh = UIUtils.createButton((String)"Pesquisar", (String)"Pesquisar", (ButtonVariant[])new ButtonVariant[0]);
        btnrefresh.setDisableOnClick(true);
        btnrefresh.addClickListener((ComponentEventListener & Serializable)e -> {
            this.crud.refreshGrid();
            btnrefresh.setEnabled(true);
        });
        this.rbTipo = new RadioButtonGroup();
        this.rbTipo.setItems((Object[])PedidoTipoEnum.values());
        this.rbTipo.setValue((Object)PedidoTipoEnum.COMERCIAL);
        this.rbTipo.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> this.crud.refreshGrid());
        UIUtils.setFontSize((FontSize)FontSize.XXS, (Component[])new Component[]{this.rbTipo});
        this.crud = new GridCrud(PedidoTags.class);
        this.crud.setHeightFull();
        this.crud.getAddButton().setText("Adicionar");
        this.crud.getGrid().setColumns(new String[0]);
        this.crud.getGrid().addColumn((Renderer)new ComponentRenderer((SerializableFunction & Serializable)p -> UIUtils.createBreakWrapSpan((String)p.getPedidoTagsCategoria().getNome()))).setHeader("Categoria").setFlexGrow(0).setWidth("250px");
        this.crud.getGrid().addColumn((Renderer)new ComponentRenderer((SerializableFunction & Serializable)p -> UIUtils.createBreakWrapSpan((String)p.getTag()))).setHeader("Tag").setFlexGrow(0).setWidth("250px");
        this.crud.getCrudFormFactory().setUseBeanValidation(true);
        this.crud.getCrudFormFactory().setVisibleProperties(new String[]{"tag", "pedidoTagsCategoria"});
        ComboBox cbCategoria = new ComboBox("categoria");
        cbCategoria.setItems(new ListDataProvider((Collection)this.pts.getCategoria(this.getEstrutura())));
        cbCategoria.setItemLabelGenerator(PedidoTagsCategoria::getNome);
        this.crud.getCrudFormFactory().setFieldProvider("pedidoTagsCategoria", (FieldProvider & Serializable)() -> cbCategoria);
        this.crud.getAddButton().setVisible(this.hasPermission("ATIVIDADE_TAG_CADASTRO_SAVE"));
        this.crud.getUpdateButton().setVisible(this.hasPermission("ATIVIDADE_TAG_CADASTRO_SAVE"));
        this.crud.getDeleteButton().setVisible(this.hasPermission("ATIVIDADE_TAG_CADASTRO_DELETE"));
        this.crud.setCrudListener((CrudListener)new /* Unavailable Anonymous Inner Class!! */);
        HorizontalContainer h = new HorizontalContainer(new Component[]{this.lblTotal, this.rbTipo, this.cbFilterCategoria, txtFiltro, btnrefresh, btnExcluir});
        VerticalContainer v = new VerticalContainer(new Component[]{h, this.crud});
        v.setHeightFull();
        return v;
    }

    private void excluir(List<PedidoTags> tags) {
        if (this.hasPermission("IGNORAR_HIERARQUIA")) {
            this.pedidoService.excluirTag(tags, this.getEu(), new HashSet());
        } else {
            this.pedidoService.excluirTag(tags, this.getEu(), this.hierarquiaService.getHierarquia(this.getEu()));
        }
        UIUtils.showNotification((String)"Tags excluidas com sucesso");
    }
}

