/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.pedido.view;

import br.com.system.app.components.containers.VerticalContainer;
import br.com.system.app.features.estrutura.model.EstruturaUsuario;
import br.com.system.app.features.estrutura.repository.projection.HierarquiaDTO;
import br.com.system.app.features.estrutura.service.EstruturaUsuarioService;
import br.com.system.app.features.layout.UIUtils;
import br.com.system.app.features.pedido.dto.PedidoTipoEncarteiramentoEnum;
import br.com.system.app.features.pedido.service.PedidoService;
import br.com.system.app.features.producaopainel.dto.ProducaoPedidoDTO;
import br.com.system.app.features.usuario.service.UsuarioHierarquiaService;
import br.com.system.app.features.usuario.views.HierarquiaView;
import br.com.system.app.security.SecurityContext;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.dialog.Dialog;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.radiobutton.RadioButtonGroup;
import java.io.Serializable;
import java.util.List;

public class DialogAlterarUsuario
implements SecurityContext,
Serializable {
    private static final long serialVersionUID = 1L;
    private final List<ProducaoPedidoDTO> pedidos;
    private final PedidoService pedidoService;
    private final EstruturaUsuarioService eus;
    private final EstruturaUsuario eu;
    private final UsuarioHierarquiaService hierarquiaService;
    private Dialog dialog;
    private RadioButtonGroup<PedidoTipoEncarteiramentoEnum> rb;

    public DialogAlterarUsuario(EstruturaUsuario eu, List<ProducaoPedidoDTO> pedidos, PedidoService pedidoService, EstruturaUsuarioService eus, UsuarioHierarquiaService hierarquiaService) {
        this.pedidos = pedidos;
        this.hierarquiaService = hierarquiaService;
        this.pedidoService = pedidoService;
        this.eus = eus;
        this.eu = eu;
    }

    public Dialog getDialog() {
        return this.dialog;
    }

    public void open() {
        HierarquiaView hierarquiaView = new HierarquiaView(this.eu, this.eus, this.hierarquiaService);
        hierarquiaView.setMultiple(Boolean.valueOf(true));
        hierarquiaView.remove(new Component[]{hierarquiaView.getHeader()});
        this.dialog = new Dialog();
        this.dialog.setWidth("650px");
        this.rb = new RadioButtonGroup();
        this.rb.setLabel("Tipo Usu\u00e1rio");
        this.rb.setItems((Object[])PedidoTipoEncarteiramentoEnum.values());
        this.rb.setValue((Object)PedidoTipoEncarteiramentoEnum.PROPRIETARIO_PEDIDO);
        hierarquiaView.getBtnConfirmar().addClickListener((ComponentEventListener & Serializable)e -> {
            if (hierarquiaView.getValues().size() <= 0) {
                UIUtils.showNotification((String)"Selecione um usu\u00e1rio");
                return;
            }
            if (this.pedidos.size() == 1) {
                this.pedidoService.alterarUsuarioPedido((ProducaoPedidoDTO)this.pedidos.get(0), (HierarquiaDTO)hierarquiaView.getValues().iterator().next(), this.eu, (PedidoTipoEncarteiramentoEnum)this.rb.getValue(), this.hasPermission("ATIVIDADE_MOVER_NAO_EDITAVEIS"));
            } else {
                this.pedidoService.alterarUsuarioListaPedido(this.pedidos, hierarquiaView.getValues(), this.eu, (PedidoTipoEncarteiramentoEnum)this.rb.getValue(), this.hasPermission("ATIVIDADE_MOVER_NAO_EDITAVEIS"));
                UIUtils.showProcessNotification((String)"Usu\u00e1rio de Pedido(s) alterado(s) com sucesso, voce pode conferir em notifica\u00e7\u00f5es");
            }
            this.dialog.close();
        });
        hierarquiaView.getBtnFechar().addClickListener((ComponentEventListener & Serializable)e -> this.dialog.close());
        Span label = UIUtils.createSmallSpan((String)("Total Atividades: " + this.pedidos.size()));
        this.dialog.add(new Component[]{new VerticalContainer(new Component[]{label, this.rb, hierarquiaView})});
        this.dialog.open();
    }
}

