/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.pedido.view;

import br.com.system.app.MainLayout;
import br.com.system.app.components.ConfirmationDialog;
import br.com.system.app.components.containers.HorizontalContainer;
import br.com.system.app.components.containers.VerticalContainer;
import br.com.system.app.components.importacao.ImportacaoColunas;
import br.com.system.app.components.importacao.ImportacaoExcel;
import br.com.system.app.features.estrutura.service.EstruturaUsuarioService;
import br.com.system.app.features.layout.UIUtils;
import br.com.system.app.features.layout.ViewFrame;
import br.com.system.app.features.layout.size.FontSize;
import br.com.system.app.features.layout.util.Shadow;
import br.com.system.app.features.pedido.dto.PedidoTipoEnum;
import br.com.system.app.features.pedido.service.ImportacaoAtividadeThread;
import br.com.system.app.features.pedido.view.ImportacaoAtividadeView;
import br.com.system.app.features.usuario.service.UsuarioHierarquiaService;
import br.com.system.app.features.usuario.views.HierarquiaView;
import br.com.system.app.security.SecurityContext;
import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.checkbox.Checkbox;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.radiobutton.RadioButtonGroup;
import com.vaadin.flow.router.PageTitle;
import com.vaadin.flow.router.Route;
import jakarta.annotation.security.RolesAllowed;
import java.io.Serializable;
import java.util.ArrayList;

/*
 * Exception performing whole class analysis ignored.
 */
@Route(value="importacao-atividade", layout=MainLayout.class)
@PageTitle(value="Importacao atividade")
@RolesAllowed(value={"IMPORTACAO_ATIVIDADE_VIEW"})
public class ImportacaoAtividadeView
extends ViewFrame
implements SecurityContext {
    private static final long serialVersionUID = 1L;
    private ImportacaoExcel importacaoExcel;
    private final EstruturaUsuarioService eus;
    private final ImportacaoAtividadeThread iat;
    private final UsuarioHierarquiaService hierarquiaService;
    private HierarquiaView hierarquiaView;
    private Checkbox cbEu;
    private Checkbox cbUsuarioPlanilha;
    private RadioButtonGroup<AbrirInativasEnum> rbAbrirInativas;
    private RadioButtonGroup<PedidoTipoEnum> rbTipo;

    public ImportacaoAtividadeView(EstruturaUsuarioService eus, ImportacaoAtividadeThread iat, UsuarioHierarquiaService hierarquiaService) {
        this.eus = eus;
        this.hierarquiaService = hierarquiaService;
        this.iat = iat;
    }

    protected void onAttach(AttachEvent attachEvent) {
        super.onAttach(attachEvent);
        if (this.autenticado()) {
            this.setViewContent(this.create());
        }
    }

    private Component create() {
        this.rbTipo = new RadioButtonGroup();
        this.rbTipo.setItems((Object[])PedidoTipoEnum.values());
        this.rbTipo.setValue((Object)PedidoTipoEnum.COMERCIAL);
        this.rbAbrirInativas = new RadioButtonGroup();
        this.rbAbrirInativas.setItems((Object[])AbrirInativasEnum.values());
        this.rbAbrirInativas.setValue((Object)AbrirInativasEnum.NAO_ABRIR_EMPRESAS_INATIVAS);
        UIUtils.setFontSize((FontSize)FontSize.XXS, (Component[])new Component[]{this.rbTipo, this.rbAbrirInativas});
        this.hierarquiaView = new HierarquiaView(this.getEu(), this.eus, this.hierarquiaService);
        this.hierarquiaView.setMultiple(Boolean.TRUE);
        this.hierarquiaView.getBtnFechar().setVisible(false);
        this.hierarquiaView.getBtnConfirmar().setVisible(false);
        this.hierarquiaView.setWidth("500px");
        this.importacaoExcel = this.createImportacao();
        this.importacaoExcel.setHeight(this.hierarquiaView.getWidth());
        this.importacaoExcel.getBtnConfirmar().addClickListener((ComponentEventListener & Serializable)e -> {
            if (this.hierarquiaView.getValues().size() <= 0 && !((Boolean)this.cbEu.getValue()).booleanValue() && !((Boolean)this.cbUsuarioPlanilha.getValue()).booleanValue()) {
                this.showNotification("Selecione um usu\u00e1rio para atribuir");
                return;
            }
            if (!this.importacaoExcel.isValido()) {
                this.showNotification("H\u00e1 colunas obrigatorias n\u00e3o vinculadas");
                return;
            }
            ConfirmationDialog cd = new ConfirmationDialog("Criar Atividades", "Confirma cria\u00e7\u00e3o de atividade " + ((PedidoTipoEnum)this.rbTipo.getValue()).name() + " ?");
            cd.getCancel().addClickListener((ComponentEventListener & Serializable)cancel -> cd.close());
            cd.getConfirm().addClickListener((ComponentEventListener & Serializable)confirmar -> {
                this.iat.processarArquivo(this.importacaoExcel.getPosicoes(), this.importacaoExcel.getContent(), this.importacaoExcel.getNomeArquivo(), this.getEu(), this.hierarquiaView.getValues(), (PedidoTipoEnum)this.rbTipo.getValue(), ((AbrirInativasEnum)this.rbAbrirInativas.getValue()).equals((Object)AbrirInativasEnum.ABRIR_EMPRESAS_INATIVAS));
                UIUtils.showProcessNotification();
                this.importacaoExcel.clear();
                cd.close();
            });
        });
        Button btnEmail = UIUtils.createSmallButton((String)"Email", (VaadinIcon)VaadinIcon.PLUS, (String)"Inserir Coluna de Email");
        btnEmail.addClickListener((ComponentEventListener & Serializable)e -> {
            int ind = 1;
            for (ImportacaoColunas ic : this.importacaoExcel.getColunas()) {
                if (!ic.getNome().contains("E-MAIL")) continue;
                ++ind;
            }
            this.importacaoExcel.getColunas().add(new ImportacaoColunas("E-MAIL " + ind, Boolean.FALSE));
            this.importacaoExcel.refreshGrid();
        });
        Button btnTel = UIUtils.createSmallButton((String)"Telefone", (VaadinIcon)VaadinIcon.PLUS, (String)"Inserir Coluna de Telefone");
        btnTel.addClickListener((ComponentEventListener & Serializable)e -> {
            int ind = 1;
            for (ImportacaoColunas ic : this.importacaoExcel.getColunas()) {
                if (!ic.getNome().contains("TELEFONE")) continue;
                ++ind;
            }
            this.importacaoExcel.getColunas().add(new ImportacaoColunas("TELEFONE " + ind, Boolean.FALSE));
            this.importacaoExcel.refreshGrid();
        });
        UIUtils.setShadow((Shadow)Shadow.M, (Component[])new Component[]{this.hierarquiaView});
        this.cbEu = new Checkbox("Atribuir pra mim", false);
        this.cbEu.addValueChangeListener((HasValue.ValueChangeListener & Serializable)c -> {
            if (((Boolean)c.getValue()).booleanValue()) {
                this.hierarquiaView.clearSelection();
            }
            this.hierarquiaView.setEnabled((Boolean)c.getValue() == false);
        });
        this.cbUsuarioPlanilha = new Checkbox("Atribuir via Planilha", false);
        this.cbUsuarioPlanilha.addValueChangeListener((HasValue.ValueChangeListener & Serializable)c -> {
            if (((Boolean)c.getValue()).booleanValue()) {
                this.hierarquiaView.clearSelection();
            }
            this.hierarquiaView.setEnabled((Boolean)c.getValue() == false);
        });
        HorizontalContainer main = new HorizontalContainer(new Component[0]);
        VerticalContainer direita = new VerticalContainer(new Component[0]);
        VerticalContainer esquerda = new VerticalContainer(new Component[0]);
        main.add(new Component[]{direita, esquerda});
        direita.add(new Component[]{new HorizontalContainer(new Component[]{this.rbTipo, this.rbAbrirInativas}), this.importacaoExcel});
        direita.add(new Component[]{new HorizontalContainer(new Component[]{btnTel, btnEmail})});
        esquerda.add(new Component[]{new HorizontalContainer(new Component[]{this.cbEu, this.cbUsuarioPlanilha}), this.hierarquiaView});
        return main;
    }

    private ImportacaoExcel createImportacao() {
        ArrayList<ImportacaoColunas> colunas = new ArrayList<ImportacaoColunas>();
        colunas.add(new ImportacaoColunas("CPF_CNPJ", Boolean.TRUE));
        colunas.add(new ImportacaoColunas("NOME", Boolean.FALSE));
        colunas.add(new ImportacaoColunas("INFORMA\u00c7\u00d5ES ATIVIDADE", Boolean.TRUE));
        colunas.add(new ImportacaoColunas("TAGS", Boolean.FALSE));
        colunas.add(new ImportacaoColunas("E-MAIL 1", Boolean.FALSE));
        colunas.add(new ImportacaoColunas("E-MAIL 2", Boolean.FALSE));
        colunas.add(new ImportacaoColunas("TELEFONE 1", Boolean.FALSE));
        colunas.add(new ImportacaoColunas("TELEFONE 2", Boolean.FALSE));
        colunas.add(new ImportacaoColunas("LOGIN_USUARIO", Boolean.FALSE));
        ImportacaoExcel ie = new ImportacaoExcel(colunas);
        return ie;
    }
}

