/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.pessoa.service;

import br.com.system.app.features.cliente.model.Cliente;
import br.com.system.app.features.cliente.service.ClienteLogService;
import br.com.system.app.features.estrutura.model.EstruturaUsuario;
import br.com.system.app.features.pessoa.model.Pessoa;
import br.com.system.app.features.pessoa.repository.PessoaRepository;
import br.com.system.app.features.shared.exception.BusinessException;
import br.com.system.commons.ValidationUtil;
import java.io.Serializable;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PessoaService
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Autowired
    private PessoaRepository pessoaRepository;
    @Autowired
    private ClienteLogService clienteLogService;

    @Transactional
    public Pessoa save(Pessoa pessoa, Cliente cliente, EstruturaUsuario eu) {
        if (pessoa.getCliente() == null) {
            pessoa.setCliente(cliente);
        }
        if (!pessoa.getCpf().isBlank() && !ValidationUtil.isValidCPF((String)pessoa.getCpf())) {
            throw new BusinessException("Cpf inv\u00e1lido");
        }
        if (pessoa.getNome().isBlank()) {
            throw new BusinessException("Nome \u00e9 obrigatorio");
        }
        String log = pessoa.getId() == null ? "Pessoa " + pessoa.getNome() + " inserida\n" : "Pessoa " + pessoa.getNome() + " atualizada\n";
        this.clienteLogService.salvar(cliente, eu, log);
        return (Pessoa)this.pessoaRepository.save((Object)pessoa);
    }

    @Transactional
    public void delete(Cliente cliente, Pessoa pessoa, EstruturaUsuario eu) {
        this.clienteLogService.salvar(cliente, eu, "Pessoa " + pessoa.getNome() + " exclu\u00edda\n");
        this.pessoaRepository.delete(pessoa);
    }

    public long countByCliente(Cliente cliente) {
        return this.pessoaRepository.countByCliente(cliente);
    }

    public List<Pessoa> getByCliente(Cliente cliente, Pageable pageable) {
        return this.pessoaRepository.findByCliente(cliente, pageable);
    }

    public List<Pessoa> getByClienteId(Long clienteId) {
        return this.pessoaRepository.findByClienteId(clienteId);
    }
}

