/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.producaopainel.repository;

import br.com.system.app.features.estrutura.model.EstruturaUsuario;
import br.com.system.app.features.producaopainel.dto.ProducaoPainelDetalhamentoDTO;
import br.com.system.app.features.producaopainel.dto.ProducaoPainelResumoDTO;
import br.com.system.app.features.producaopainel.model.ProducaoPainelBox;
import br.com.system.app.features.producaopainel.model.ProducaoPainelResumo;
import br.com.system.app.features.producaopainel.repository.ProducaoPainelResumoRepositoryQuery;
import br.com.system.commons.datetime.DateTimeUtil;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import jakarta.persistence.Query;
import java.time.LocalDate;
import java.util.List;
import java.util.Set;
import org.springframework.transaction.annotation.Transactional;

public class ProducaoPainelResumoRepositoryImpl
implements ProducaoPainelResumoRepositoryQuery {
    @PersistenceContext
    private EntityManager manager;

    @Transactional(readOnly=true)
    public List<ProducaoPainelResumoDTO> getGraficoGrupo(EstruturaUsuario eu, ProducaoPainelBox box, Set<Long> hierarquia, String mesAno) {
        StringBuilder sql = new StringBuilder();
        sql.append("select (select uuid_short()) as id,grupo nome,sum(quantidade) quantidade,sum(valor) valor ,mes_ano,login_usuario");
        sql.append(" from producao_painel_resumo\n");
        sql.append(" where producao_painel_resumo.estrutura_usuario_id in :hierarquia\n");
        this.setQuery(sql, box);
        this.setSqlData(sql, mesAno, Integer.valueOf(0));
        sql.append(" group by producao_painel_resumo.grupo order by grupo");
        Query query = this.manager.createNativeQuery(sql.toString(), ProducaoPainelResumoDTO.class);
        this.setParameters(query, box, hierarquia);
        return query.getResultList();
    }

    @Transactional(readOnly=true)
    public List<ProducaoPainelResumoDTO> getGraficoFila(EstruturaUsuario eu, ProducaoPainelBox box, Set<Long> hierarquia, String mesAno) {
        StringBuilder sql = new StringBuilder();
        sql.append("select (select uuid_short()) as id,fila nome,sum(quantidade) quantidade,sum(valor) valor ,mes_ano,login_usuario");
        sql.append(" from producao_painel_resumo\n");
        sql.append(" where producao_painel_resumo.estrutura_usuario_id in :hierarquia\n");
        this.setQuery(sql, box);
        this.setSqlData(sql, mesAno, Integer.valueOf(0));
        sql.append(" group by producao_painel_resumo.fila order by fila");
        Query query = this.manager.createNativeQuery(sql.toString(), ProducaoPainelResumoDTO.class);
        this.setParameters(query, box, hierarquia);
        return query.getResultList();
    }

    @Transactional(readOnly=true)
    public List<ProducaoPainelResumoDTO> getGraficoAnual(EstruturaUsuario eu, ProducaoPainelBox box, Set<Long> hierarquia, String mesAno) {
        StringBuilder sql = new StringBuilder();
        sql.append("select (select uuid_short()) as id,mes_ano nome,sum(quantidade) quantidade,sum(valor) valor ,mes_ano,login_usuario");
        sql.append(" from producao_painel_resumo\n");
        sql.append(" where producao_painel_resumo.estrutura_usuario_id in :hierarquia\n");
        this.setQuery(sql, box);
        this.setSqlData(sql, mesAno, Integer.valueOf(12));
        sql.append(" group by mes_ano order by mes_ano");
        Query query = this.manager.createNativeQuery(sql.toString(), ProducaoPainelResumoDTO.class);
        this.setParameters(query, box, hierarquia);
        return query.getResultList();
    }

    @Transactional(readOnly=true)
    public List<ProducaoPainelResumoDTO> getResumo(EstruturaUsuario eu, ProducaoPainelBox box, Set<Long> hierarquia, String mesAno) {
        StringBuilder sql = new StringBuilder();
        sql.append("select (select uuid_short()) as id,'' nome,sum(quantidade) quantidade,sum(valor) valor ,mes_ano,login_usuario");
        sql.append(" from producao_painel_resumo\n");
        sql.append(" where producao_painel_resumo.estrutura_usuario_id in :hierarquia\n");
        this.setQuery(sql, box);
        this.setSqlData(sql, mesAno, Integer.valueOf(2));
        sql.append(" group by mes_ano order by mes_ano");
        Query query = this.manager.createNativeQuery(sql.toString(), ProducaoPainelResumoDTO.class);
        this.setParameters(query, box, hierarquia);
        return query.getResultList();
    }

    @Transactional(readOnly=true)
    public List<ProducaoPainelResumoDTO> getRanking(EstruturaUsuario eu, ProducaoPainelBox box, Set<Long> hierarquia, String mesAno) {
        StringBuilder sql = new StringBuilder();
        sql.append("select (select uuid_short()) as id,'' nome,sum(quantidade) quantidade,sum(valor) valor ,mes_ano,login_usuario");
        sql.append(" from producao_painel_resumo,estrutura_usuario,usuario\n");
        sql.append(" WHERE producao_painel_resumo.estrutura_usuario_id=estrutura_usuario.id and estrutura_usuario.usuario_id=usuario.id and usuario.vendedor=1");
        sql.append(" AND producao_painel_resumo.estrutura_usuario_id in :hierarquia\n");
        this.setSqlData(sql, mesAno, Integer.valueOf(0));
        this.setQuery(sql, box);
        sql.append(" group by estrutura_usuario_id order by valor desc");
        Query query = this.manager.createNativeQuery(sql.toString(), ProducaoPainelResumoDTO.class);
        this.setParameters(query, box, hierarquia);
        return query.getResultList();
    }

    @Transactional(readOnly=true)
    public List<ProducaoPainelResumoDTO> getByConsultor(EstruturaUsuario eu, ProducaoPainelBox box, Set<Long> hierarquia, String mesAno) {
        StringBuilder sql = new StringBuilder();
        sql.append("select (select uuid_short()) as id,'' nome,count(*) quantidade , 0 valor ,mes_ano,login_usuario");
        sql.append(" from producao_painel_resumo,estrutura_usuario,usuario\n");
        sql.append(" WHERE producao_painel_resumo.estrutura_usuario_id=estrutura_usuario.id and estrutura_usuario.usuario_id=usuario.id and usuario.vendedor=1");
        sql.append(" AND producao_painel_resumo.estrutura_usuario_id in :hierarquia\n");
        this.setQuery(sql, box);
        this.setSqlData(sql, mesAno, Integer.valueOf(2));
        sql.append(" group by mes_ano,estrutura_usuario_id order by mes_ano");
        Query query = this.manager.createNativeQuery(sql.toString(), ProducaoPainelResumoDTO.class);
        this.setParameters(query, box, hierarquia);
        return query.getResultList();
    }

    @Transactional(readOnly=true)
    public List<ProducaoPainelResumoDTO> getByCnpj(EstruturaUsuario eu, ProducaoPainelBox box, Set<Long> hierarquia, String mesAno) {
        StringBuilder sql = new StringBuilder();
        sql.append("select (select uuid_short()) as id,'' nome,count(*) quantidade , 0 valor ,mes_ano,login_usuario");
        sql.append(" from producao_painel_resumo\n");
        sql.append(" WHERE producao_painel_resumo.estrutura_usuario_id in :hierarquia\n");
        this.setQuery(sql, box);
        this.setSqlData(sql, mesAno, Integer.valueOf(2));
        sql.append(" group by mes_ano,cpf_cnpj order by mes_ano");
        Query query = this.manager.createNativeQuery(sql.toString(), ProducaoPainelResumoDTO.class);
        this.setParameters(query, box, hierarquia);
        return query.getResultList();
    }

    @Transactional(readOnly=true)
    public List<ProducaoPainelDetalhamentoDTO> getDetalhamento(EstruturaUsuario eu, ProducaoPainelBox box, Set<Long> hierarquia, String mesAno) {
        StringBuilder sql = new StringBuilder();
        sql.append("select id,numero,cpf_cnpj,nome_cliente,login_usuario,fila,sum(valor) valor,sum(quantidade) quantidade");
        sql.append(" from producao_painel_resumo where producao_painel_resumo.estrutura_usuario_id in :hierarquia\n");
        this.setQuery(sql, box);
        this.setSqlData(sql, mesAno, Integer.valueOf(2));
        sql.append(" group by pedido_id order by data_atualizacao desc");
        Query query = this.manager.createNativeQuery(sql.toString(), ProducaoPainelDetalhamentoDTO.class);
        this.setParameters(query, box, hierarquia);
        return query.getResultList();
    }

    @Transactional(readOnly=true)
    public List<ProducaoPainelResumo> getExportacao(EstruturaUsuario eu, ProducaoPainelBox box, Set<Long> hierarquia, String mesAno) {
        StringBuilder sql = new StringBuilder();
        sql.append("select * from producao_painel_resumo where producao_painel_resumo.estrutura_usuario_id in :hierarquia\n");
        this.setQuery(sql, box);
        this.setSqlData(sql, mesAno, Integer.valueOf(2));
        Query query = this.manager.createNativeQuery(sql.toString(), ProducaoPainelResumo.class);
        this.setParameters(query, box, hierarquia);
        return query.getResultList();
    }

    private void setParameters(Query query, ProducaoPainelBox box, Set<Long> hierarquia) {
        query.setParameter("hierarquia", hierarquia);
        query.setParameter("filas", (Object)box.getFilas());
        query.setParameter("grupos", (Object)box.getGrupos());
        if (box.getEquipes() != null && !box.getEquipes().isEmpty()) {
            query.setParameter("equipes", (Object)box.getEquipes());
        }
    }

    private void setQuery(StringBuilder sql, ProducaoPainelBox box) {
        if (box.getNaoContemFilas() != null && box.getNaoContemFilas().booleanValue()) {
            sql.append(" and not find_in_set(producao_painel_resumo.producao_colunas_id,:filas)");
        } else {
            sql.append(" and find_in_set(producao_painel_resumo.producao_colunas_id,:filas)");
        }
        if (box.getNaoContemGrupos() != null && box.getNaoContemGrupos().booleanValue()) {
            sql.append(" and not find_in_set(producao_painel_resumo.producao_linhas_id,:grupos)");
        } else {
            sql.append(" and find_in_set(producao_painel_resumo.producao_linhas_id,:grupos)");
        }
        if (box.getEquipes() != null && !box.getEquipes().isEmpty()) {
            sql.append(" and find_in_set(producao_painel_resumo.equipe_id,:equipes)");
        }
    }

    private void setSqlData(StringBuilder sql, String mesAno, Integer minus) {
        LocalDate dataAtual = LocalDate.of(Integer.parseInt(mesAno.substring(2, 6)), Integer.parseInt(mesAno.substring(0, 2)), 1);
        sql.append(" and producao_painel_resumo.data_atualizacao >='").append(dataAtual.minusMonths(minus.intValue())).append("' and producao_painel_resumo.data_atualizacao <='").append(DateTimeUtil.getLastDayOfMonth((LocalDate)dataAtual)).append("'");
    }
}

