/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.producaopainel.views;

import br.com.system.app.MainLayout;
import br.com.system.app.components.Card;
import br.com.system.app.components.ConfirmationDialog;
import br.com.system.app.components.ListField;
import br.com.system.app.components.ListFieldTypeEnum;
import br.com.system.app.features.layout.FlexBoxLayout;
import br.com.system.app.features.layout.UIUtils;
import br.com.system.app.features.layout.ViewFrame;
import br.com.system.app.features.pedido.service.PedidoDeleteService;
import br.com.system.app.security.SecurityContext;
import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.orderedlayout.FlexComponent;
import com.vaadin.flow.component.orderedlayout.FlexLayout;
import com.vaadin.flow.router.PageTitle;
import com.vaadin.flow.router.Route;
import jakarta.annotation.security.RolesAllowed;
import java.io.Serializable;
import org.springframework.beans.factory.annotation.Autowired;

@Route(value="baixar-excluir-pedidos", layout=MainLayout.class)
@PageTitle(value="Baixar/Excluir pedidos manualmente")
@RolesAllowed(value={"MASTER"})
public class ExcluirPedidosView
extends ViewFrame
implements SecurityContext {
    private static final long serialVersionUID = 1L;
    private final PedidoDeleteService pedidoDeleteService;

    @Autowired
    public ExcluirPedidosView(PedidoDeleteService pedidoDeleteService) {
        this.pedidoDeleteService = pedidoDeleteService;
    }

    protected void onAttach(AttachEvent attachEvent) {
        super.onAttach(attachEvent);
        if (this.autenticado() && this.isMaster()) {
            this.setViewContent(this.createContent());
        } else {
            this.showNotification("Sem permiss\u00e3o");
        }
    }

    private Component createContent() {
        FlexBoxLayout main = new FlexBoxLayout(FlexLayout.FlexDirection.COLUMN, new Component[0]).setSpacingM();
        main.setAlignItems(FlexComponent.Alignment.CENTER);
        Card card = new Card();
        card.setMaxWidth("400px");
        card.setHeader("Excluir pedidos");
        card.getContentBox().setAlignItems(FlexComponent.Alignment.BASELINE);
        ListField listaPedido = new ListField(ListFieldTypeEnum.GENERIC_STRING, "Lista Pedidos COMERCIAL OU POS_VENDA ");
        Button btnEx = UIUtils.createSmallButton((String)"Excluir", (VaadinIcon)VaadinIcon.TRASH, (String)"Excluir pedidos");
        btnEx.setVisible(this.isMaster());
        btnEx.addClickListener((ComponentEventListener & Serializable)e -> {
            if (listaPedido.getValue().size() <= 0) {
                this.showNotification("Informe pelo menos um pedido");
                return;
            }
            ConfirmationDialog cd = new ConfirmationDialog("Exclus\u00e3o", "Confirma a exclus\u00e3o dos pedidos informados?");
            cd.getCancel().addClickListener((ComponentEventListener & Serializable)cancel -> cd.close());
            cd.getConfirm().addClickListener((ComponentEventListener & Serializable)confirm -> {
                this.pedidoDeleteService.deletarByLista(listaPedido.getValue(), this.getEu());
                cd.close();
                listaPedido.clear();
                this.showNotification("Processo iniciado, ao final vc ser\u00e1 notificado");
            });
        });
        card.setContent(new Component[]{listaPedido});
        card.setFooter(new Component[]{btnEx});
        main.add(new Component[]{card});
        return main;
    }
}

