/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.producaopainel.views.cadastro;

import br.com.system.app.components.containers.HorizontalContainer;
import br.com.system.app.components.containers.VerticalContainer;
import br.com.system.app.features.estrutura.model.EstruturaUsuario;
import br.com.system.app.features.layout.UIUtils;
import br.com.system.app.features.pedido.dto.PedidoTipoEnum;
import br.com.system.app.features.pedido.model.PedidoEtapa;
import br.com.system.app.features.pedido.service.PedidoEtapaService;
import br.com.system.app.features.producaopainel.model.ProducaoColunas;
import br.com.system.app.features.producaopainel.model.ProducaoPedidoEtapa;
import br.com.system.app.features.producaopainel.service.ProducaoPedidoEtapaService;
import br.com.system.app.security.SecurityContext;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.ItemLabelGenerator;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.combobox.ComboBox;
import com.vaadin.flow.component.dialog.Dialog;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.textfield.TextField;
import com.vaadin.flow.data.renderer.Renderer;
import com.vaadin.flow.data.renderer.TextRenderer;
import java.io.Serializable;
import java.util.Collection;
import org.vaadin.crudui.crud.CrudListener;
import org.vaadin.crudui.crud.impl.GridCrud;

public class ProducaoEtapaView
extends Dialog
implements SecurityContext {
    private static final long serialVersionUID = 1L;
    private final PedidoEtapaService pes;
    private final ProducaoPedidoEtapaService ppes;
    private final ProducaoColunas coluna;
    private final EstruturaUsuario eu;
    private final PedidoTipoEnum pte;

    public ProducaoEtapaView(PedidoEtapaService pes, ProducaoPedidoEtapaService ppes, ProducaoColunas coluna, EstruturaUsuario eu, PedidoTipoEnum pte) {
        this.pes = pes;
        this.pte = pte;
        this.ppes = ppes;
        this.coluna = coluna;
        this.eu = eu;
        this.createContent();
    }

    private void createContent() {
        if (this.coluna == null) {
            UIUtils.showNotification((String)"Coluna esta nula");
            return;
        }
        this.setWidth("600px");
        this.setHeight("650px");
        GridCrud crud = new GridCrud(ProducaoPedidoEtapa.class);
        ComboBox cbEtapa = new ComboBox("Etapa Pedido", (Collection)this.pes.getAtivos(this.eu.getEstrutura(), this.pte));
        cbEtapa.setItemLabelGenerator(PedidoEtapa::getNomeAndOrigem);
        cbEtapa.setWidth("450px");
        Button add = UIUtils.createSmallButton((VaadinIcon)VaadinIcon.PLUS, (String)"Adicionar etapa");
        add.addClickListener((ComponentEventListener & Serializable)e -> {
            if (cbEtapa.getValue() == null) {
                UIUtils.showNotification((String)"Selecione uma etapa para inserir");
                return;
            }
            ProducaoPedidoEtapa ppe = new ProducaoPedidoEtapa();
            ppe.setPedidoEtapa((PedidoEtapa)cbEtapa.getValue());
            ppe.setProducaoColunas(this.coluna);
            this.ppes.save(ppe);
            crud.refreshGrid();
        });
        TextField filter = new TextField();
        filter.setPlaceholder("Filtrar por nome");
        filter.setClearButtonVisible(true);
        crud.getCrudLayout().addFilterComponent((Component)filter);
        crud.getGrid().setColumns(new String[0]);
        crud.getGrid().addColumn((Renderer)new TextRenderer((ItemLabelGenerator & Serializable)p -> p.getPedidoEtapa().getNome())).setFlexGrow(0).setWidth("350px").setHeader("Etapa");
        crud.getGrid().addColumn((Renderer)new TextRenderer((ItemLabelGenerator & Serializable)p -> p.getPedidoEtapa().getPedidoOrigem().getNome())).setFlexGrow(0).setWidth("250px").setHeader("Origem");
        crud.getAddButton().setVisible(false);
        crud.getUpdateButton().setVisible(false);
        crud.getDeleteButton().setVisible(this.hasPermission("PAINEL_PRODUCAO_DELETE"));
        crud.setCrudListener((CrudListener)new /* Unavailable Anonymous Inner Class!! */);
        filter.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> crud.refreshGrid());
        Button fechar = UIUtils.createSmallButton((String)"Fechar", (VaadinIcon)VaadinIcon.CLOSE);
        fechar.addClickListener((ComponentEventListener & Serializable)close -> this.close());
        this.add(new Component[]{UIUtils.createHeader((String)("Configura\u00e7\u00f5es Etapa Pedido coluna: " + this.coluna.getNome())), new HorizontalContainer(new Component[]{cbEtapa, add}), new VerticalContainer(new Component[]{crud, fechar})});
    }
}

