/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.producaopainel.views.cadastro;

import br.com.system.app.components.containers.HorizontalContainer;
import br.com.system.app.components.containers.VerticalContainer;
import br.com.system.app.features.layout.UIUtils;
import br.com.system.app.features.pedido.repository.PedidoItemSolicitacaoRepository;
import br.com.system.app.features.producaopainel.model.ProducaoLinhas;
import br.com.system.app.features.producaopainel.model.ProducaoPainel;
import br.com.system.app.features.producaopainel.repository.ProducaoTipoSolicitacaoRepository;
import br.com.system.app.features.producaopainel.service.ProducaoLinhasService;
import br.com.system.app.features.producaopainel.service.ProducaoProdutosService;
import br.com.system.app.features.producaopainel.views.cadastro.ProducaoProdutoView;
import br.com.system.app.features.producaopainel.views.cadastro.ProducaoSolicitacaoView;
import br.com.system.app.features.produto.service.ProdutoService;
import br.com.system.app.security.SecurityContext;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.dialog.Dialog;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.textfield.TextField;
import java.io.Serializable;
import org.vaadin.crudui.crud.CrudListener;
import org.vaadin.crudui.crud.CrudOperation;
import org.vaadin.crudui.crud.impl.GridCrud;

public class ProducaoLinhaView
extends Dialog
implements SecurityContext {
    private static final long serialVersionUID = 1L;
    private final ProducaoLinhasService pls;
    private final ProducaoProdutosService pps;
    private final ProducaoTipoSolicitacaoRepository pts;
    private final ProdutoService ps;
    private final ProducaoPainel painel;
    private GridCrud<ProducaoLinhas> crud;
    private final PedidoItemSolicitacaoRepository pisr;

    public ProducaoLinhaView(ProducaoLinhasService pls, ProducaoProdutosService pps, ProducaoTipoSolicitacaoRepository pts, ProdutoService ps, ProducaoPainel painel, PedidoItemSolicitacaoRepository pisr) {
        this.pls = pls;
        this.pps = pps;
        this.pts = pts;
        this.ps = ps;
        this.painel = painel;
        this.pisr = pisr;
        this.createContent();
    }

    private void createContent() {
        if (this.painel == null) {
            UIUtils.showNotification((String)"Painel esta nulo");
            return;
        }
        this.setWidth("600px");
        this.setHeight("600px");
        this.crud = new GridCrud(ProducaoLinhas.class);
        TextField filter = new TextField();
        filter.setPlaceholder("Filtrar por nome");
        filter.setClearButtonVisible(true);
        this.crud.getCrudLayout().addFilterComponent((Component)filter);
        this.crud.getGrid().setColumns(new String[0]);
        this.crud.getGrid().addColumn("nome").setFlexGrow(0).setWidth("350px");
        this.crud.getGrid().addColumn("posicaoLinha").setFlexGrow(0).setWidth("120px");
        this.crud.getCrudFormFactory().setUseBeanValidation(true);
        this.crud.getCrudFormFactory().setVisibleProperties(new String[]{"nome", "nomeBi", "posicaoLinha"});
        this.crud.getCrudFormFactory().setVisibleProperties(CrudOperation.ADD, new String[]{"nomeBi", "nome", "posicaoLinha"});
        this.crud.getAddButton().setVisible(this.hasPermission("PAINEL_PROUCAO_SAVE"));
        this.crud.getUpdateButton().setVisible(this.hasPermission("PAINEL_PROUCAO_SAVE"));
        this.crud.getDeleteButton().setVisible(this.hasPermission("PAINEL_PRODUCAO_DELETE"));
        this.crud.setCrudListener((CrudListener)new /* Unavailable Anonymous Inner Class!! */);
        filter.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> this.crud.refreshGrid());
        Button fechar = UIUtils.createSmallButton((String)"Fechar", (VaadinIcon)VaadinIcon.CLOSE);
        fechar.addClickListener((ComponentEventListener & Serializable)close -> this.close());
        this.add(new Component[]{UIUtils.createHeader((String)"Configura\u00e7\u00e3o de Linhas"), this.getOptions(), new VerticalContainer(new Component[]{this.crud, fechar})});
    }

    public HorizontalContainer getOptions() {
        Button btnProd = UIUtils.createSmallButton((String)"Produtos");
        btnProd.addClickListener((ComponentEventListener & Serializable)e -> {
            if (this.isValido()) {
                ProducaoProdutoView producaoProdutoView = new ProducaoProdutoView(this.getEu(), (ProducaoLinhas)this.crud.getGrid().getSelectedItems().iterator().next(), this.pps, this.ps);
                producaoProdutoView.open();
            }
        });
        Button btnSol = UIUtils.createSmallButton((String)"Solicitacao");
        btnSol.addClickListener((ComponentEventListener & Serializable)e -> {
            if (this.isValido()) {
                ProducaoSolicitacaoView producaoSolicitacaoView = new ProducaoSolicitacaoView(this.getEu(), (ProducaoLinhas)this.crud.getGrid().getSelectedItems().iterator().next(), this.pts, this.pisr);
                producaoSolicitacaoView.open();
            }
        });
        return new HorizontalContainer(new Component[]{btnProd, btnSol});
    }

    private boolean isValido() {
        if (this.crud.getGrid().getSelectedItems().size() <= 0) {
            UIUtils.showNotification((String)"Selecione uma linha");
            return false;
        }
        return true;
    }
}

