/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.producaopainel.views.cadastro;

import br.com.system.app.MainLayout;
import br.com.system.app.components.ConfirmationDialog;
import br.com.system.app.components.containers.FooterContainer;
import br.com.system.app.components.containers.HorizontalContainer;
import br.com.system.app.components.containers.VerticalContainer;
import br.com.system.app.features.estrutura.model.Estrutura;
import br.com.system.app.features.estrutura.service.EstruturaService;
import br.com.system.app.features.layout.UIUtils;
import br.com.system.app.features.layout.ViewFrame;
import br.com.system.app.features.pedido.repository.PedidoItemEtapaRepository;
import br.com.system.app.features.pedido.repository.PedidoItemSolicitacaoRepository;
import br.com.system.app.features.pedido.service.PedidoEtapaService;
import br.com.system.app.features.pedido.service.PedidoItemEtapaService;
import br.com.system.app.features.producaopainel.model.ProducaoPainel;
import br.com.system.app.features.producaopainel.repository.ProducaoPedidoItemEtapaRepository;
import br.com.system.app.features.producaopainel.repository.ProducaoTipoSolicitacaoRepository;
import br.com.system.app.features.producaopainel.service.ProducaoColunasService;
import br.com.system.app.features.producaopainel.service.ProducaoLinhasService;
import br.com.system.app.features.producaopainel.service.ProducaoPainelService;
import br.com.system.app.features.producaopainel.service.ProducaoPedidoEtapaService;
import br.com.system.app.features.producaopainel.service.ProducaoProdutosService;
import br.com.system.app.features.producaopainel.views.cadastro.ProducaoColunaView;
import br.com.system.app.features.producaopainel.views.cadastro.ProducaoLinhaView;
import br.com.system.app.features.produto.service.ProdutoService;
import br.com.system.app.security.SecurityContext;
import br.com.system.commons.datetime.FormatDate;
import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.ItemLabelGenerator;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.combobox.ComboBox;
import com.vaadin.flow.component.dialog.Dialog;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.textfield.TextField;
import com.vaadin.flow.data.renderer.ComponentRenderer;
import com.vaadin.flow.data.renderer.Renderer;
import com.vaadin.flow.data.renderer.TextRenderer;
import com.vaadin.flow.function.SerializableFunction;
import com.vaadin.flow.router.PageTitle;
import com.vaadin.flow.router.Route;
import jakarta.annotation.security.RolesAllowed;
import java.io.Serializable;
import java.util.Collection;
import org.vaadin.crudui.crud.CrudListener;
import org.vaadin.crudui.crud.CrudOperation;
import org.vaadin.crudui.crud.impl.GridCrud;

@Route(value="painel-producao/cadastro", layout=MainLayout.class)
@PageTitle(value="Cadastro de Painel de Produ\u00e7\u00e3o")
@RolesAllowed(value={"PAINEL_PRODUCAO_CADASTRO_VIEW"})
public class ProducaoPainelCadastroView
extends ViewFrame
implements SecurityContext {
    private static final long serialVersionUID = 1L;
    private final ProducaoPainelService pps;
    private final ProdutoService ps;
    private final EstruturaService es;
    private final ProducaoLinhasService pls;
    private final ProducaoColunasService pcs;
    private final ProducaoProdutosService pProdService;
    private final ProducaoTipoSolicitacaoRepository pts;
    private final PedidoEtapaService pes;
    private final ProducaoPedidoEtapaService ppes;
    private final ProducaoPedidoItemEtapaRepository ppier;
    private final PedidoItemSolicitacaoRepository pisr;
    private final PedidoItemEtapaRepository pier;
    private GridCrud<ProducaoPainel> crud;

    public ProducaoPainelCadastroView(ProducaoPainelService pps, ProdutoService ps, EstruturaService es, ProducaoLinhasService pls, ProducaoColunasService pcs, ProducaoProdutosService pProdService, ProducaoTipoSolicitacaoRepository pts, PedidoEtapaService pes, ProducaoPedidoEtapaService ppes, PedidoItemEtapaService pies, ProducaoPedidoItemEtapaRepository ppier, PedidoItemSolicitacaoRepository pisr, PedidoItemEtapaRepository pier) {
        this.pps = pps;
        this.ps = ps;
        this.es = es;
        this.pls = pls;
        this.pcs = pcs;
        this.pProdService = pProdService;
        this.pts = pts;
        this.pes = pes;
        this.ppes = ppes;
        this.ppier = ppier;
        this.pisr = pisr;
        this.pier = pier;
        this.createContent();
    }

    protected void onAttach(AttachEvent attachEvent) {
        super.onAttach(attachEvent);
        if (this.autenticado()) {
            this.setViewContent(this.createContent());
        } else {
            this.showNotification("Sem permiss\u00e3o");
        }
    }

    private Component createContent() {
        this.crud = new GridCrud(ProducaoPainel.class);
        TextField filter = new TextField();
        filter.setPlaceholder("Filtrar por nome");
        filter.setClearButtonVisible(true);
        Button btnDuplicar = UIUtils.createSmallButton((String)"Duplicar", (VaadinIcon)VaadinIcon.COPY);
        btnDuplicar.setVisible(this.isMaster());
        btnDuplicar.addClickListener((ComponentEventListener & Serializable)e -> {
            if (this.crud.getGrid().getSelectedItems().size() <= 0) {
                this.showNotification("Selecione um painel para duplicar");
                return;
            }
            Dialog d = new Dialog();
            ComboBox cbEstrutura = new ComboBox("Estrutura Destino", (Collection)this.es.getAtivas(this.getEstrutura().getEstruturaTipo()));
            cbEstrutura.setItemLabelGenerator(Estrutura::getNome);
            cbEstrutura.setWidth("300px");
            Button btnFechar = UIUtils.createSmallButton((String)"Fechar", (VaadinIcon)VaadinIcon.CLOSE);
            btnFechar.addClickListener((ComponentEventListener & Serializable)close -> d.close());
            Button btnConfirmar = UIUtils.createSmallButton((String)"Confirmar", (VaadinIcon)VaadinIcon.CHECK);
            btnConfirmar.addClickListener((ComponentEventListener & Serializable)conf -> this.duplicarPainel((ProducaoPainel)this.crud.getGrid().getSelectedItems().iterator().next(), (Estrutura)cbEstrutura.getValue()));
            d.add(new Component[]{new VerticalContainer(new Component[]{UIUtils.createHeader((String)"Selecione uma estrutura destino ou deixe em branco para duplicar nesta estrutura")}), cbEstrutura, new FooterContainer(new Component[]{btnFechar, btnConfirmar})});
            d.open();
        });
        Button btnExcluir = UIUtils.createSmallButton((String)"Excluir", (VaadinIcon)VaadinIcon.TRASH);
        btnExcluir.setVisible(this.isMaster());
        btnExcluir.addClickListener((ComponentEventListener & Serializable)e -> {
            if (this.crud.getGrid().getSelectedItems().size() <= 0) {
                this.showNotification("Selecione um painel para excluir");
                return;
            }
            this.excluirPainel((ProducaoPainel)this.crud.getGrid().getSelectedItems().iterator().next());
        });
        Button btnCopiar = UIUtils.createSmallButton((String)"Replicar", (VaadinIcon)VaadinIcon.ARROW_FORWARD);
        btnCopiar.setVisible(this.isMaster());
        btnCopiar.addClickListener((ComponentEventListener & Serializable)e -> {
            if (this.crud.getGrid().getSelectedItems().size() <= 0) {
                this.showNotification("Selecione um painel para duplicar");
                return;
            }
            this.copiar((ProducaoPainel)this.crud.getGrid().getSelectedItems().iterator().next());
        });
        HorizontalContainer ch = new HorizontalContainer(new Component[]{btnDuplicar, btnCopiar, btnExcluir});
        this.crud.getCrudLayout().addToolbarComponent((Component)ch);
        this.crud.getCrudLayout().addFilterComponent((Component)filter);
        this.crud.getAddButton().setText("Adicionar");
        this.crud.getGrid().setColumns(new String[0]);
        this.crud.getGrid().addColumn((Renderer)new ComponentRenderer((SerializableFunction & Serializable)eg -> this.getOptions(eg))).setFlexGrow(0).setWidth("120px");
        this.crud.getGrid().addColumn("id").setFlexGrow(0).setWidth("120px");
        this.crud.getGrid().addColumn("nome").setFlexGrow(0).setWidth("250px");
        this.crud.getGrid().addColumn((Renderer)new TextRenderer((ItemLabelGenerator & Serializable)p -> p.getPadrao() != false ? "Padrao" : "")).setFlexGrow(0).setWidth("100px").setHeader("Padr\u00e3o");
        this.crud.getGrid().addColumn((Renderer)new TextRenderer((ItemLabelGenerator & Serializable)p -> p.getUsuarioCriacao().getNome())).setFlexGrow(0).setWidth("250px").setHeader("Usu\u00e1rio Cria\u00e7\u00e3o");
        this.crud.getGrid().addColumn((Renderer)new TextRenderer((ItemLabelGenerator & Serializable)p -> p.getDataHoraCriacao().format(FormatDate.DATETIME_BR.toDTF()))).setFlexGrow(0).setWidth("180px").setHeader("Cria\u00e7\u00e3o");
        this.crud.getCrudFormFactory().setUseBeanValidation(true);
        this.crud.getCrudFormFactory().setVisibleProperties(CrudOperation.READ, new String[]{"id", "nome", "padrao"});
        this.crud.getCrudFormFactory().setVisibleProperties(CrudOperation.ADD, new String[]{"nome", "padrao"});
        this.crud.getCrudFormFactory().setVisibleProperties(CrudOperation.UPDATE, new String[]{"nome", "padrao"});
        this.crud.getAddButton().setVisible(this.hasPermission("PAINEL_PROUCAO_SAVE"));
        this.crud.getUpdateButton().setVisible(this.hasPermission("PAINEL_PROUCAO_SAVE"));
        this.crud.getDeleteButton().setVisible(this.hasPermission("PAINEL_PRODUCAO_DELETE"));
        this.crud.setCrudListener((CrudListener)new /* Unavailable Anonymous Inner Class!! */);
        filter.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> this.crud.refreshGrid());
        return this.crud;
    }

    public HorizontalContainer getOptions(ProducaoPainel pp) {
        Button btnLinha = UIUtils.createSmallButton((VaadinIcon)VaadinIcon.GRID_V, (String)"Editar linhas (produtos)");
        btnLinha.addClickListener((ComponentEventListener & Serializable)e -> {
            ProducaoLinhaView producaoPainelLinhaView = new ProducaoLinhaView(this.pls, this.pProdService, this.pts, this.ps, pp, this.pisr);
            producaoPainelLinhaView.open();
        });
        Button btnColuna = UIUtils.createSmallButton((VaadinIcon)VaadinIcon.GRID_H, (String)"Editar colunas(etapas)");
        btnColuna.addClickListener((ComponentEventListener & Serializable)e -> {
            ProducaoColunaView producaoColunaView = new ProducaoColunaView(this.pcs, this.pes, this.ppes, this.ppier, this.pier, pp);
            producaoColunaView.open();
        });
        return new HorizontalContainer(new Component[]{btnLinha, btnColuna});
    }

    private void duplicarPainel(ProducaoPainel pp, Estrutura estrutura) {
        ConfirmationDialog cd = new ConfirmationDialog("Duplicar painel", "Confirma duplica\u00e7\u00e3o deste painel?");
        cd.getCancel().addClickListener((ComponentEventListener & Serializable)e -> cd.close());
        cd.getConfirm().addClickListener((ComponentEventListener & Serializable)e -> {
            if (estrutura == null) {
                this.pps.duplicarPainel(pp, this.getEu(), true, true);
            } else {
                this.pps.duplicarPainel(pp, this.getEu(), false, true, estrutura);
            }
            this.showNotification("Iniciado, ao final voc\u00ea ser\u00e1 notificado");
            cd.close();
        });
    }

    private void excluirPainel(ProducaoPainel pp) {
        ConfirmationDialog cd = new ConfirmationDialog("Excluir painel", "Confirma exclus\u00e3o do painel " + pp.getNome() + " de todos os parceiros?");
        cd.getCancel().addClickListener((ComponentEventListener & Serializable)e -> cd.close());
        cd.getConfirm().addClickListener((ComponentEventListener & Serializable)e -> {
            this.pps.excluirPainel(pp, this.getEu());
            this.crud.refreshGrid();
            cd.close();
        });
    }

    private void copiar(ProducaoPainel pp) {
        Dialog dialog = new Dialog();
        VerticalContainer cv = new VerticalContainer(new Component[0]);
        cv.add(new Component[]{UIUtils.createHeader((String)"Replicar Painel")});
        cv.add(new Component[]{UIUtils.createSmallSpan((String)("Aten\u00e7\u00e3o! Voc\u00ea est\u00e1 prestes a replicar esse painel para todas as estruturas " + this.getEstrutura().getEstruturaTipo().getNome() + " Voc\u00ea deseja?"))});
        Button btnClose = UIUtils.createSmallButton((String)"Fechar");
        btnClose.addClickListener((ComponentEventListener & Serializable)e -> dialog.close());
        Button btnReplicar = UIUtils.createSmallButton((String)"Apenas Replicar");
        btnReplicar.addClickListener((ComponentEventListener & Serializable)e -> {
            this.pps.duplicarPainel(pp, this.getEu(), false, false);
            UIUtils.showProcessNotification();
        });
        Button btnSobrepor = UIUtils.createSmallButton((String)"Replicar e Sobrepor");
        btnSobrepor.setEnabled(false);
        btnSobrepor.addClickListener((ComponentEventListener & Serializable)e -> {
            this.pps.duplicarPainel(pp, this.getEu(), false, true);
            UIUtils.showProcessNotification();
        });
        dialog.add(new Component[]{cv, new FooterContainer(new Component[]{btnClose, btnSobrepor, btnReplicar})});
        dialog.open();
    }
}

