/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.produto;

import br.com.system.app.MainLayout;
import br.com.system.app.components.DownloadDialog;
import br.com.system.app.components.containers.HorizontalContainer;
import br.com.system.app.features.layout.UIUtils;
import br.com.system.app.features.layout.ViewFrame;
import br.com.system.app.features.produto.dto.ProdutoDTO;
import br.com.system.app.features.produto.model.Produto;
import br.com.system.app.features.produto.model.ProdutoCategoria;
import br.com.system.app.features.produto.model.ProdutoOrigem;
import br.com.system.app.features.produto.repository.ProdutoRepository;
import br.com.system.app.features.produto.service.ProdutoCategoriaService;
import br.com.system.app.features.produto.service.ProdutoService;
import br.com.system.app.features.storage.StorageUtil;
import br.com.system.app.security.SecurityContext;
import br.com.system.commons.CurrencyUtil;
import br.com.system.commons.HashUtil;
import br.com.system.commons.InputStreamUtil;
import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.DetachEvent;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.ItemLabelGenerator;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.combobox.ComboBox;
import com.vaadin.flow.component.radiobutton.RadioButtonGroup;
import com.vaadin.flow.component.textfield.TextField;
import com.vaadin.flow.data.provider.ListDataProvider;
import com.vaadin.flow.data.renderer.ComponentRenderer;
import com.vaadin.flow.data.renderer.Renderer;
import com.vaadin.flow.data.renderer.TextRenderer;
import com.vaadin.flow.function.SerializableFunction;
import com.vaadin.flow.router.PageTitle;
import com.vaadin.flow.router.Route;
import jakarta.annotation.security.RolesAllowed;
import java.io.InputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.http.entity.ContentType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.vaadin.crudui.crud.CrudListener;
import org.vaadin.crudui.crud.impl.GridCrud;
import org.vaadin.crudui.form.FieldProvider;

@Route(value="produtos", layout=MainLayout.class)
@PageTitle(value="Produtos")
@RolesAllowed(value={"MASTER"})
public class ProdutoView
extends ViewFrame
implements SecurityContext {
    private static final long serialVersionUID = 1L;
    private final ProdutoRepository pr;
    private final ProdutoService produtoService;
    private final ProdutoCategoriaService pcs;
    private final GridCrud<Produto> crud = new GridCrud(Produto.class);
    private final ComboBox<ProdutoCategoria> cbCategoriaFilter = new ComboBox("Categoria");
    private final RadioButtonGroup<String> rbAtivo = new RadioButtonGroup();
    private final TextField filter = new TextField();
    private final Button btnExportacao = UIUtils.createExportButton((String)"Exportar");
    private final ComboBox<ProdutoCategoria> cbCategoria = new ComboBox("categoria");
    private final DownloadDialog dd = new DownloadDialog();

    @Autowired
    public ProdutoView(ProdutoRepository pr, ProdutoCategoriaService pcs, ProdutoService produtoService) {
        this.pr = pr;
        this.produtoService = produtoService;
        this.pcs = pcs;
    }

    protected void onAttach(AttachEvent attachEvent) {
        super.onAttach(attachEvent);
        if (this.autenticado() && this.isMaster()) {
            this.setViewContent(this.createContent());
        } else {
            this.showNotification("Sem permiss\u00e3o");
        }
    }

    protected void onDetach(DetachEvent detachEvent) {
        super.onDetach(detachEvent);
    }

    private Component createContent() {
        this.cbCategoriaFilter.setItems((Collection)this.pcs.getByEstrutura(this.getEstrutura()));
        this.cbCategoriaFilter.setItemLabelGenerator(ProdutoCategoria::getNome);
        this.cbCategoriaFilter.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> this.crud.refreshGrid());
        this.rbAtivo.setItems((Object[])new String[]{"Ativo", "Inativo"});
        this.rbAtivo.setValue((Object)"Ativo");
        this.rbAtivo.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> this.crud.refreshGrid());
        this.btnExportacao.addClickListener((ComponentEventListener & Serializable)e -> this.exportar());
        this.filter.setPlaceholder("Filtrar por nome");
        this.filter.setClearButtonVisible(true);
        this.crud.getCrudLayout().addToolbarComponent((Component)new HorizontalContainer(new Component[]{this.filter, this.cbCategoriaFilter, this.rbAtivo, this.btnExportacao}));
        this.crud.getAddButton().setText("Adicionar");
        this.crud.getGrid().setColumns(new String[0]);
        this.crud.getGrid().addColumn((Renderer)new ComponentRenderer((SerializableFunction & Serializable)p -> UIUtils.createBreakWrapSpan((String)p.getNome()))).setHeader("Nome").setFlexGrow(0).setWidth("250px");
        this.crud.getGrid().addColumn((Renderer)new TextRenderer((ItemLabelGenerator & Serializable)p -> p.getAtivo() != false ? "SIM" : "N\u00c3O")).setHeader("ATIVO");
        this.crud.getGrid().addColumns(new String[]{"origem", "descricao", "valor", "descontoPrateleira", "valorAdicional"});
        this.crud.getGrid().addColumn((Renderer)new TextRenderer((ItemLabelGenerator & Serializable)p -> p.getEstruturaTipo().getNome())).setHeader("EstruturaTipo");
        this.crud.getGrid().addColumn((Renderer)new TextRenderer((ItemLabelGenerator & Serializable)p -> p.getCategoria().getNome())).setHeader("Categoria");
        this.crud.getGrid().addColumn((Renderer)new TextRenderer((ItemLabelGenerator & Serializable)p -> p.getSomaQuantidade() != false ? "Sim" : "N\u00e3o")).setHeader("Soma QTDE");
        this.crud.getGrid().addColumn((Renderer)new TextRenderer((ItemLabelGenerator & Serializable)p -> p.getCompromissoMensal() != null && p.getCompromissoMensal() != false ? "Sim" : "N\u00e3o")).setHeader("Comp Mensal");
        this.crud.getGrid().setColumnReorderingAllowed(true);
        this.crud.getCrudFormFactory().setUseBeanValidation(true);
        this.crud.getCrudFormFactory().setVisibleProperties(new String[]{"nome", "origem", "descricao", "valor", "descontoPrateleira", "valorAdicional", "categoria", "somaQuantidade", "quantosMegas", "apareceProposta", "compromissoMensal", "ativo"});
        this.crud.getCrudFormFactory().setFieldProvider("origem", (FieldProvider & Serializable)() -> {
            ComboBox checkboxes = new ComboBox();
            checkboxes.setItems(Arrays.asList(ProdutoOrigem.values()));
            checkboxes.setItemLabelGenerator(Enum::name);
            return checkboxes;
        });
        this.cbCategoria.setItems(new ListDataProvider((Collection)this.pcs.getByEstrutura(this.getEstrutura())));
        this.cbCategoria.setItemLabelGenerator(ProdutoCategoria::getNome);
        this.crud.getCrudFormFactory().setFieldProvider("categoria", (FieldProvider & Serializable)() -> this.cbCategoria);
        this.crud.getAddButton().setVisible(this.hasPermission("PRODUTO_SAVE"));
        this.crud.getUpdateButton().setVisible(this.hasPermission("PRODUTO_SAVE"));
        this.crud.getDeleteButton().setVisible(this.hasPermission("PRODUTO_DELETE"));
        this.crud.setCrudListener((CrudListener)new /* Unavailable Anonymous Inner Class!! */);
        this.filter.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> this.crud.refreshGrid());
        return this.crud;
    }

    private void exportar() {
        List produtos = this.produtoService.buscarProdutos(this.getEstrutura().getEstruturaTipo(), this.filter.getValue(), (ProdutoCategoria)this.cbCategoriaFilter.getValue(), Boolean.valueOf(((String)this.rbAtivo.getValue()).equals("Ativo")), null);
        try {
            InputStream isModelo = StorageUtil.getObjectModelo((String)"ExportacaoProdutos.xlsx");
            XSSFWorkbook appXls = new XSSFWorkbook(isModelo);
            Sheet aba = appXls.getSheet("Exportacao");
            int ind = 1;
            for (ProdutoDTO p : produtos) {
                Row row = aba.createRow(ind);
                row.createCell(0).setCellValue(p.getEstruturaTipo());
                row.createCell(1).setCellValue(p.getAtivo() != false ? "Ativo" : "Inativo");
                row.createCell(2).setCellValue(p.getNome());
                row.createCell(3).setCellValue(p.getCategoria());
                row.createCell(4).setCellValue(CurrencyUtil.toCurrency((BigDecimal)p.getValor()));
                row.createCell(5).setCellValue(CurrencyUtil.toCurrency((BigDecimal)p.getDescontoPrateleira()));
                row.createCell(6).setCellValue(p.getSomaQuantidade().booleanValue());
                row.createCell(7).setCellValue(p.getCompromissoMensal().booleanValue());
                row.createCell(8).setCellValue(p.getOrigem());
                ++ind;
            }
            String nomeArquivo = HashUtil.getUUI() + ".xlsx";
            InputStream isOutput = InputStreamUtil.workbookToInputStream((Workbook)appXls);
            String hash = StorageUtil.uploadObjectInputStream((String)nomeArquivo, (String)ContentType.MULTIPART_FORM_DATA.toString(), (InputStream)isOutput);
            this.dd.open(hash, "ExportacaoProdutos.xlsx", true);
        }
        catch (Exception e) {
            UIUtils.showError((String)e.getMessage());
        }
    }
}

