/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.schedule;

import br.com.system.app.MainLayout;
import br.com.system.app.components.DownloadDialog;
import br.com.system.app.components.containers.FooterContainer;
import br.com.system.app.components.containers.HorizontalContainer;
import br.com.system.app.components.containers.VerticalContainer;
import br.com.system.app.features.estrutura.repository.projection.HierarquiaDTO;
import br.com.system.app.features.layout.UIUtils;
import br.com.system.app.features.layout.ViewFrame;
import br.com.system.app.features.pedido.dto.PedidoNotificacaoDTO;
import br.com.system.app.features.pedido.dto.PedidoTipoEnum;
import br.com.system.app.features.pedido.model.Pedido;
import br.com.system.app.features.pedido.service.PedidoNotificacaoService;
import br.com.system.app.features.pedido.service.PedidoService;
import br.com.system.app.features.pedido.view.atividade.AtividadeView;
import br.com.system.app.features.shared.exception.BusinessException;
import br.com.system.app.features.storage.StorageUtil;
import br.com.system.app.features.usuario.service.UsuarioHierarquiaService;
import br.com.system.app.security.SecurityContext;
import br.com.system.commons.HashUtil;
import br.com.system.commons.InputStreamUtil;
import br.com.system.commons.datetime.FormatDate;
import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.combobox.ComboBox;
import com.vaadin.flow.component.datepicker.DatePicker;
import com.vaadin.flow.component.dialog.Dialog;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.router.PageTitle;
import com.vaadin.flow.router.Route;
import jakarta.annotation.security.RolesAllowed;
import java.io.InputStream;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.TextStyle;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.http.entity.ContentType;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.vaadin.stefan.fullcalendar.Entry;
import org.vaadin.stefan.fullcalendar.FullCalendar;
import org.vaadin.stefan.fullcalendar.FullCalendarBuilder;

@Route(value="schedule", layout=MainLayout.class)
@PageTitle(value="Agenda")
@RolesAllowed(value={"AGENDA_VIEW"})
public class ScheduleView
extends ViewFrame
implements SecurityContext {
    private static final long serialVersionUID = 1L;
    private final PedidoService pedidoService;
    private final AtividadeView atividadeView;
    private final UsuarioHierarquiaService hierarquiaService;
    private final PedidoNotificacaoService pedidoNotificacaoService;
    private DownloadDialog dd;
    private FullCalendar calendar;
    private ComboBox<HierarquiaDTO> cbHierarquia;
    private List<HierarquiaDTO> hierarquia;
    private DatePicker gotoDate;

    @Autowired
    public ScheduleView(PedidoService pedidoService, AtividadeView atividadeView, UsuarioHierarquiaService hierarquiaService, PedidoNotificacaoService pedidoNotificacaoService) {
        this.hierarquiaService = hierarquiaService;
        this.pedidoNotificacaoService = pedidoNotificacaoService;
        this.atividadeView = atividadeView;
        this.pedidoService = pedidoService;
    }

    protected void onAttach(AttachEvent attachEvent) {
        super.onAttach(attachEvent);
        if (this.autenticado()) {
            this.setViewContent(this.createContent());
        } else {
            this.showNotification("Sem permiss\u00e3o");
        }
    }

    private Component createContent() {
        this.dd = new DownloadDialog();
        this.atividadeView.addOpenedChangeListener((ComponentEventListener & Serializable)s -> this.povoaCalendario());
        this.hierarquia = this.hierarquiaService.getHierarquiaDto(this.getEu());
        VerticalContainer main = new VerticalContainer(new Component[0]);
        main.setId("main");
        main.setHeightFull();
        main.setWidthFull();
        Button btnExportacao = UIUtils.createSmallButton((String)"Exportar", (VaadinIcon)VaadinIcon.TABLE, (String)"Exportar agenda do M\u00eas selecionado");
        btnExportacao.addClickListener((ComponentEventListener & Serializable)e -> this.exportar());
        this.gotoDate = new DatePicker();
        this.calendar = FullCalendarBuilder.create().build();
        this.calendar.setWidth("100%");
        this.calendar.setHeight("100%");
        this.calendar.setWeekends(true);
        this.calendar.setLocale(UIUtils.getLocale());
        this.calendar.addEntryClickedListener((ComponentEventListener & Serializable)e -> {
            Dialog d = new Dialog();
            Button btnFechar = UIUtils.createSmallButton((String)"Fechar");
            btnFechar.addClickListener((ComponentEventListener & Serializable)ex -> d.close());
            Button btnOpen = UIUtils.createSmallButton((String)"Abrir Atividade");
            btnOpen.addClickListener((ComponentEventListener & Serializable)ex -> {
                Long id = null;
                for (Map.Entry entry : e.getEntry().getCustomProperties().entrySet()) {
                    if (!((String)entry.getKey()).equals("pedidoId")) continue;
                    id = Long.valueOf(entry.getValue().toString());
                }
                if (id != null) {
                    Pedido ped = this.pedidoService.getById(id);
                    this.abrePedido(ped);
                    d.close();
                } else {
                    this.showNotification("Erro ao abrir a atividade");
                }
            });
            Div div = new Div();
            div.getElement().setProperty("innerHTML", "<span>" + e.getEntry().getDescription() + "</span>");
            d.add(new Component[]{UIUtils.createHeader((String)e.getEntry().getTitle())});
            d.add(new Component[]{div});
            d.add(new Component[]{new FooterContainer(new Component[]{btnFechar, btnOpen})});
            d.open();
        });
        this.calendar.setWeekNumbersVisible(false);
        Button buttonToday = new Button("Hoje", (Component)VaadinIcon.HOME.create(), (ComponentEventListener & Serializable)e -> {
            this.calendar.today();
            this.gotoDate.setValue(LocalDate.now());
            this.povoaCalendario();
        });
        Button buttonCreateTask = UIUtils.createSmallButton((VaadinIcon)VaadinIcon.TASKS, (String)"Criar Atividade");
        buttonCreateTask.addClickListener((ComponentEventListener & Serializable)e -> this.abrePedido(null));
        Button buttonPrevious = new Button("", (Component)VaadinIcon.ANGLE_LEFT.create(), (ComponentEventListener & Serializable)e -> {
            this.calendar.previous();
            this.gotoDate.setValue(((LocalDate)this.gotoDate.getValue()).minusMonths(1L));
        });
        Button buttonNext = new Button("", (Component)VaadinIcon.ANGLE_RIGHT.create(), (ComponentEventListener & Serializable)e -> {
            this.calendar.next();
            this.gotoDate.setValue(((LocalDate)this.gotoDate.getValue()).plusMonths(1L));
        });
        Button buttonDatePicker = UIUtils.createSmallButton((VaadinIcon)VaadinIcon.CALENDAR, (String)"Ir para data");
        buttonNext.setIconAfterText(true);
        this.gotoDate.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event1 -> {
            this.calendar.gotoDate((LocalDate)event1.getValue());
            buttonDatePicker.setText(((LocalDate)this.gotoDate.getValue()).getMonth().getDisplayName(TextStyle.FULL, UIUtils.getLocale()));
        });
        this.gotoDate.setLocale(UIUtils.getLocale());
        this.gotoDate.getElement().getStyle().set("visibility", "hidden");
        this.gotoDate.getElement().getStyle().set("position", "fixed");
        this.gotoDate.setWidth("0px");
        this.gotoDate.setHeight("0px");
        this.gotoDate.setWeekNumbersVisible(true);
        this.gotoDate.setValue(LocalDate.now());
        buttonDatePicker.getElement().appendChild(new Element[]{this.gotoDate.getElement()});
        buttonDatePicker.addClickListener((ComponentEventListener & Serializable)event -> this.gotoDate.open());
        this.cbHierarquia = new ComboBox("Hierarquia", (Collection)this.hierarquia);
        this.cbHierarquia.setItemLabelGenerator(HierarquiaDTO::getLoginAndEquipeName);
        this.cbHierarquia.setWidth("300px");
        this.cbHierarquia.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> this.povoaCalendario());
        this.cbHierarquia.setValue((Object)new HierarquiaDTO(this.getEu()));
        HorizontalContainer cabecalho = new HorizontalContainer(new Component[]{buttonToday, buttonPrevious, buttonDatePicker, buttonNext, buttonCreateTask, this.cbHierarquia, this.gotoDate, btnExportacao});
        cabecalho.setId("cabecalho");
        main.add(new Component[]{cabecalho});
        main.add(new Component[]{this.calendar});
        return main;
    }

    private void povoaCalendario() {
        if (this.cbHierarquia.getValue() == null) {
            this.cbHierarquia.setValue((Object)new HierarquiaDTO(this.getEu()));
        }
        this.calendar.getEntries().clear();
        List lpn = this.pedidoNotificacaoService.getNotificacaoByEstruturaUsuarioId(((HierarquiaDTO)this.cbHierarquia.getValue()).getEstruturaUsuarioId(), false);
        lpn.addAll(this.pedidoNotificacaoService.getNotificacaoByEstruturaUsuarioId(((HierarquiaDTO)this.cbHierarquia.getValue()).getEstruturaUsuarioId(), true));
        for (PedidoNotificacaoDTO pn : lpn) {
            String description = "<BR>Data/Hora: <B>" + pn.getDataNotificacao().format(FormatDate.DATE_BR.toDTF()) + " " + String.valueOf(pn.getHoraNotificacao()) + "</B><BR>Notifica\u00e7\u00e3o da Atividade <B>#" + pn.getNumeroAtividade() + "</B><BR>Cliente: <B>" + pn.getCpfCnpjCliente() + " - " + pn.getNomeCliente() + "</B><BR>Observa\u00e7\u00e3o: " + (pn.getObservacao() == null ? "" : pn.getObservacao()) + "<BR>Complementos: <B>" + pn.getInformacoes() + "</B>";
            Entry entry = new Entry();
            entry.setCustomProperty("pedidoId", (Object)pn.getPedidoId());
            entry.setTitle("Atividade #" + pn.getNumeroAtividade() + " " + pn.getNomeCliente());
            entry.setDescription(description);
            entry.setStartWithOffset(pn.getDataNotificacao().atTime(pn.getHoraNotificacao()), this.calendar.getTimezone());
            entry.setEndWithOffset(pn.getDataNotificacao().atTime(pn.getHoraNotificacao()).plusHours(1L), this.calendar.getTimezone());
            entry.setColor("#ff3333");
            this.calendar.addEntries(new Entry[]{entry});
        }
    }

    private void abrePedido(Pedido pedido) {
        this.atividadeView.create(pedido, this.getEu(), pedido == null ? PedidoTipoEnum.COMERCIAL : pedido.getPedidoTipo());
    }

    public void exportar() {
        InputStream is = null;
        XSSFWorkbook xls = null;
        try {
            is = StorageUtil.getObjectModelo((String)"ExportacaoAgenda-v1.xlsx");
            xls = new XSSFWorkbook(is);
            Sheet aba = xls.getSheet("Exportacao");
            CellStyle styleCellDouble = xls.createCellStyle();
            styleCellDouble.setDataFormat((short)2);
            int linha = 1;
            List lpn = this.pedidoNotificacaoService.getNotificacaoForExportation(this.hierarquiaService.getHierarquia(this.getEu()), ((LocalDate)this.gotoDate.getValue()).withDayOfMonth(1), ((LocalDate)this.gotoDate.getValue()).withDayOfMonth(((LocalDate)this.gotoDate.getValue()).lengthOfMonth()));
            for (PedidoNotificacaoDTO pn : lpn) {
                Row row = aba.createRow(linha);
                row.createCell(0).setCellValue(pn.getNumeroAtividade());
                row.createCell(1).setCellValue(pn.getNomeUsuario());
                row.createCell(2).setCellValue(pn.getDataNotificacao().format(FormatDate.DATE_BR.toDTF()));
                row.createCell(3).setCellValue(pn.getHoraNotificacao().format(DateTimeFormatter.ISO_TIME));
                row.createCell(4).setCellValue(pn.getCpfCnpjCliente());
                row.createCell(5).setCellValue(pn.getNomeCliente());
                row.createCell(6).setCellValue(pn.getInformacoes());
                row.createCell(7).setCellValue(pn.getObservacao());
                ++linha;
                row = null;
            }
            lpn = null;
            String nomeArquivo = HashUtil.getUUI() + ".xlsx";
            InputStream isOutput = InputStreamUtil.workbookToInputStream((Workbook)xls);
            String url = StorageUtil.uploadObjectInputStream((String)nomeArquivo, (String)ContentType.MULTIPART_FORM_DATA.toString(), (InputStream)isOutput);
            this.dd.open(url, "Exportacao-agenda.xlsx", true);
            aba = null;
        }
        catch (Exception e) {
            throw new BusinessException(e.getMessage());
        }
        finally {
            try {
                xls.close();
                is.close();
                xls = null;
                is = null;
            }
            catch (Exception exception) {}
        }
    }
}

