/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.serasa;

import br.com.system.app.components.containers.HorizontalContainer;
import br.com.system.app.components.containers.VerticalContainer;
import br.com.system.app.features.layout.UIUtils;
import br.com.system.app.features.serasa.dto.SerasaChequeDTO;
import br.com.system.app.features.serasa.dto.SerasaPendenciaDTO;
import br.com.system.app.features.serasa.dto.SerasaProtestoDTO;
import br.com.system.app.features.serasa.model.Serasa;
import br.com.system.app.features.serasa.service.SerasaHandler;
import br.com.system.commons.datetime.FormatDate;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.dialog.Dialog;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.data.renderer.ComponentRenderer;
import com.vaadin.flow.data.renderer.Renderer;
import com.vaadin.flow.function.SerializableFunction;
import java.io.Serializable;
import java.util.Collection;
import java.util.Set;

public class SerasaPendenciaView
extends Dialog {
    private static final long serialVersionUID = 1L;
    private final Serasa serasa;
    private final Button btnClose;
    private final SerasaHandler serasaHandler;

    public SerasaPendenciaView(Serasa serasa) {
        this.serasa = serasa;
        this.btnClose = UIUtils.createSmallButton((String)"Fechar");
        this.serasaHandler = new SerasaHandler(serasa);
    }

    public Button getCloseButton() {
        return this.btnClose;
    }

    public void create() {
        this.setWidth("800px");
        VerticalContainer v = new VerticalContainer(new Component[0]);
        v.add(new Component[]{UIUtils.createHeader((String)"Informa\u00e7\u00f5es da Consulta")});
        Span span = new Span();
        span.setText("Cliente " + this.serasa.getCliente().getCpfCnpj() + " " + this.serasa.getCliente().getNome() + " consultado em " + this.serasa.getDataHora().format(FormatDate.DATETIME_BR.toDTF()));
        v.add(new Component[]{new HorizontalContainer(new Component[]{span, this.btnClose})});
        v.add(new Component[]{UIUtils.createHeader((String)"Pend\u00eancias Financeiras")});
        v.add(new Component[]{this.gridPendencia()});
        v.add(new Component[]{UIUtils.createHeader((String)"Protestos")});
        v.add(new Component[]{this.gridProtesto()});
        v.add(new Component[]{UIUtils.createHeader((String)"Cheque Sem Fundos")});
        v.add(new Component[]{this.gridCheque()});
        this.add(new Component[]{v});
        this.open();
    }

    private Grid<SerasaChequeDTO> gridCheque() {
        Grid grid = new Grid(SerasaChequeDTO.class);
        grid.setWidthFull();
        grid.setColumns(new String[0]);
        grid.addColumn((Renderer)new ComponentRenderer((SerializableFunction & Serializable)p -> UIUtils.createBreakWrapSpan((String)p.getBanco()))).setHeader("Banco").setFlexGrow(0).setWidth("300px");
        grid.addColumn("agencia").setFlexGrow(0).setWidth("120px");
        grid.addColumn("quantidade").setFlexGrow(0).setWidth("120px");
        grid.addColumn("data").setFlexGrow(0).setWidth("130px");
        grid.addColumn("motivo").setFlexGrow(0).setWidth("150px");
        grid.setItems((Collection)this.serasaHandler.getCheques());
        return grid;
    }

    private Grid<SerasaProtestoDTO> gridProtesto() {
        Grid grid = new Grid(SerasaProtestoDTO.class);
        grid.setWidthFull();
        grid.setColumns(new String[0]);
        grid.addColumn("cartorio").setFlexGrow(0).setWidth("300px");
        grid.addColumn("dataProtesto").setFlexGrow(0).setWidth("200px");
        grid.addColumn("valor").setFlexGrow(0).setWidth("200px");
        grid.setItems((Collection)this.serasaHandler.getProtestos());
        return grid;
    }

    private Grid<SerasaPendenciaDTO> gridPendencia() {
        Set dp = this.serasaHandler.getPendencias();
        dp.addAll(this.serasaHandler.getSpc());
        Grid grid = new Grid(SerasaPendenciaDTO.class);
        grid.setWidthFull();
        grid.setColumns(new String[0]);
        grid.addColumn("contrato").setFlexGrow(0).setWidth("200px");
        grid.addColumn("dataOcorrencia").setFlexGrow(0).setWidth("130px").setHeader("Data");
        grid.addColumn((Renderer)new ComponentRenderer((SerializableFunction & Serializable)p -> UIUtils.createBreakWrapSpan((String)p.getOrigem()))).setHeader("Origem").setFlexGrow(0).setWidth("170px");
        grid.addColumn((Renderer)new ComponentRenderer((SerializableFunction & Serializable)p -> UIUtils.createBreakWrapSpan((String)p.getTitulo()))).setHeader("Titulo").setFlexGrow(0).setWidth("120px");
        grid.addColumn("valor").setFlexGrow(0).setWidth("150px");
        grid.setItems((Collection)dp);
        return grid;
    }
}

