/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.serasa.service;

import br.com.system.app.features.cliente.model.Cliente;
import br.com.system.app.features.configurations.model.ConfigurationEnum;
import br.com.system.app.features.configurations.service.ConfigurationsService;
import br.com.system.app.features.creditos.service.CreditosService;
import br.com.system.app.features.estrutura.model.Estrutura;
import br.com.system.app.features.estrutura.model.EstruturaUsuario;
import br.com.system.app.features.serasa.model.Serasa;
import br.com.system.app.features.serasa.model.SerasaLog;
import br.com.system.app.features.serasa.repository.SerasaRepository;
import br.com.system.app.features.serasa.service.SerasaClienteService;
import br.com.system.app.features.serasa.service.SerasaSoupService;
import br.com.system.app.features.shared.exception.BusinessException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONObject;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SerasaService
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Autowired
    private SerasaRepository serasaRepository;
    @Autowired
    private SerasaSoupService serasaSoupService;
    @Autowired
    private ConfigurationsService configurationsService;
    @Autowired
    private CreditosService creditosService;
    @Autowired
    private SerasaClienteService serasaClienteService;

    public List<Serasa> getByEstruturaUsuario(EstruturaUsuario euContext, String cpfCnpj, Pageable pageable) {
        if (cpfCnpj == null || cpfCnpj.isBlank()) {
            return this.serasaRepository.findByEstruturaUsuarioOrderByDataHoraDesc(euContext, pageable);
        }
        return this.serasaRepository.findByEstruturaUsuarioAndClienteCpfCnpjOrderByDataHoraDesc(euContext, cpfCnpj, pageable);
    }

    public long countByEstruturaUsuario(EstruturaUsuario eu, String cpfCnpj) {
        if (cpfCnpj == null || cpfCnpj.isBlank()) {
            return this.serasaRepository.countByEstruturaUsuario(eu);
        }
        return this.serasaRepository.countByEstruturaUsuarioAndClienteCpfCnpj(eu, cpfCnpj);
    }

    public Serasa getByEstruturaUsuarioAndCliente(EstruturaUsuario eu, Cliente cliente) {
        return this.serasaRepository.findByEstruturaUsuarioAndCliente(eu, cliente);
    }

    public Serasa executaConsulta(String cpfCnpj, Boolean comProtesto, EstruturaUsuario euContext) {
        try {
            Cliente cliente = this.serasaClienteService.getCliente(euContext, cpfCnpj);
            BigDecimal valorConsulta = comProtesto != false ? BigDecimal.valueOf(this.configurationsService.get(ConfigurationEnum.VALOR_SERASA_COM_PROTESTO).getDoubleValue()) : BigDecimal.valueOf(this.configurationsService.get(ConfigurationEnum.VALOR_SERASA_SEM_PROTESTO).getDoubleValue());
            if (!this.creditosService.temCredito(euContext, valorConsulta)) {
                throw new BusinessException("SEM_CREDITO");
            }
            Serasa serasa = this.getSerasa(euContext, cliente);
            JSONObject jsonResult = this.serasaSoupService.execute(cpfCnpj, comProtesto.booleanValue()).getJSONObject("ns2:resultado");
            this.setDados(serasa, jsonResult.toString());
            this.setLog(serasa, valorConsulta, euContext);
            serasa = this.persistir(serasa);
            this.creditosService.transacionar(euContext, "Consulta de cr\u00e9dito " + (comProtesto != false ? "Com Protesto " : "Sem protesto ") + cpfCnpj, valorConsulta.negate());
            return serasa;
        }
        catch (Exception e) {
            if (e.getMessage().contains("SEM_CREDITO")) {
                throw new BusinessException(e.getMessage());
            }
            throw new BusinessException("Erro, esta consulta n\u00e3o foi cobrada ( " + e.getMessage() + " )");
        }
    }

    public Serasa getSerasa(EstruturaUsuario estruturaUsuario, Cliente cliente) {
        Serasa serasa = this.serasaRepository.findByEstruturaUsuarioAndCliente(estruturaUsuario, cliente);
        if (serasa == null) {
            serasa = new Serasa();
        }
        serasa.setCliente(cliente);
        serasa.setEstruturaUsuario(estruturaUsuario);
        serasa.setDataHora(LocalDateTime.now());
        return serasa;
    }

    private void setDados(Serasa serasa, String jsonResult) {
        Boolean restricao = new JSONObject(jsonResult).getBoolean("restricao");
        serasa.setTemRestricao(restricao.booleanValue());
        serasa.setJsonResult(jsonResult);
    }

    private void setLog(Serasa serasa, BigDecimal valorCobrado, EstruturaUsuario euContext) {
        ArrayList<SerasaLog> lista = serasa.getSerasaLog();
        if (lista == null) {
            lista = new ArrayList<SerasaLog>();
        }
        SerasaLog serasaLog = new SerasaLog();
        serasaLog.setDataHora(LocalDateTime.now());
        serasaLog.setJsonResult(serasa.getJsonResult());
        serasaLog.setSerasa(serasa);
        serasaLog.setTemRestricao(serasa.isTemRestricao());
        serasaLog.setUsuario(euContext.getUsuario());
        serasaLog.setValorCobrado(valorCobrado);
        lista.add(serasaLog);
        serasa.setSerasaLog(lista);
    }

    public Serasa findById(Long id) {
        return this.serasaRepository.findById((Object)id).orElse(null);
    }

    public Serasa salvar(Serasa serasa) {
        if (serasa.getEstruturaUsuario() == null) {
            throw new BusinessException("Estrutura Usu\u00e1rio \u00e9 obrigatorio.");
        }
        Serasa serasaSalvo = this.getSerasa(serasa.getEstruturaUsuario(), serasa.getCliente());
        if (serasaSalvo == null) {
            serasaSalvo = new Serasa();
        }
        BeanUtils.copyProperties((Object)serasa, (Object)serasaSalvo, (String[])new String[]{"id", "itens"});
        serasaSalvo.getSerasaLog().clear();
        serasaSalvo.getSerasaLog().addAll(serasa.getSerasaLog());
        return this.persistir(serasaSalvo);
    }

    @Transactional
    private Serasa persistir(Serasa serasa) {
        serasa.getSerasaLog().forEach(item -> item.setSerasa(serasa));
        return (Serasa)this.serasaRepository.save((Object)serasa);
    }

    public void deleteSerasaByEstrutura(Estrutura e) {
        this.serasaRepository.deleteByEstruturaUsuarioEstrutura(e);
    }
}

