/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.starkbank;

import br.com.system.app.config.ApiConst;
import br.com.system.app.features.cobranca.model.CobrancaFatura;
import br.com.system.app.features.email.service.SendMailService;
import br.com.system.app.features.estrutura.model.EstruturaUsuario;
import br.com.system.app.features.shared.exception.BusinessException;
import br.com.system.app.features.starkbank.StarkBankTipoEnum;
import br.com.system.app.features.starkbank.dto.StarkBankBoletoDTO;
import br.com.system.commons.CurrencyUtil;
import br.com.system.commons.StringUtil;
import com.starkbank.Balance;
import com.starkbank.Boleto;
import com.starkbank.Event;
import com.starkbank.Invoice;
import com.starkbank.Organization;
import com.starkbank.Settings;
import com.starkbank.Transfer;
import com.starkbank.utils.Generator;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class StarkBankService
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(StarkBankService.class);
    @Autowired
    private SendMailService sendMailService;

    public StarkBankService() {
        try {
            Organization user = new Organization("production", ApiConst.STARK_ORGANIZATION_ID, ApiConst.STARK_PRIVATE_KEY, ApiConst.STARK_WORKSPACE_ID);
            Settings.user = user;
        }
        catch (Exception e) {
            this.logger.error(e.getMessage());
        }
    }

    public void deleteBoleto(String id) {
        try {
            Boleto.delete((String)id);
        }
        catch (Exception e) {
            this.logger.error(e.getMessage());
        }
    }

    public Boleto createBoleto(EstruturaUsuario eu, StarkBankBoletoDTO dto) {
        try {
            if (dto.getCep().length() > 8) {
                dto.setCep(dto.getCep().substring(0, 8));
            } else if (dto.getCep().length() < 8) {
                dto.setCep(StringUtil.zeroLeft((String)dto.getCep(), (int)8));
            }
            List boletos = new ArrayList<Boleto>();
            HashMap<String, Object> data = new HashMap<String, Object>();
            String strValue = StringUtil.numbersOnly((String)CurrencyUtil.toCurrency((BigDecimal)BigDecimal.valueOf(dto.getValor())));
            data.put("amount", StringUtil.toInt((String)strValue));
            data.put("name", dto.getNome());
            data.put("taxId", dto.getCpfCnpj());
            data.put("streetLine1", dto.getEndereco() + "," + dto.getNumero());
            data.put("streetLine2", dto.getCompl() == null || dto.getCompl().isEmpty() ? "  " : dto.getCompl());
            data.put("district", dto.getBairro());
            data.put("city", dto.getCidade());
            data.put("stateCode", dto.getEstado());
            data.put("zipCode", dto.getCep().substring(0, 5) + "-" + dto.getCep().substring(5));
            data.put("due", dto.getVencimento().format(DateTimeFormatter.ISO_DATE));
            data.put("fine", 2.5);
            data.put("interest", 1.3);
            data.put("overdueLimit", 30);
            data.put("tags", new String[]{"boletoNeo"});
            boletos.add(new Boleto(data));
            boletos = Boleto.create(boletos);
            String texto = "Ol\u00e1 " + dto.getNome() + " segue abaixo a linha digit\u00e1vel juntamente com o link do seu boleto gerado no valor de  " + dto.getValor() + ".<BR><BR>Linha digit\u00e1vel<BR>" + ((Boleto)boletos.get((int)0)).line + "<BR><BR>Link para baixar o boleto<BR>https://plussolucoes.starkbank.com/boletolink-detail/" + ((Boleto)boletos.get((int)0)).id + "<BR><BR>D\u00favidas por favor entre em contato com nosso suporte.<BR><BR>[EQUIPE NEO SALES}";
            this.sendMailService.sendNoReply(eu, dto.getListaEmail(), "Novo Boleto gerado", texto);
            return (Boleto)boletos.get(0);
        }
        catch (Exception e) {
            throw new BusinessException("Erro ao gerar boleto: " + e.getMessage());
        }
    }

    public Invoice createInvoice(StarkBankTipoEnum tipo, EstruturaUsuario eu, String cpfCnpj, String nome, String email, Double valor, LocalDate vencimento) {
        try {
            if (valor.intValue() <= 0) {
                throw new BusinessException("Valor inv\u00e1lido");
            }
            List invoices = new ArrayList<Invoice>();
            HashMap<String, Object> data = new HashMap<String, Object>();
            String strValue = StringUtil.numbersOnly((String)CurrencyUtil.toCurrency((BigDecimal)BigDecimal.valueOf(valor)));
            data.put("amount", StringUtil.toInt((String)strValue));
            data.put("due", vencimento.atTime(22, 0).format(DateTimeFormatter.ISO_DATE_TIME) + "+00:00");
            data.put("taxId", cpfCnpj);
            data.put("name", nome);
            data.put("expiration", 5097600);
            data.put("fine", 2);
            data.put("interest", 1.3);
            data.put("tags", new String[]{tipo.name()});
            invoices.add(new Invoice(data));
            invoices = Invoice.create(invoices);
            if (invoices.size() != 1) {
                throw new BusinessException("Erro ao criar fatura");
            }
            String texto = "Ol\u00e1 " + nome + " segue abaixo o link da sua fatura com o QR CODE do PIX no valor de R$ " + valor + ".<BR><BR>" + ((Invoice)invoices.get((int)0)).link + "<BR><BR>D\u00favidas por favor entre em contato com nosso suporte.<BR><BR>[EQUIPE NEO SALES}";
            this.sendMailService.sendNoReply(eu, email, "Novo PIX criado", texto);
            return (Invoice)invoices.get(0);
        }
        catch (Exception e) {
            throw new BusinessException("Erro ao criar fatura" + String.valueOf(e));
        }
    }

    public String getWebhooks(String ids) {
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("after", "2025-01-30");
            params.put("before", "2025-02-01");
            Generator events = Event.query(params);
            StringBuilder log = new StringBuilder();
            for (Event ev : events) {
                log.append(ev);
            }
            return log.toString();
        }
        catch (Exception e) {
            return e.getMessage();
        }
    }

    public void updateInvoice(CobrancaFatura cf, boolean cancelar) {
        try {
            String invoiceId = cf.getStarkId();
            LocalDate dataVencimento = cf.getDataVencimento();
            Double valor = cf.getValor().doubleValue();
            HashMap<String, Object> patchData = new HashMap<String, Object>();
            if (dataVencimento != null) {
                patchData.put("due", dataVencimento.atTime(22, 0).format(DateTimeFormatter.ISO_DATE_TIME) + "+00:00");
            }
            if (valor != null) {
                String strValue = StringUtil.numbersOnly((String)CurrencyUtil.toCurrency((BigDecimal)BigDecimal.valueOf(valor)));
                patchData.put("amount", StringUtil.toInt((String)strValue));
            }
            if (cancelar) {
                patchData.put("status", "canceled");
            }
            Invoice i = Invoice.update((String)invoiceId, patchData);
            String texto = "Ol\u00e1 " + cf.getCobrancaAssinatura().getNome() + " segue abaixo o link da sua fatura com o QR CODE do PIX no valor de R$ " + valor + ".<BR><BR>" + i.link + "<BR><BR>D\u00favidas por favor entre em contato com nosso suporte.<BR><BR>[EQUIPE NEO SALES}";
            this.sendMailService.sendNoReply(null, cf.getCobrancaAssinatura().getListaEmail(), "PIX atualizado", texto);
        }
        catch (Exception e) {
            this.logger.error(e.getMessage());
        }
    }

    public Invoice getInvoice(String id) {
        try {
            return Invoice.get((String)id);
        }
        catch (Exception e) {
            throw new BusinessException(e.getMessage());
        }
    }

    public Boleto getBoleto(String id) {
        try {
            return Boleto.get((String)id);
        }
        catch (Exception e) {
            throw new BusinessException(e.getMessage());
        }
    }

    public void transferirInter() {
        try {
            Balance balance = Balance.get();
            if (balance.amount <= 100000L) {
                return;
            }
            BigDecimal tarifa = BigDecimal.valueOf(200L);
            BigDecimal saldo = BigDecimal.valueOf(balance.amount).subtract(tarifa).divide(BigDecimal.valueOf(100L));
            this.transferByTED(ApiConst.INTER_BANK_CODE, ApiConst.INTER_BRANCH, ApiConst.INTER_BANK_ACCOUNT, ApiConst.INTER_ACCOUNT_CNPJ, ApiConst.INTER_ACCOUNT_NAME, LocalDate.now(), Double.valueOf(saldo.doubleValue()));
        }
        catch (Exception e) {
            this.logger.error(e.getMessage());
        }
    }

    public Transfer transferByTED(String bankCode, String agencia, String contaComDigito, String cpfCnpj, String nome, LocalDate dataTransferencia, Double valor) {
        try {
            if (valor <= 0.0) {
                throw new BusinessException("Valor menor igual a zero");
            }
            List transfers = new ArrayList<Transfer>();
            HashMap<String, Object> data = new HashMap<String, Object>();
            String strValue = StringUtil.numbersOnly((String)CurrencyUtil.toCurrency((BigDecimal)BigDecimal.valueOf(valor)));
            data.put("amount", StringUtil.toInt((String)strValue));
            data.put("bankCode", bankCode);
            data.put("branchCode", agencia);
            data.put("accountNumber", contaComDigito);
            data.put("taxId", cpfCnpj);
            data.put("name", nome);
            data.put("scheduled", dataTransferencia.format(DateTimeFormatter.ISO_DATE));
            transfers.add(new Transfer(data));
            transfers = Transfer.create(transfers);
            return (Transfer)transfers.get(0);
        }
        catch (Exception e) {
            throw new BusinessException(e.getMessage());
        }
    }
}

