/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.starkbank;

import br.com.system.app.features.cobranca.service.CobrancaService;
import br.com.system.app.features.creditos.service.CreditosService;
import br.com.system.commons.InputStreamUtil;
import br.com.system.commons.RandomUtil;
import br.com.system.commons.SleepUtil;
import com.starkbank.Boleto;
import com.starkbank.Event;
import com.starkbank.Invoice;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import java.io.InputStream;
import java.io.Serializable;
import org.json.JSONObject;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class StarkBankWebhookService
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Autowired
    private CreditosService creditosService;
    @Autowired
    private CobrancaService cobrancaService;

    public void webhook(ServletRequest request, ServletResponse response) {
        try {
            String body = InputStreamUtil.toString((InputStream)request.getInputStream());
            if (body.isEmpty()) {
                return;
            }
            String token = request.getParameter("token");
            if (!"e3b0c44298fc12349afbf4c8596fb92427aa41e4649c934ca495791b7852b855".equals(token)) {
                return;
            }
            SleepUtil.inMiliseconds((Integer)RandomUtil.getRandom((Integer)2000, (Integer)7000));
            JSONObject j = new JSONObject(body);
            String id = j.getJSONObject("event").getString("id");
            if (id.isEmpty()) {
                return;
            }
            Event event = Event.get((String)id);
            switch (event.subscription) {
                case "invoice": {
                    Invoice.Log log = ((Event.InvoiceEvent)event).log;
                    if (!log.type.equals("paid") || !log.invoice.status.equals("paid")) break;
                    this.creditosService.validarPagamento(log.invoice.id);
                    Double valor = log.invoice.amount.doubleValue() / 100.0;
                    this.cobrancaService.validarPagamento(log.invoice.id, valor);
                    break;
                }
                case "boleto": {
                    Boleto.Log log = ((Event.BoletoEvent)event).log;
                    if (!log.type.equals("paid") || !log.boleto.status.equals("paid")) break;
                    Double valor = Double.valueOf(log.boleto.amount) / 100.0;
                    this.cobrancaService.validarPagamento(log.boleto.id, valor);
                    break;
                }
            }
        }
        catch (Exception e) {
            LoggerFactory.getLogger(StarkBankWebhookService.class).error(e.getMessage());
        }
    }
}

