/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.task;

import br.com.system.app.MainLayout;
import br.com.system.app.components.ConfirmationDialog;
import br.com.system.app.components.containers.FooterContainer;
import br.com.system.app.features.layout.FlexBoxLayout;
import br.com.system.app.features.layout.UIUtils;
import br.com.system.app.features.layout.ViewFrame;
import br.com.system.app.features.layout.size.FontSize;
import br.com.system.app.features.layout.util.TextAlign;
import br.com.system.app.features.task.model.Task;
import br.com.system.app.features.task.service.TaskService;
import br.com.system.app.security.SecurityContext;
import br.com.system.commons.StringUtil;
import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.checkbox.Checkbox;
import com.vaadin.flow.component.dialog.Dialog;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.orderedlayout.FlexComponent;
import com.vaadin.flow.component.orderedlayout.FlexLayout;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.component.textfield.TextArea;
import com.vaadin.flow.component.textfield.TextField;
import com.vaadin.flow.router.PageTitle;
import com.vaadin.flow.router.Route;
import jakarta.annotation.security.PermitAll;
import java.io.Serializable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;

@Route(value="tasks", layout=MainLayout.class)
@PageTitle(value="Tarefas")
@PermitAll
public class TaskView
extends ViewFrame
implements SecurityContext {
    private static final long serialVersionUID = 1L;
    private final TaskService taskService;
    private int pagina = 0;
    private int totalRegistro;
    private int totalPagina;
    private TextField tf;
    private final VerticalLayout content = new VerticalLayout();

    @Autowired
    public TaskView(TaskService taskService) {
        this.taskService = taskService;
    }

    protected void onAttach(AttachEvent attachEvent) {
        super.onAttach(attachEvent);
        this.setMaxWidth("270px");
        this.setHeightFull();
        if (this.autenticado()) {
            this.add(new Component[]{UIUtils.createHeader((String)"Tarefas")});
            this.add(new Component[]{this.content});
            this.createPagination();
            this.setContent();
        }
    }

    private void setContent() {
        if (this.pagina < 0) {
            this.pagina = 0;
            return;
        }
        if (this.pagina >= this.totalPagina) {
            this.pagina = this.totalPagina - 1;
            return;
        }
        this.content.removeAll();
        Page lista = this.taskService.get(this.getEu(), (Pageable)PageRequest.of((int)this.pagina, (int)10));
        this.tf.setValue(this.pagina + 1 + " de " + this.totalPagina);
        for (Task task : lista) {
            FlexBoxLayout itemContainer = new FlexBoxLayout(FlexLayout.FlexDirection.ROW, new Component[0]);
            itemContainer.setAlignItems(FlexComponent.Alignment.BASELINE);
            itemContainer.setWidthFull();
            TextField titulo = new TextField();
            titulo.setId(task.getId().toString());
            titulo.setReadOnly(true);
            titulo.setValue(task.getTitulo());
            titulo.setWidth("100");
            UIUtils.setFontSize((FontSize)FontSize.XS, (Component[])new Component[]{titulo});
            Checkbox cb = new Checkbox();
            cb.setId(task.getId().toString());
            cb.setValue((Object)task.isConcluido());
            cb.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> {
                this.taskService.alterarConcluido(StringUtil.toLong((String)((String)((Checkbox)e.getSource()).getId().get())));
                this.setContent();
            });
            if (((Boolean)cb.getValue()).booleanValue()) {
                titulo.getStyle().set("text-decoration", "line-through");
            }
            Button edit = UIUtils.createSmallButton((VaadinIcon)VaadinIcon.EDIT, (String)"Editar tarefa");
            edit.setId(task.getId().toString());
            edit.addClickListener((ComponentEventListener & Serializable)e -> this.openDialog(StringUtil.toLong((String)((String)((Button)e.getSource()).getId().get()))));
            Button btnExcluir = UIUtils.createSmallButton((VaadinIcon)VaadinIcon.TRASH, (String)"Excluir tarefa");
            btnExcluir.setId(task.getId().toString());
            btnExcluir.addClickListener((ComponentEventListener & Serializable)e -> {
                ConfirmationDialog cd = new ConfirmationDialog("Excluir", "Confirma exclus\u00e3o?");
                cd.getCancel().addClickListener((ComponentEventListener & Serializable)cancel -> cd.close());
                cd.getConfirm().addClickListener((ComponentEventListener & Serializable)confirm -> {
                    this.taskService.delete(StringUtil.toLong((String)((String)((Button)e.getSource()).getId().get())));
                    cd.close();
                    this.setContent();
                });
            });
            itemContainer.add(new Component[]{titulo, cb, edit, btnExcluir});
            this.content.add(new Component[]{itemContainer});
        }
    }

    private void setPagination() {
        this.totalRegistro = this.taskService.count(this.getEu()).intValue();
        this.totalPagina = this.totalRegistro / 10;
        int resto = this.totalRegistro % 10;
        if (resto > 0) {
            ++this.totalPagina;
        }
    }

    private void createPagination() {
        this.setPagination();
        this.tf = new TextField();
        this.tf.setReadOnly(true);
        this.tf.setWidth("80px");
        Button btnProximo = UIUtils.createSmallButton((VaadinIcon)VaadinIcon.STEP_FORWARD, (String)"Pr\u00f3xima p\u00e1gina");
        Button btnAnterior = UIUtils.createSmallButton((VaadinIcon)VaadinIcon.STEP_BACKWARD, (String)"P\u00e1gina anterior");
        Button btnCriar = UIUtils.createSmallButton((VaadinIcon)VaadinIcon.PLUS, (String)"Adicionar tarefa");
        btnProximo.addClickListener((ComponentEventListener & Serializable)e -> {
            ++this.pagina;
            this.setContent();
        });
        btnAnterior.addClickListener((ComponentEventListener & Serializable)e -> {
            --this.pagina;
            this.setContent();
        });
        btnCriar.addClickListener((ComponentEventListener & Serializable)e -> this.openDialog(Long.valueOf(0L)));
        UIUtils.setTextAlign((TextAlign)TextAlign.CENTER, (Component[])new Component[]{this.tf});
        this.add(new Component[]{new FooterContainer(new Component[]{btnAnterior, this.tf, btnProximo, btnCriar})});
    }

    private void openDialog(Long taskId) {
        Task task = taskId > 0L ? this.taskService.getById(taskId) : new Task();
        Dialog dialog = new Dialog();
        FlexBoxLayout dialogContainer = new FlexBoxLayout(FlexLayout.FlexDirection.COLUMN, new Component[0]).setSpacingS();
        TextField titulo = new TextField("Titulo");
        titulo.setValue(task.getTitulo() == null ? "" : task.getTitulo());
        TextArea descricao = new TextArea("Descri\u00e7\u00e3o");
        descricao.setValue(task.getDescricao() == null ? "" : task.getDescricao());
        Button btnSave = UIUtils.createSmallButton((VaadinIcon)VaadinIcon.INBOX, (String)"Salvar tarefa");
        btnSave.addClickListener((ComponentEventListener & Serializable)e -> {
            if (titulo.isEmpty()) {
                UIUtils.showNotification((String)"Informe um titulo");
                return;
            }
            task.setTitulo(titulo.getValue());
            task.setDescricao(descricao.getValue());
            task.setEstruturaUsuario(this.getEu());
            this.taskService.save(task);
            dialog.close();
            this.pagina = 0;
            this.setPagination();
            this.setContent();
        });
        dialogContainer.add(new Component[]{titulo, descricao, btnSave});
        dialog.add(new Component[]{dialogContainer});
        dialog.open();
    }
}

