/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.task.service;

import br.com.system.app.features.estrutura.model.Estrutura;
import br.com.system.app.features.estrutura.model.EstruturaUsuario;
import br.com.system.app.features.shared.exception.BusinessException;
import br.com.system.app.features.task.model.Task;
import br.com.system.app.features.task.repository.TaskRepository;
import java.io.Serializable;
import java.time.LocalDateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
public class TaskService
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Autowired
    private TaskRepository taskRepository;

    public Task save(Task task) {
        if (task.getDataHoraCriacao() == null) {
            task.setDataHoraCriacao(LocalDateTime.now());
        }
        if (task.getTitulo().isEmpty()) {
            throw new BusinessException("Titulo \u00e9 obrigat\u00f3rio");
        }
        return (Task)this.taskRepository.save((Object)task);
    }

    public Task getById(Long id) {
        return (Task)this.taskRepository.findById((Object)id).get();
    }

    public Page<Task> get(EstruturaUsuario euContext, Pageable pageable) {
        return this.taskRepository.findByEstruturaUsuarioOrderByDataHoraCriacaoDesc(euContext, pageable);
    }

    public Long count(EstruturaUsuario euContext) {
        return this.taskRepository.countByEstruturaUsuarioOrderByDataHoraCriacaoDesc(euContext);
    }

    public Task alterarConcluido(Long taskId) {
        return this.alterarConcluido((Task)this.taskRepository.findById((Object)taskId).get());
    }

    public Task alterarConcluido(Task task) {
        task.setConcluido(!task.isConcluido());
        return (Task)this.taskRepository.save((Object)task);
    }

    public void delete(Long taskId) {
        this.taskRepository.delete((Object)this.getById(taskId));
    }

    public void delete(Task task) {
        this.taskRepository.delete((Object)task);
    }

    public void deleteByEstrutura(Estrutura e) {
        this.taskRepository.deleteByEstruturaUsuarioEstrutura(e);
    }
}

