/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.tim.service;

import br.com.system.app.MainLayout;
import br.com.system.app.components.containers.FooterContainer;
import br.com.system.app.components.containers.VerticalContainer;
import br.com.system.app.features.layout.UIUtils;
import br.com.system.app.features.layout.ViewFrame;
import br.com.system.app.features.layout.util.Shadow;
import br.com.system.app.features.tim.service.PedidoTimService;
import br.com.system.app.features.util.TempFileMultiBuffer;
import br.com.system.app.security.SecurityContext;
import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.upload.Receiver;
import com.vaadin.flow.component.upload.Upload;
import com.vaadin.flow.router.PageTitle;
import com.vaadin.flow.router.Route;
import elemental.json.Json;
import elemental.json.JsonValue;
import jakarta.annotation.security.RolesAllowed;
import java.io.Serializable;
import org.springframework.beans.factory.annotation.Autowired;

@Route(value="tim-pedido-view", layout=MainLayout.class)
@PageTitle(value="Pedido TIM Atualiza\u00e7\u00e3o")
@RolesAllowed(value={"PEDIDO_TIM_VIEW"})
public class PedidoTimView
extends ViewFrame
implements SecurityContext {
    private static final long serialVersionUID = 1L;
    private String nomeArquivo = "";
    private final PedidoTimService pedidoTimService;
    private TempFileMultiBuffer mBuffer;
    private Upload upload;

    @Autowired
    public PedidoTimView(PedidoTimService pedidoTimService) {
        this.pedidoTimService = pedidoTimService;
    }

    protected void onAttach(AttachEvent attachEvent) {
        super.onAttach(attachEvent);
        if (this.autenticado()) {
            this.setViewContent(this.createContent());
        } else {
            this.showNotification("Sem permiss\u00e3o");
        }
    }

    private Component createContent() {
        this.mBuffer = new TempFileMultiBuffer();
        this.upload = new Upload((Receiver)this.mBuffer);
        this.upload.setMaxFiles(1);
        this.upload.setDropLabel((Component)new Span("Arraste arquivos pra c\u00e1"));
        this.upload.setAcceptedFileTypes(new String[]{".xlsx"});
        this.upload.addFinishedListener((ComponentEventListener & Serializable)e -> {
            this.nomeArquivo = e.getFileName();
            UIUtils.showNotification((String)"Arquivo carregado, clique em processar");
        });
        this.upload.addFileRejectedListener((ComponentEventListener & Serializable)event -> UIUtils.showNotification((String)"Formato inv\u00e1lido, apenas .xlsx"));
        Button processar = UIUtils.createSmallButton((String)"Processar Arquivo");
        processar.addClickListener((ComponentEventListener & Serializable)e -> {
            if (this.nomeArquivo.isEmpty()) {
                this.showNotification("Selecione o arquivo.");
                return;
            }
            this.processar();
        });
        VerticalContainer card = new VerticalContainer(new Component[0]);
        card.setShadow(Shadow.S);
        card.add(new Component[]{UIUtils.createHeader((String)"Atualizar Pedidos")});
        card.add(new Component[]{this.upload, new FooterContainer(new Component[]{processar})});
        return card;
    }

    private void processar() {
        try {
            this.pedidoTimService.importarArquivos(this.getEu(), this.mBuffer.getInputStream(), this.mBuffer.getMimeType());
            this.showNotification("Processo iniciado com sucesso, ao final voc\u00ea ser\u00e1 notificado");
        }
        catch (Exception ex) {
            this.showNotification(ex.getMessage());
        }
        this.upload.getElement().setPropertyJson("files", (JsonValue)Json.createArray());
        this.nomeArquivo = "";
        this.mBuffer.clear();
    }
}

