/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.usuario.service;

import br.com.system.app.features.equipe.model.Equipe;
import br.com.system.app.features.estrutura.model.EstruturaUsuario;
import br.com.system.app.features.estrutura.repository.EstruturaUsuarioRepository;
import br.com.system.app.features.estrutura.repository.projection.HierarquiaDTO;
import br.com.system.app.features.usuario.model.UsuarioPerfilEnum;
import br.com.system.app.features.usuario.model.UsuarioTag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UsuarioHierarquiaService
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Autowired
    private EstruturaUsuarioRepository repository;

    public void setHierarquia(EstruturaUsuario eu, Set<Long> hierarquia) {
        this.repository.salvarHierarquia(eu, hierarquia);
    }

    public void insertHierarquia(EstruturaUsuario eu, EstruturaUsuario euModelo) {
        this.repository.insertHierarquia(eu, euModelo);
    }

    public Set<Long> getHierarquia(Long euId) {
        EstruturaUsuario eu = (EstruturaUsuario)this.repository.findById((Object)euId).get();
        if (eu == null) {
            return null;
        }
        return this.getHierarquia(eu);
    }

    public Set<Long> getHierarquia(EstruturaUsuario eu) {
        if (eu == null) {
            return null;
        }
        HashSet<Long> hierarquia = new HashSet<Long>();
        hierarquia.add(eu.getId());
        hierarquia.addAll(this.repository.findHierarchy(eu.getUsuario().getId(), eu.getEstrutura().getId()));
        return hierarquia;
    }

    public Long[] getHierarquiaLongArray(EstruturaUsuario eu) {
        Long[] hierarquia = this.repository.findHierarchyLongArray(eu.getUsuario().getId(), eu.getEstrutura().getId());
        Long[] hierarquiaWithme = Arrays.copyOf(hierarquia, hierarquia.length + 1);
        hierarquiaWithme[hierarquia.length] = eu.getId();
        return hierarquiaWithme;
    }

    public List<HierarquiaDTO> getHierarquiaDto(EstruturaUsuario estruturaUsuario) {
        return this.getHierarquiaDto(estruturaUsuario, "", Boolean.valueOf(true));
    }

    public List<HierarquiaDTO> getHierarquiaDto(EstruturaUsuario estruturaUsuario, Boolean onlyActives) {
        return this.getHierarquiaDto(estruturaUsuario, "", onlyActives);
    }

    public List<HierarquiaDTO> getHierarquiaDto(EstruturaUsuario estruturaUsuario, String filtername, Boolean onlyActives) {
        return this.getHierarquiaDto(estruturaUsuario, filtername, new HashSet(), new HashSet(), new HashSet(), onlyActives, Boolean.valueOf(false));
    }

    public List<HierarquiaDTO> getHierarquiaDto(EstruturaUsuario estruturaUsuario, String filtername, Set<UsuarioTag> tag, Set<UsuarioPerfilEnum> perfil, Boolean onlyActives) {
        return this.getHierarquiaDto(estruturaUsuario, filtername, tag, perfil, new HashSet(), onlyActives, Boolean.FALSE);
    }

    public List<HierarquiaDTO> getHierarquiaDto(EstruturaUsuario estruturaUsuario, String filtername, Set<UsuarioTag> tag, Set<UsuarioPerfilEnum> perfil, Set<Equipe> equipe, Boolean onlyActives, Boolean outHierarchy) {
        ArrayList<String> lTag = new ArrayList<String>();
        for (UsuarioTag t : tag) {
            lTag.add(t.getTag());
        }
        ArrayList<String> lPerfil = new ArrayList<String>();
        for (UsuarioPerfilEnum p : perfil) {
            lPerfil.add(p.name());
        }
        if (outHierarchy.booleanValue()) {
            return this.repository.findOutHierarquiaDto(estruturaUsuario, filtername, lTag, lPerfil, equipe, onlyActives);
        }
        return this.repository.findHierarquiaDto(estruturaUsuario, filtername, lTag, lPerfil, equipe, onlyActives);
    }

    public List<HierarquiaDTO> getUsuarioNaHierarquia(Long euId) {
        return this.repository.findUsuarioNaHierarquia(euId);
    }
}

