/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.usuario.views;

import br.com.system.app.components.containers.FooterContainer;
import br.com.system.app.components.containers.VerticalContainer;
import br.com.system.app.features.layout.UIUtils;
import br.com.system.app.features.usuario.model.Usuario;
import br.com.system.app.features.usuario.service.UsuarioSenhaService;
import br.com.system.app.features.usuario.util.UsuarioValidacaoSenha;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.dialog.Dialog;
import com.vaadin.flow.component.dialog.DialogVariant;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.shared.ThemeVariant;
import com.vaadin.flow.component.textfield.PasswordField;
import java.io.Serializable;

public class UsuarioNovaSenhaView
extends Dialog {
    private static final long serialVersionUID = 1L;

    public UsuarioNovaSenhaView(Usuario u, UsuarioSenhaService usuarioSenhaService, boolean redirect, String theme) {
        this.addThemeVariants((ThemeVariant[])new DialogVariant[]{DialogVariant.LUMO_NO_PADDING});
        this.setCloseOnEsc(false);
        this.setCloseOnOutsideClick(false);
        Div div = new Div();
        div.getElement().setProperty("innerHTML", UsuarioValidacaoSenha.getRegras());
        PasswordField senha = new PasswordField("Nova Senha");
        PasswordField senhaConf = new PasswordField("Confirme Senha");
        Button btnFechar = UIUtils.createSmallButton((String)"Fechar");
        btnFechar.setVisible(!redirect);
        btnFechar.addClickListener((ComponentEventListener & Serializable)e -> this.close());
        Button btn = UIUtils.createSmallButton((String)"Confirmar");
        btn.addClickListener((ComponentEventListener & Serializable)e -> {
            String erro = UsuarioValidacaoSenha.valido((Usuario)u, (String)senha.getValue(), (String)senhaConf.getValue(), (UsuarioSenhaService)usuarioSenhaService);
            if (!erro.isBlank()) {
                UIUtils.showNotification((String)erro);
                return;
            }
            Usuario usuario = usuarioSenhaService.atualizarSenha(u, senha.getValue());
            if (usuario == null) {
                UIUtils.showNotification((String)"Erro ao alterar a senha, contacte o suporte.");
            } else {
                UIUtils.showNotification((String)"Senha alterada com sucesso");
            }
            this.close();
            UI.getCurrent().navigate("login");
        });
        VerticalContainer v = new VerticalContainer(new Component[0]).setPaddingOn();
        v.getThemeList().add((Object)theme);
        v.add(new Component[]{senha, senhaConf, new FooterContainer(new Component[]{btnFechar, btn}), div});
        this.add(new Component[]{v});
        this.open();
    }
}

