/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.usuario.views;

import br.com.system.app.MainLayout;
import br.com.system.app.components.ConfirmationDialog;
import br.com.system.app.components.MultiComboBox;
import br.com.system.app.components.containers.HorizontalContainer;
import br.com.system.app.components.containers.VerticalContainer;
import br.com.system.app.features.estrutura.service.EstruturaUsuarioService;
import br.com.system.app.features.layout.UIUtils;
import br.com.system.app.features.layout.ViewFrame;
import br.com.system.app.features.layout.size.FontSize;
import br.com.system.app.features.usuario.model.UsuarioTag;
import br.com.system.app.features.usuario.service.UsuarioHierarquiaService;
import br.com.system.app.features.usuario.service.UsuarioService;
import br.com.system.app.features.usuario.service.UsuarioTagService;
import br.com.system.app.features.usuario.views.HierarquiaView;
import br.com.system.app.features.usuario.views.UsuarioTagView;
import br.com.system.app.security.SecurityContext;
import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.dialog.Dialog;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.radiobutton.RadioButtonGroup;
import com.vaadin.flow.component.textfield.TextField;
import com.vaadin.flow.router.PageTitle;
import com.vaadin.flow.router.Route;
import jakarta.annotation.security.RolesAllowed;
import java.io.Serializable;
import java.util.Collection;

/*
 * Exception performing whole class analysis ignored.
 */
@Route(value="usuario-tag", layout=MainLayout.class)
@PageTitle(value="Tags Usu\u00e1rios")
@RolesAllowed(value={"USUARIO_TAG_VIEW"})
public class UsuarioTagView
extends ViewFrame
implements SecurityContext {
    private static final long serialVersionUID = 1L;
    private final UsuarioService usuarioService;
    private final EstruturaUsuarioService eus;
    private final UsuarioHierarquiaService hierarquiaService;
    private final UsuarioTagService usuarioTagService;
    private MultiComboBox<UsuarioTag> tags;

    public UsuarioTagView(UsuarioService usuarioService, EstruturaUsuarioService eus, UsuarioHierarquiaService hierarquiaService, UsuarioTagService usuarioTagService) {
        this.usuarioService = usuarioService;
        this.usuarioTagService = usuarioTagService;
        this.hierarquiaService = hierarquiaService;
        this.eus = eus;
    }

    protected void onAttach(AttachEvent attachEvent) {
        super.onAttach(attachEvent);
        if (this.autenticado()) {
            this.setViewContent(this.createContent());
        }
    }

    private Component createContent() {
        this.tags = new MultiComboBox("Tags");
        this.tags.setItemLabelGenerator(UsuarioTag::getTag);
        this.povoaTag();
        HierarquiaView hierarquiaView = new HierarquiaView(this.getEu(), this.eus, this.hierarquiaService);
        hierarquiaView.setMultiple(Boolean.TRUE);
        hierarquiaView.getBtnConfirmar().setVisible(false);
        hierarquiaView.getBtnFechar().setVisible(false);
        RadioButtonGroup rb = new RadioButtonGroup();
        rb.setItems((Object[])Acao.values());
        rb.setValue((Object)Acao.INCLUIR);
        UIUtils.setFontSize((FontSize)FontSize.XXS, (Component[])new Component[]{rb});
        Button btnAtribuir = UIUtils.createSmallButton((String)"Confirmar", (VaadinIcon)VaadinIcon.CHECK, (String)"");
        btnAtribuir.addClickListener((ComponentEventListener & Serializable)e -> {
            if (!(((Acao)rb.getValue()).equals((Object)Acao.LIMPAR) || hierarquiaView.getValues().size() > 0 && this.tags.getValue().size() > 0)) {
                this.showNotification("Selecione pelo menos um usu\u00e1rio e uma tag para atribuir");
                return;
            }
            ConfirmationDialog cd = new ConfirmationDialog("Atribui\u00e7\u00e3o Tags", "Confirma " + String.valueOf(rb.getValue()) + " tags?");
            cd.getCancel().addClickListener((ComponentEventListener & Serializable)cancel -> cd.close());
            cd.getConfirm().addClickListener((ComponentEventListener & Serializable)confirm -> {
                this.usuarioService.saveTags(hierarquiaView.getValues(), this.tags.getValue(), !((Acao)rb.getValue()).equals((Object)Acao.REMOVER), ((Acao)rb.getValue()).equals((Object)Acao.LIMPAR));
                hierarquiaView.refresh();
                cd.close();
            });
        });
        Button btnExcluir = UIUtils.createSmallButton((String)"Excluir tags", (VaadinIcon)VaadinIcon.TRASH, (String)"");
        btnExcluir.addClickListener((ComponentEventListener & Serializable)e -> {
            if (this.tags.getValue().size() <= 0) {
                this.showNotification("Selecione uma tag para excluilr");
                return;
            }
            ConfirmationDialog cd = new ConfirmationDialog("Exclus\u00e3o de TAG", "Confirma a EXCLUS\u00c3O das tags e a remo\u00e7\u00e3o nos usu\u00e1rios?");
            cd.getCancel().addClickListener((ComponentEventListener & Serializable)cancel -> cd.close());
            cd.getConfirm().addClickListener((ComponentEventListener & Serializable)confirm -> {
                this.usuarioService.deleteTags(this.getEu(), this.tags.getValue());
                this.usuarioTagService.deleteTags(this.tags.getValue(), this.getEu());
                hierarquiaView.refresh();
                this.povoaTag();
                cd.close();
            });
        });
        Button btnAdd = UIUtils.createSmallButton((String)"Nova tag", (VaadinIcon)VaadinIcon.PLUS, (String)"Insere nova tag");
        btnAdd.addClickListener((ComponentEventListener & Serializable)e -> {
            TextField tagName = UIUtils.createTextField((String)"Tags ex: #recebeLead,#CTL,#MEI");
            tagName.setWidth("150px");
            Dialog dialog = new Dialog();
            dialog.add(new Component[]{tagName});
            Button conf = UIUtils.createSmallButton((VaadinIcon)VaadinIcon.CHECK, (String)"Salvar tag");
            dialog.add(new Component[]{conf});
            conf.addClickListener((ComponentEventListener & Serializable)c -> {
                if (tagName.getValue().isBlank()) {
                    this.showNotification("Informe um nome");
                    return;
                }
                this.usuarioService.saveTags(this.getEu(), tagName.getValue());
                this.povoaTag();
                this.showNotification("Inserida(s) com sucesso");
                dialog.close();
            });
            dialog.open();
        });
        return new VerticalContainer(new Component[]{new HorizontalContainer(new Component[]{this.tags, rb, btnAtribuir, btnAdd, btnExcluir}), hierarquiaView});
    }

    private void povoaTag() {
        this.tags.setItems((Collection)this.usuarioTagService.getTags(this.getEu().getEstrutura()));
    }
}

