/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.whatsapp;

import br.com.system.app.components.containers.FooterContainer;
import br.com.system.app.components.containers.HorizontalContainer;
import br.com.system.app.features.layout.UIUtils;
import br.com.system.app.features.waha.service.WahaService;
import br.com.system.app.features.whatsapp.dto.WhatsAppFornecedorEnum;
import br.com.system.app.features.whatsapp.model.WhatsAppConta;
import br.com.system.app.features.whatsapp.model.WhatsAppHave;
import br.com.system.app.features.whatsapp.service.WhatsAppContaService;
import br.com.system.app.features.whatsapp.service.WhatsAppHaveService;
import br.com.system.app.security.SecurityContext;
import br.com.system.commons.HashUtil;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.checkbox.Checkbox;
import com.vaadin.flow.component.combobox.ComboBox;
import com.vaadin.flow.component.dialog.Dialog;
import com.vaadin.flow.component.textfield.TextField;
import java.io.Serializable;
import java.time.LocalTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Scope(value="request", proxyMode=ScopedProxyMode.TARGET_CLASS)
public class WhatsAppContaFormView
extends Dialog
implements SecurityContext {
    private static final long serialVersionUID = 1L;
    @Autowired
    private WhatsAppContaService whatsappContaService;
    @Autowired
    private WhatsAppHaveService haveService;
    @Autowired
    private WahaService wahaService;
    private WhatsAppConta conta;
    TextField numero = new TextField("Numero");
    TextField token = new TextField("Token");
    Checkbox cbAtivo = new Checkbox("Ativo");
    Checkbox cbOficial = new Checkbox("API Oficial");
    Checkbox cbMarketing = new Checkbox("Marketing");
    Checkbox cbAtendimento = new Checkbox("Atendimento");
    Checkbox cbNotificacao = new Checkbox("Notificacao");
    ComboBox<WhatsAppFornecedorEnum> cbFornecedor = new ComboBox("Fornecedor");
    TextField templateName = new TextField("TemplateName");
    TextField webhook = new TextField("URL Webhook");

    public void create(WhatsAppConta conta) {
        this.conta = conta;
        this.create();
    }

    @Transactional
    private void create() {
        if (this.conta == null) {
            this.conta = new WhatsAppConta();
        }
        if (this.conta.getEstrutura() == null) {
            this.conta.setEstrutura(this.getEstrutura());
        }
        if (this.conta.getNumero() != null) {
            this.numero.setValue(this.conta.getNumero());
        }
        if (this.conta.getMooseId() != null && !this.conta.getMooseId().isEmpty()) {
            this.token.setValue(this.conta.getMooseId());
        } else if (this.conta.getFornecedor() != null && this.conta.getFornecedor().equals((Object)WhatsAppFornecedorEnum.NEO)) {
            this.token.setValue(HashUtil.getUUI());
            this.token.setEnabled(false);
        }
        this.cbAtivo.setValue((Object)this.conta.isAtivo());
        if (this.conta.getApiOficial() != null) {
            this.cbOficial.setValue((Object)this.conta.getApiOficial());
        } else {
            this.cbOficial.setValue((Object)false);
        }
        this.cbMarketing.setValue((Object)this.conta.isMarketing());
        this.cbAtendimento.setValue((Object)this.conta.isAtendimento());
        this.cbNotificacao.setValue((Object)this.conta.isNotificacao());
        this.cbFornecedor.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> {
            this.webhook.setVisible(false);
            this.token.setEnabled(true);
            this.templateName.setVisible(false);
            if (((WhatsAppFornecedorEnum)e.getValue()).equals((Object)WhatsAppFornecedorEnum.NEO)) {
                this.webhook.setVisible(true);
                this.token.setEnabled(false);
                if (this.conta.getId() == null) {
                    this.token.setValue(HashUtil.getUUI());
                }
            } else if (((WhatsAppFornecedorEnum)e.getValue()).equals((Object)WhatsAppFornecedorEnum.MOORSE)) {
                this.templateName.setVisible(true);
            }
        });
        this.cbFornecedor.setItemLabelGenerator(Enum::name);
        this.cbFornecedor.setItems((Object[])WhatsAppFornecedorEnum.values());
        if (this.conta.getFornecedor() != null) {
            this.cbFornecedor.setValue((Object)this.conta.getFornecedor());
        }
        if (this.conta.getTemplateName() != null) {
            this.templateName.setValue(this.conta.getTemplateName());
        }
        TextField horaInicial1 = new TextField("Hora Inicial 1");
        if (this.conta.getHoraInicial1() != null) {
            horaInicial1.setValue(this.conta.getHoraInicial1().toString());
        }
        TextField horaFinal1 = new TextField("Hora Final 1");
        if (this.conta.getHoraFinal1() != null) {
            horaFinal1.setValue(this.conta.getHoraFinal1().toString());
        }
        TextField horaInicial2 = new TextField("Hora Inicial 2");
        if (this.conta.getHoraInicial2() != null) {
            horaInicial2.setValue(this.conta.getHoraInicial2().toString());
        }
        TextField horaFinal2 = new TextField("Hora Final 2");
        if (this.conta.getHoraFinal2() != null) {
            horaFinal2.setValue(this.conta.getHoraFinal2().toString());
        }
        TextField horaInicialSabado = new TextField("Hora Inicial Sabado");
        if (this.conta.getHoraInicialSabado() != null) {
            horaInicialSabado.setValue(this.conta.getHoraInicialSabado().toString());
        }
        TextField horaFinalSabado = new TextField("Hora Inicial Sabado");
        if (this.conta.getHoraFinalSabado() != null) {
            horaFinalSabado.setValue(this.conta.getHoraFinalSabado().toString());
        }
        this.webhook.setWidth("100%");
        if (this.conta.getUrlWebhook() != null) {
            this.webhook.setValue(this.conta.getUrlWebhook());
        }
        Button btnCancel = UIUtils.createSmallButton((String)"Fechar");
        btnCancel.addClickListener((ComponentEventListener & Serializable)e -> this.close());
        Button btnSalvar = UIUtils.createSmallButton((String)"Salvar");
        this.add(new com.vaadin.flow.component.Component[]{this.numero, this.token});
        this.add(new com.vaadin.flow.component.Component[]{new HorizontalContainer(new com.vaadin.flow.component.Component[]{this.cbAtivo, this.cbOficial, this.cbMarketing, this.cbAtendimento, this.cbNotificacao})});
        this.add(new com.vaadin.flow.component.Component[]{this.cbFornecedor, this.templateName});
        this.add(new com.vaadin.flow.component.Component[]{new HorizontalContainer(new com.vaadin.flow.component.Component[]{horaInicial1, horaFinal1})});
        this.add(new com.vaadin.flow.component.Component[]{new HorizontalContainer(new com.vaadin.flow.component.Component[]{horaInicial2, horaFinal2})});
        this.add(new com.vaadin.flow.component.Component[]{new HorizontalContainer(new com.vaadin.flow.component.Component[]{horaInicialSabado, horaFinalSabado})});
        this.add(new com.vaadin.flow.component.Component[]{this.webhook});
        this.add(new com.vaadin.flow.component.Component[]{new FooterContainer(new com.vaadin.flow.component.Component[]{btnCancel, btnSalvar})});
        btnSalvar.addClickListener((ComponentEventListener & Serializable)e -> {
            if (this.numero.getValue() == null || this.numero.getValue().isEmpty()) {
                UIUtils.showNotification((String)"Numero \u00e9 obrigatorio");
                return;
            }
            if (this.cbFornecedor.getValue() == null) {
                UIUtils.showNotification((String)"Fornecedor \u00e9 obrigat\u00f3rio");
                return;
            }
            if (horaInicial1.getValue() == null || horaInicial1.getValue().isEmpty() || horaFinal2.getValue() == null || horaFinal2.isEmpty()) {
                UIUtils.showNotification((String)"Hora inicial1 e Hora Final2 s\u00e3o obrigat\u00f3rios");
                return;
            }
            if (this.token.getValue() == null || this.token.isEmpty()) {
                UIUtils.showNotification((String)"Token \u00e9 obrigat\u00f3rio");
                return;
            }
            if (((WhatsAppFornecedorEnum)this.cbFornecedor.getValue()).equals((Object)WhatsAppFornecedorEnum.MOORSE) && this.templateName.getValue().isEmpty()) {
                UIUtils.showNotification((String)"TemplateName \u00e9 obrigat\u00f3rio");
                return;
            }
            if (((WhatsAppFornecedorEnum)this.cbFornecedor.getValue()).equals((Object)WhatsAppFornecedorEnum.NEO) && this.webhook.getValue().isEmpty()) {
                UIUtils.showNotification((String)"URL webhook \u00e9 obrigat\u00f3rio");
                return;
            }
            try {
                WhatsAppHave have = this.haveService.getHave(this.numero.getValue());
                if (have == null || !have.getHave().booleanValue()) {
                    throw new Exception("Este n\u00famero n\u00e3o tem whatsapp");
                }
                this.conta.setMooseId(this.token.getValue());
                this.conta.setApiOficial((Boolean)this.cbOficial.getValue());
                this.conta.setAtendimento(((Boolean)this.cbAtendimento.getValue()).booleanValue());
                this.conta.setAtivo(((Boolean)this.cbAtivo.getValue()).booleanValue());
                this.conta.setFornecedor((WhatsAppFornecedorEnum)this.cbFornecedor.getValue());
                this.conta.setHoraInicial1(LocalTime.parse(horaInicial1.getValue()));
                if (horaFinal1.getValue() != null && !horaFinal1.isEmpty()) {
                    this.conta.setHoraFinal1(LocalTime.parse(horaFinal1.getValue()));
                }
                if (horaInicial2.getValue() != null && !horaInicial2.isEmpty()) {
                    this.conta.setHoraInicial2(LocalTime.parse(horaInicial2.getValue()));
                }
                this.conta.setHoraFinal2(LocalTime.parse(horaFinal2.getValue()));
                if (horaInicialSabado.getValue() != null && !horaInicialSabado.isEmpty()) {
                    this.conta.setHoraInicialSabado(LocalTime.parse(horaInicialSabado.getValue()));
                }
                if (horaFinalSabado.getValue() != null && !horaFinalSabado.isEmpty()) {
                    this.conta.setHoraFinalSabado(LocalTime.parse(horaFinalSabado.getValue()));
                }
                this.conta.setMarketing(((Boolean)this.cbMarketing.getValue()).booleanValue());
                this.conta.setNotificacao(((Boolean)this.cbNotificacao.getValue()).booleanValue());
                this.conta.setNumero(have.getNumeroWhats());
                this.conta.setTemplateName(this.templateName.getValue());
                this.conta.setUrlWebhook(this.webhook.getValue());
                this.conta = this.whatsappContaService.save(this.conta);
                if (this.conta.getFornecedor().equals((Object)WhatsAppFornecedorEnum.NEO)) {
                    this.wahaService.saveSession(this.conta, this.getEu(), this.webhook.getValue());
                }
            }
            catch (Exception ex) {
                if (this.conta.getId() != null) {
                    this.whatsappContaService.delete(this.conta);
                }
                this.close();
                UIUtils.showNotification((String)ex.getMessage());
                return;
            }
            this.close();
        });
        this.open();
    }
}

