/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.whatsapp;

import br.com.system.app.components.containers.FooterContainer;
import br.com.system.app.features.layout.UIUtils;
import br.com.system.app.features.util.TempFileMultiBuffer;
import br.com.system.commons.FileUtil;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.dialog.Dialog;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.upload.Receiver;
import com.vaadin.flow.component.upload.Upload;
import java.io.InputStream;
import java.io.Serializable;
import org.apache.commons.io.IOUtils;

public class WhatsAppFileDialog
extends Dialog {
    private static final long serialVersionUID = 1L;
    private String fileName = "";
    private TempFileMultiBuffer mBuffer;
    private byte[] file;

    public String getFileName() {
        return this.fileName;
    }

    public byte[] getFile() {
        return this.file;
    }

    public void clear() {
        this.file = null;
        this.fileName = "";
        this.mBuffer.clear();
    }

    public void show() {
        this.removeAll();
        this.setWidth("400px");
        this.add(new Component[]{UIUtils.createHeader((String)"Enviar Arquivo")});
        this.mBuffer = new TempFileMultiBuffer();
        Upload upload = new Upload((Receiver)this.mBuffer);
        upload.setMaxFiles(1);
        upload.setAcceptedFileTypes(new String[]{".*"});
        upload.setDropLabel((Component)new Span("Solte o arquivo aqui"));
        upload.addFinishedListener((ComponentEventListener & Serializable)e -> {
            this.fileName = FileUtil.normalizeFileName((String)e.getFileName());
            UIUtils.showNotification((String)"Arquivo carregado, clique em enviar");
        });
        upload.addFileRejectedListener((ComponentEventListener & Serializable)event -> UIUtils.showNotification((String)"Arquivo invalido"));
        Button bClose = UIUtils.createSmallButton((String)"Fechar", (VaadinIcon)VaadinIcon.CLOSE, (String)"Fechar janela");
        bClose.addClickListener((ComponentEventListener & Serializable)e -> this.close());
        Button bSend = UIUtils.createSmallButton((String)"Enviar", (VaadinIcon)VaadinIcon.FILE_START, (String)"Enviar arquivo");
        bSend.addClickListener((ComponentEventListener & Serializable)e -> {
            if (this.fileName.isEmpty()) {
                UIUtils.showNotification((String)"Selecione o arquivo.");
            } else {
                try {
                    String extensao = FileUtil.getExtension((String)this.fileName, (boolean)false);
                    this.fileName = this.fileName.replace(extensao, extensao.toLowerCase());
                    this.file = IOUtils.toByteArray((InputStream)this.mBuffer.getInputStream());
                }
                catch (Exception ex) {
                    UIUtils.showNotification((String)ex.getMessage());
                }
                this.close();
            }
        });
        this.add(new Component[]{upload, new FooterContainer(new Component[]{bClose, bSend})});
        this.open();
    }
}

