/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.whatsapp.repository;

import br.com.system.app.features.estrutura.model.Estrutura;
import br.com.system.app.features.whatsapp.dto.WhatsAppExportacaoDTO;
import br.com.system.app.features.whatsapp.model.WhatsAppAtendente;
import br.com.system.app.features.whatsapp.model.WhatsAppEtapaEnum;
import br.com.system.app.features.whatsapp.repository.WhatsAppRepositoryQuery;
import br.com.system.commons.datetime.DateTimeUtil;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import jakarta.persistence.Query;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.List;
import java.util.Set;
import org.springframework.transaction.annotation.Transactional;

public class WhatsAppRepositoryImpl
implements WhatsAppRepositoryQuery,
Serializable {
    private static final long serialVersionUID = 1L;
    @PersistenceContext
    private EntityManager manager;

    @Transactional(readOnly=true)
    public List<WhatsAppExportacaoDTO> exportarCadastro(Estrutura e, LocalDate inicio, LocalDate fim, WhatsAppAtendente atendente, WhatsAppEtapaEnum etapa, Set<String> cnpjs, Set<String> numeros) {
        StringBuilder sql = new StringBuilder();
        sql.append("select w.id id,w.numero,w.cpf_cnpj,w.email,w.nome,w.funcao,w.data_hora_criacao,wa.id atendimento_id").append(" from whatsapp w \n").append(" join whatsapp_conta wc on (w.whatsapp_conta_id=wc.id) \n").append(" left join whatsapp_atendimento wa on (wa.whatsapp_id=w.id) \n").append(" WHERE wc.estrutura_id=:estruturaId").append(" AND w.data_hora_criacao>=:inicio").append(" AND w.data_hora_criacao<=:fim");
        if (cnpjs != null && !cnpjs.isEmpty()) {
            sql.append(" and w.cpf_cnpj in :cnpjs");
        }
        if (numeros != null && !numeros.isEmpty()) {
            sql.append(" and w.numero in :numeros");
        }
        if (atendente != null) {
            sql.append(" and w.ultimo_atendente_id=:atendenteId");
        }
        if (etapa != null) {
            sql.append(" and w.etapa=:etapa");
        }
        sql.append(" group by w.id");
        Query query = this.manager.createNativeQuery(sql.toString(), WhatsAppExportacaoDTO.class);
        query.setParameter("inicio", (Object)inicio.atStartOfDay());
        query.setParameter("fim", (Object)DateTimeUtil.getEndOfDay((LocalDate)fim));
        query.setParameter("estruturaId", (Object)e.getId());
        if (cnpjs != null && !cnpjs.isEmpty()) {
            query.setParameter("cnpjs", cnpjs);
        }
        if (numeros != null && !numeros.isEmpty()) {
            query.setParameter("numeros", numeros);
        }
        if (atendente != null) {
            query.setParameter("atendenteId", (Object)atendente.getId());
        }
        if (etapa != null) {
            query.setParameter("etapa", (Object)etapa.name());
        }
        return query.getResultList();
    }
}

