/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.whatsapp.service;

import br.com.system.app.features.estrutura.model.Estrutura;
import br.com.system.app.features.estrutura.model.EstruturaUsuario;
import br.com.system.app.features.whatsapp.model.WhatsApp;
import br.com.system.app.features.whatsapp.model.WhatsAppAtendimento;
import br.com.system.app.features.whatsapp.model.WhatsAppConta;
import br.com.system.app.features.whatsapp.model.WhatsAppDayOff;
import br.com.system.app.features.whatsapp.model.WhatsAppEtapaEnum;
import br.com.system.app.features.whatsapp.repository.WhatsAppDayOffRepository;
import br.com.system.app.features.whatsapp.service.WhatsAppAtendimentoService;
import br.com.system.app.features.whatsapp.service.WhatsAppSendService;
import br.com.system.app.features.whatsapp.service.WhatsAppService;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
public class WhatsAppDayOffService
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Autowired
    private WhatsAppDayOffRepository repository;
    @Autowired
    private WhatsAppSendService send;
    @Autowired
    private WhatsAppService whatsAppService;
    @Autowired
    private WhatsAppAtendimentoService whatsAppAtendimentoService;

    public WhatsAppDayOff save(WhatsAppDayOff wdo) {
        return (WhatsAppDayOff)this.repository.save((Object)wdo);
    }

    public void delete(WhatsAppDayOff wdo) {
        this.repository.delete((Object)wdo);
    }

    public List<WhatsAppDayOff> getDayOff(Estrutura estrutura, Pageable pageable) {
        return this.repository.findByWhatsappContaEstrutura(estrutura, pageable);
    }

    public long countDayOff(Estrutura estrutura) {
        return this.repository.countByWhatsappContaEstrutura(estrutura);
    }

    public WhatsAppDayOff getDayOffByData(Estrutura estrutura, LocalDate data) {
        return this.repository.findByWhatsappContaEstruturaAndData(estrutura, data);
    }

    public boolean validaDayOff(WhatsAppAtendimento wa, EstruturaUsuario master) {
        WhatsAppDayOff dOff = this.getDayOffByData(wa.getWhatsapp().getWhatsappConta().getEstrutura(), LocalDate.now());
        if (dOff != null) {
            WhatsApp w = wa.getWhatsapp();
            wa.setEtapa(WhatsAppEtapaEnum.FECHADO);
            wa.setDataHoraFim(LocalDateTime.now());
            wa.setFechado(true);
            w.setEtapa(WhatsAppEtapaEnum.FECHADO);
            this.send.sendMessageText(wa, master, dOff.getMensagem());
            this.whatsAppAtendimentoService.save(wa);
            this.whatsAppService.save(w);
            return false;
        }
        return true;
    }

    public void deleteByWhatsappConta(WhatsAppConta conta) {
        this.repository.deleteByWhatsappConta(conta);
    }
}

