/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.whatsapp.service.bot;

import br.com.system.app.features.estrutura.model.EstruturaUsuario;
import br.com.system.app.features.whatsapp.model.WhatsApp;
import br.com.system.app.features.whatsapp.model.WhatsAppAtendimento;
import br.com.system.app.features.whatsapp.model.WhatsAppEtapaEnum;
import br.com.system.app.features.whatsapp.model.WhatsAppMensagem;
import br.com.system.app.features.whatsapp.service.WhatsAppAtendenteService;
import br.com.system.app.features.whatsapp.service.WhatsAppAtendimentoService;
import br.com.system.app.features.whatsapp.service.WhatsAppControleService;
import br.com.system.app.features.whatsapp.service.WhatsAppSendService;
import br.com.system.app.features.whatsapp.service.WhatsAppService;
import br.com.system.app.features.whatsapp.service.WhatsAppTimeService;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class WhatsAppBotIOCM1772
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Autowired
    private WhatsAppService whatsAppService;
    @Autowired
    private WhatsAppSendService sendService;
    @Autowired
    private WhatsAppAtendenteService whatsAppAtendenteService;
    @Autowired
    private WhatsAppAtendimentoService whatsAppAtendimentoService;
    @Autowired
    private WhatsAppControleService whatsAppControleService;
    @Autowired
    private WhatsAppTimeService whatsAppTimeService;

    public void botDefault(WhatsAppAtendimento wa, EstruturaUsuario master, String resposta) {
        WhatsApp w = wa.getWhatsapp();
        if (wa.getEtapa().equals((Object)WhatsAppEtapaEnum.INICIAL)) {
            this.sendService.sendMessageText(wa, master, "Seja bem-vindo(a). Sou a assistente virtual e vou facilitar seu atendimento.\ud83d\ude03\nPor favor anote seu protocolo: #" + wa.getPedido().getNumero());
            this.sendService.sendMessageText(wa, master, "Sobre seus dados pessoais:\nAo prosseguir com o atendimento, manifesta livre, e de forma inequ\u00edvoca, que concorda com o tratamento de seus dados pessoais pelo INSTITUTO DE OLHOS CRISTIANO MENDON\u00c7A (IOCM)\nTermo de consentimento de Tratamento de Dados Pessoais, em conformidade com a Lei Geral de Prote\u00e7\u00e3o de Dados Pessoais - LGPD. Consoante ao artigo 5\u00ba inciso XII da Lei 13.709.");
            this.sendService.sendMessageText(wa, master, "Certo, vamos prosseguir com o seu atendimento \ud83d\ude09");
            this.sendOptions(w, wa, master, "Escolha a op\u00e7\u00e3o que voc\u00ea deseja atendimento");
        } else if (wa.getEtapa().equals((Object)WhatsAppEtapaEnum.OPCOES)) {
            if (resposta.contains("Consultas/Exames") || resposta.contains("D\u00favidas/Cirurgias") || resposta.contains("Lentes de Contato") || resposta.contains("Outros Assuntos")) {
                this.enviarAtendente(w, wa, master);
            } else {
                this.sendOptions(w, wa, master, "Op\u00e7\u00e3o Inv\u00e1lida.Escolha a op\u00e7\u00e3o que voc\u00ea deseja atendimento");
            }
        }
        w.setDataErro(null);
        w.setErros(Integer.valueOf(0));
        this.whatsAppService.save(w);
        this.whatsAppAtendimentoService.save(wa);
    }

    private void sendOptions(WhatsApp w, WhatsAppAtendimento wa, EstruturaUsuario master, String texto) {
        ArrayList<String> buttons = new ArrayList<String>();
        buttons.add("Consultas/Exames");
        buttons.add("D\u00favidas/Cirurgias");
        buttons.add("Lentes de Contato\ufe0f");
        this.sendService.sendButton(wa, master, texto, "", buttons);
        buttons.clear();
        buttons.add("Outros Assuntos");
        this.sendService.sendButton(wa, master, "Clique abaixo para outros assuntos", "", buttons);
        w.setEtapa(WhatsAppEtapaEnum.OPCOES);
        wa.setEtapa(WhatsAppEtapaEnum.OPCOES);
    }

    private void enviarAtendente(WhatsApp w, WhatsAppAtendimento wa, EstruturaUsuario master) {
        EstruturaUsuario eu = this.whatsAppAtendenteService.getAtendenteOnline(w, master);
        WhatsAppMensagem m = this.whatsAppTimeService.isAlmoco(wa.getWhatsapp().getWhatsappConta()) ? this.whatsAppTimeService.sendAlmoco(wa) : this.sendService.sendMessageText(wa, master, "Muito obrigado. Sua solicita\u00e7\u00e3o j\u00e1 foi direcionada para um atendente e logo ele ir\u00e1 interagir aqui mesmo.");
        w.setEtapa(WhatsAppEtapaEnum.ATENDENTE);
        w.setUltimoAtendente(eu);
        wa.setAtendente(eu);
        wa.setDataHoraTransferencia(LocalDateTime.now());
        wa.setFechado(false);
        wa.setEtapa(WhatsAppEtapaEnum.ATENDENTE);
        this.whatsAppControleService.gravarNova(m, m.getStatus());
    }
}

