/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.commons.timer;

import br.com.system.commons.strings.PaddingUtil;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class Timer {
    private static final Logger LOGGER = Logger.getLogger(Timer.class.getName());
    private static final String DEFAULT_MESSAGE = "Elapsed time";
    private String message;
    private long start;
    private long end;
    private boolean debugEnabled = true;
    private int stackCounter = 0;

    public Timer() {
        this(DEFAULT_MESSAGE);
    }

    public Timer(String msg) {
        this.message = msg;
        this.start();
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setDebugEnabled(boolean debug) {
        this.debugEnabled = debug;
    }

    public void start() {
        this.resetStackCounter();
        this.start = System.nanoTime();
        if (this.debugEnabled && !this.message.equals(DEFAULT_MESSAGE)) {
            LOGGER.info(this.message);
        }
    }

    public void start(String message) {
        this.message = message;
        this.start();
    }

    public void stop() {
        ++this.stackCounter;
        this.end = System.nanoTime();
        this.doLog();
    }

    public void stop(String message) {
        ++this.stackCounter;
        this.message = message;
        this.stop();
    }

    private void doLog() {
        ++this.stackCounter;
        if (this.debugEnabled) {
            StackTraceElement caller = this.getTimerCaller();
            String logMessage = this.createlogMessage();
            if (caller != null) {
                LOGGER.logp(Level.INFO, caller.getClassName(), caller.getMethodName(), logMessage);
            } else {
                LOGGER.info(logMessage);
            }
        }
        this.resetStackCounter();
    }

    private String createlogMessage() {
        String out = this.getTimeMsgTemplate(new Object[]{this.getElapsedSeconds(), this.getElapsedNano()});
        out = PaddingUtil.paddingLeft((String)out, (char)' ', (int)this.getTimeMsgMaxSize());
        out = String.format(out + " : %s", this.message);
        return out;
    }

    public long getElapsedNano() {
        return this.end - this.start;
    }

    private Double getElapsedSeconds() {
        return (double)this.getElapsedNano() / Math.pow(10.0, 9.0);
    }

    private String getTimeMsgTemplate(Object ... args) {
        return String.format("Completed in %fs (%d ns)", args);
    }

    private int getTimeMsgMaxSize() {
        return this.getTimeMsgTemplate(new Object[]{0.0, 0}).length();
    }

    private StackTraceElement getTimerCaller() {
        ++this.stackCounter;
        int threadGetStackTraceStackCount = 1;
        StackTraceElement[] stack = Thread.currentThread().getStackTrace();
        if (stack.length >= this.stackCounter + threadGetStackTraceStackCount) {
            return stack[this.stackCounter + threadGetStackTraceStackCount];
        }
        return null;
    }

    private void resetStackCounter() {
        this.stackCounter = 0;
    }
}

