/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.integreation.conexaoExterna;

import br.com.system.commons.Base64Util;
import br.com.system.integreation.conexaoExterna.ClientHttp;
import br.com.system.integreation.conexaoExterna.ContextHttp;
import br.com.system.integreation.conexaoExterna.Headers;
import br.com.system.integreation.conexaoExterna.RequestParameters;
import br.com.system.integreation.conexaoExterna.exception.ExternalConnectionException;
import br.com.system.integreation.conexaoExterna.method.Delete;
import br.com.system.integreation.conexaoExterna.method.Get;
import br.com.system.integreation.conexaoExterna.method.Post;
import br.com.system.integreation.conexaoExterna.method.Put;
import br.com.system.integreation.conexaoExterna.method.Request;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.cookie.Cookie;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.json.JSONObject;

public class ExternalConnection {
    private final ClientHttp httpClient = new ClientHttp();
    private RequestParameters requestParameters;
    private Headers header;
    private final ContextHttp httpContext = new ContextHttp();
    private Request requestMethod;
    private String BaseUrl;
    private HttpHost serverProxy;
    private Integer timeOut;
    private JSONObject jsonParameters;

    public CredentialsProvider getDefaultProxyCredentials() {
        BasicCredentialsProvider credentialsPovider = new BasicCredentialsProvider();
        credentialsPovider.setCredentials(new AuthScope("IP_PROXY", 22993), (Credentials)new UsernamePasswordCredentials("USUARIO", "SENHA"));
        return credentialsPovider;
    }

    public ClientHttp getClient() {
        return this.httpClient;
    }

    public Integer getTimeOut() {
        this.timeOut = this.timeOut == null ? 300000 : this.timeOut;
        return this.timeOut;
    }

    public ExternalConnection setTimeOut(Integer timeOut) {
        this.timeOut = timeOut;
        return this;
    }

    public HttpHost getDefaultProxy() {
        return new HttpHost("196.18.198.13", 22993);
    }

    public ExternalConnection setServerProxy(HttpHost serverProxy) {
        this.serverProxy = serverProxy;
        return this;
    }

    public HttpHost getServerProxy() {
        return this.serverProxy;
    }

    public ExternalConnection() {
        this.httpContext.setDefaultHttpContext();
    }

    public String getBasicHttp(String apiKey) {
        try {
            return "Basic " + Base64Util.strToBase64((String)apiKey);
        }
        catch (UnsupportedEncodingException e) {
            return "";
        }
    }

    public ContextHttp getContext() {
        return this.httpContext;
    }

    public List<Cookie> getCookies() {
        return this.httpContext.getCookies();
    }

    public String getCookieValue(String name) {
        Cookie c = this.getCookie(name);
        if (c != null) {
            return c.getValue();
        }
        return "";
    }

    public Cookie getCookie(String name) {
        List cookies = this.httpContext.getCookies();
        for (Cookie cooky : cookies) {
            if (!cooky.getName().equals(name)) continue;
            return cooky;
        }
        return null;
    }

    public ExternalConnection addCookie(String key, String value) {
        this.getContext().addCookie(key, value);
        return this;
    }

    public ExternalConnection addCookie(Cookie cookie) {
        this.getContext().addCookie(cookie);
        return this;
    }

    public ExternalConnection removeCookie(String name) {
        this.getContext().removeCookie(name);
        return this;
    }

    public ExternalConnection removeAllCookies() {
        this.getContext().removeAllCookies();
        return this;
    }

    public ExternalConnection setDefaultHttpClient() throws NoSuchAlgorithmException, KeyStoreException, KeyManagementException, IOException {
        this.httpClient.setDefaultHttpClient();
        return this;
    }

    public ExternalConnection setHttpClientWithCredentials(CredentialsProvider credentialsProvider) throws NoSuchAlgorithmException, KeyStoreException, KeyManagementException, IOException {
        this.httpClient.setHttpClientWithCredentials(credentialsProvider);
        return this;
    }

    public ExternalConnection setDefaultHttpContext() {
        this.httpContext.setDefaultHttpContext();
        return this;
    }

    public ExternalConnection setHttpClient(CloseableHttpClient client) {
        this.httpClient.setHttpClient(client);
        return this;
    }

    public ExternalConnection addHeader(String key, String value) {
        this.getHeaders().add(key, value);
        return this;
    }

    public ExternalConnection addHeaderDefault(String key, String value) {
        this.getHeaders().addDefault(key, value);
        return this;
    }

    public ExternalConnection removeHeader(String key) {
        this.getHeaders().remove(key);
        return this;
    }

    public Headers getHeaders() {
        if (this.header == null) {
            this.header = new Headers();
        }
        return this.header;
    }

    public ExternalConnection setResetHeaders(boolean resetHeaders) {
        this.header.setResetHeaders(resetHeaders);
        return this;
    }

    public ExternalConnection addParameter(String key, String value) {
        if (key != null) {
            this.getParameters().add(key, value);
        }
        return this;
    }

    public ExternalConnection addParameter(String urlQueryParams) {
        if (urlQueryParams != null) {
            this.getParameters().addUrlQueryParams(urlQueryParams);
        }
        return this;
    }

    public ExternalConnection addParameterDefault(String key, String value) {
        if (key != null) {
            this.getParameters().addDefault(key, value);
        }
        return this;
    }

    public ExternalConnection delParameter(String key) {
        this.getParameters().del(key);
        return this;
    }

    public ExternalConnection setJsonParameters(JSONObject jsonParameters) {
        this.jsonParameters = jsonParameters;
        this.getParameters().setJsonParameters(jsonParameters);
        return this;
    }

    public JSONObject getJSONObject() {
        return this.jsonParameters;
    }

    public ExternalConnection setMultipartParameters(File file) {
        this.getParameters().setMultiPartParameters(file);
        return this;
    }

    public ExternalConnection setBody(String body) {
        this.getParameters().setBody(body);
        return this;
    }

    public RequestParameters getParameters() {
        if (this.requestParameters == null) {
            this.requestParameters = new RequestParameters();
        }
        return this.requestParameters;
    }

    public void resetParametersNow() {
        this.requestParameters.resetparams();
    }

    public void resetparamsDefault() {
        this.requestParameters.resetparamsDefault();
    }

    public ExternalConnection setResetParameters(boolean resetParameters) {
        this.requestParameters.setResetParameters(resetParameters);
        return this;
    }

    public Request executePost() throws ExternalConnectionException {
        return this.executePost("");
    }

    public Request executePost(String url) throws ExternalConnectionException {
        return this.setRequestMethod((Request)new Post(this.getUrl(url), this.getServerProxy(), this.getTimeOut())).execute();
    }

    public Request executePut() throws ExternalConnectionException {
        return this.executePut("");
    }

    public Request executePut(String url) throws ExternalConnectionException {
        return this.setRequestMethod((Request)new Put(this.getUrl(url), this.getServerProxy(), this.getTimeOut())).execute();
    }

    public Request executeGet() throws ExternalConnectionException {
        return this.executeGet("");
    }

    public Request executeGet(String url) throws ExternalConnectionException {
        return this.setRequestMethod((Request)new Get(this.getUrl(url), this.getServerProxy(), this.getTimeOut())).execute();
    }

    public Request executeDelete(String url) throws ExternalConnectionException {
        return this.setRequestMethod((Request)new Delete(this.getUrl(url), this.getServerProxy(), this.getTimeOut())).execute();
    }

    public ExternalConnection addDownloadParameters() {
        this.addParameter("Content-Type", "application/x-www-form-urlencoded");
        this.addParameter("User-Agent", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.0)");
        this.addParameter("Accept-Encoding", "gzip, deflate");
        this.addParameter("Accept-Language", "pt-BR,pt;q=0.8,en-US;q=0.5,en;q=0.3");
        this.addParameter("Accept", "text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8");
        return this;
    }

    private Request execute() throws ExternalConnectionException {
        return this.requestMethod.setClient(this.httpClient).setContext(this.httpContext).setHeaders(this.getHeaders()).setParameters(this.getParameters()).execute();
    }

    private ExternalConnection setRequestMethod(Request method) {
        if (this.requestMethod != null) {
            this.requestMethod.releaseConnection();
        }
        this.requestMethod = method;
        return this;
    }

    public ExternalConnection setBaseUrl(String baseUrl) {
        this.BaseUrl = baseUrl;
        return this;
    }

    public String getUrl(String url) throws ExternalConnectionException {
        if (!((String)url).contains("http")) {
            if (this.getBaseUrl().isEmpty()) {
                throw new ExternalConnectionException("Url inv\u00e1lida.");
            }
            url = this.getBaseUrl() + (String)url;
        }
        return url;
    }

    private String getBaseUrl() {
        return this.BaseUrl;
    }
}

